/*
 * Decompiled with CFR 0.152.
 */
package com.hello2morrow.sonargraph.core.model.event;

import com.hello2morrow.sonargraph.core.model.event.Modification;
import com.hello2morrow.sonargraph.core.model.event.SoftwareSystemEvent;
import com.hello2morrow.sonargraph.core.model.system.ISoftwareSystemProvider;
import java.util.EnumSet;

public final class SoftwareSystemModifiedEvent
extends SoftwareSystemEvent {
    private final EnumSet<Modification> m_modification = EnumSet.noneOf(Modification.class);
    private final boolean m_restoredFromHistory;

    public SoftwareSystemModifiedEvent(ISoftwareSystemProvider provider, EnumSet<Modification> modification, boolean restoredFromHistory) {
        super(provider);
        assert (provider != null) : "Parameter 'provider' of method 'SoftwareSystemModifiedEvent' must not be null";
        assert (provider.hasSoftwareSystem()) : "Software system must be available!";
        assert (modification != null && !modification.isEmpty()) : "Parameter 'modification' of method 'SoftwareSystemModifiedEvent' must not be empty";
        this.m_modification.addAll(modification);
        this.m_restoredFromHistory = restoredFromHistory;
    }

    public SoftwareSystemModifiedEvent(ISoftwareSystemProvider provider, EnumSet<Modification> modification) {
        this(provider, modification, false);
    }

    public EnumSet<Modification> getModification() {
        return this.m_modification;
    }

    public boolean restoredFromHistory() {
        return this.m_restoredFromHistory;
    }
}

