/*
 * Decompiled with CFR 0.152.
 */
package com.hello2morrow.sonargraph.core.model.event;

import com.hello2morrow.sonargraph.core.model.event.ModifiablePathEvent;
import com.hello2morrow.sonargraph.core.model.path.IModifiableDirectory;
import com.hello2morrow.sonargraph.core.model.system.ISoftwareSystemProvider;
import com.hello2morrow.sonargraph.foundation.file.IPathType;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;

public abstract class ModifiableDirectoryPathEvent
extends ModifiablePathEvent {
    private final Set<IModifiableDirectory> m_modifiableDirectories;

    public ModifiableDirectoryPathEvent(ISoftwareSystemProvider provider, Collection<IModifiableDirectory> modifiableDirectories) {
        super(provider);
        assert (modifiableDirectories != null && !modifiableDirectories.isEmpty()) : "Parameter 'modifiableDirectories' of method 'ModifiableDirectoryPathEvent' must not be empty";
        this.m_modifiableDirectories = new HashSet<IModifiableDirectory>(modifiableDirectories);
    }

    public final Set<IModifiableDirectory> getModifiableDirectoryPaths() {
        return Collections.unmodifiableSet(this.m_modifiableDirectories);
    }

    @Override
    public final boolean containsPathOfType(IPathType ... pathTypes) {
        assert (pathTypes != null) : "Parameter 'pathTypes' of method 'containsPathOfType' must not be null";
        for (IModifiableDirectory nextModifiableDirectory : this.m_modifiableDirectories) {
            IPathType[] iPathTypeArray = pathTypes;
            int n = pathTypes.length;
            int n2 = 0;
            while (n2 < n) {
                IPathType nextPathType = iPathTypeArray[n2];
                if (nextModifiableDirectory.getDirectoryType().equals(nextPathType)) {
                    return true;
                }
                ++n2;
            }
        }
        return false;
    }
}

