/*
 * Decompiled with CFR 0.152.
 */
package com.hello2morrow.sonargraph.core.model.event;

import com.hello2morrow.sonargraph.core.model.common.IAnalyzerId;
import com.hello2morrow.sonargraph.core.model.event.AnalyzerEvent;
import com.hello2morrow.sonargraph.core.model.system.ISoftwareSystemProvider;
import java.util.EnumSet;

public final class AnalyzerModificationEvent
extends AnalyzerEvent {
    private final EnumSet<AnalyzerModification> m_modification = EnumSet.noneOf(AnalyzerModification.class);
    private final IAnalyzerId m_analyzerId;

    public AnalyzerModificationEvent(ISoftwareSystemProvider provider, EnumSet<AnalyzerModification> modification, IAnalyzerId id) {
        super(provider);
        assert (provider != null) : "Parameter 'provider' of method 'AnalyzerModificationEvent' must not be null";
        assert (provider.hasSoftwareSystem()) : "Software system must be available!";
        assert (modification != null && !modification.isEmpty()) : "Parameter 'modification' of method 'AnalyzerModificationEvent' must not be empty";
        this.m_modification.addAll(modification);
        this.m_analyzerId = id;
    }

    public EnumSet<AnalyzerModification> getModification() {
        return this.m_modification;
    }

    public IAnalyzerId getAnalyzerId() {
        return this.m_analyzerId;
    }

    public static enum AnalyzerModification {
        ISSUE_MODIFIED,
        METRIC_VALUE_ADDED,
        METRIC_DESCRIPTOR_ADDED;

    }
}

