/*
 * Decompiled with CFR 0.152.
 */
package com.hello2morrow.sonargraph.core.model.architecture;

import com.hello2morrow.sonargraph.core.model.architecture.ArchitectureElement;
import com.hello2morrow.sonargraph.core.model.architecture.IArtifact;
import com.hello2morrow.sonargraph.core.model.element.IAssignableToArtifact;
import com.hello2morrow.sonargraph.core.model.element.NamedElement;
import com.hello2morrow.sonargraph.core.model.path.FilePath;
import com.hello2morrow.sonargraph.core.model.programming.CoreParserDependencyType;
import gnu.trove.set.hash.THashSet;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.EnumSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Consumer;

public final class Interface
extends ArchitectureElement {
    private final List<Interface> m_exportedInterfaces = new ArrayList<Interface>();
    private EnumSet<CoreParserDependencyType> m_allowedDependencyTypes = null;
    private final boolean m_isAutoDefined;
    private final boolean m_isOptional;

    public Interface(NamedElement parent, String name, FilePath definingFile, int line, boolean autoDefined, boolean optional) {
        super(parent, name, definingFile, line);
        this.m_isAutoDefined = autoDefined;
        this.m_isOptional = optional;
    }

    public Interface(NamedElement parent, Interface other) {
        super(parent, other);
        this.m_allowedDependencyTypes = other.m_allowedDependencyTypes;
        this.m_isAutoDefined = other.m_isAutoDefined;
        this.m_isOptional = other.m_isOptional;
    }

    public void finishCloning(Interface original, Map<NamedElement, NamedElement> cloneMap) {
        original.m_exportedInterfaces.stream().map(iface -> (Interface)cloneMap.get(iface)).filter(iface -> iface != null).forEach(iface -> {
            boolean bl = this.m_exportedInterfaces.add((Interface)iface);
        });
    }

    public void addExportedInterface(Interface iface) {
        assert (iface != null) : "Parameter 'iface' of method 'addExportedInterface' must not be null";
        if (!this.m_exportedInterfaces.contains(iface)) {
            this.m_exportedInterfaces.add(iface);
        }
    }

    public Collection<Interface> getExportedInterfaces() {
        return Collections.unmodifiableCollection(this.m_exportedInterfaces);
    }

    @Override
    public boolean isDefinedInEnclosingElement() {
        return !this.m_isAutoDefined;
    }

    @Override
    public boolean isOptional() {
        return this.m_isOptional;
    }

    @Override
    public boolean isAutoDefined() {
        return this.m_isAutoDefined;
    }

    public boolean isRequired() {
        return this.getParent(IArtifact.class, new Class[0]).isRequired();
    }

    private boolean includes(IAssignableToArtifact assignable, Consumer<EnumSet<CoreParserDependencyType>> restrictionConsumer, Set<Interface> visited) {
        if (!visited.add(this)) {
            return false;
        }
        if (this.contains(assignable)) {
            if (this.m_allowedDependencyTypes != null) {
                restrictionConsumer.accept(this.m_allowedDependencyTypes);
            }
            return true;
        }
        for (Interface export : this.m_exportedInterfaces) {
            EnumSet<CoreParserDependencyType> restrictions;
            if (!export.includes(assignable, arg_0 -> Interface.lambda$3(restrictions = this.m_allowedDependencyTypes != null ? EnumSet.copyOf(this.m_allowedDependencyTypes) : EnumSet.allOf(CoreParserDependencyType.class), arg_0), visited)) continue;
            if (restrictions.size() < CoreParserDependencyType.values().length) {
                restrictionConsumer.accept(restrictions);
            }
            return true;
        }
        return false;
    }

    public boolean includes(IAssignableToArtifact assignable, Consumer<EnumSet<CoreParserDependencyType>> restrictionConsumer) {
        assert (assignable != null) : "Parameter 'component' of method 'contains' must not be null";
        return this.includes(assignable, restrictionConsumer, (Set<Interface>)new THashSet());
    }

    @Override
    public boolean isEmpty() {
        if (!super.isEmpty()) {
            return false;
        }
        for (Interface iface : this.m_exportedInterfaces) {
            if (iface.isEmpty()) continue;
            return false;
        }
        return true;
    }

    private void collectExportedInterfacesRecursively(Set<Interface> result) {
        for (Interface iface : this.m_exportedInterfaces) {
            if (!result.add(iface)) continue;
            iface.collectExportedInterfacesRecursively(result);
        }
    }

    public Set<Interface> getExportedInterfacesRecursively() {
        THashSet result = new THashSet();
        this.collectExportedInterfacesRecursively((Set<Interface>)result);
        return result;
    }

    public void setAllowedDependencyTypes(EnumSet<CoreParserDependencyType> currentDependencyTypes) {
        this.m_allowedDependencyTypes = currentDependencyTypes;
    }

    public boolean hasDependencyTypeRestrictions() {
        return this.m_allowedDependencyTypes != null;
    }

    public Set<CoreParserDependencyType> getAllowedDependencyTypes() {
        if (this.m_allowedDependencyTypes != null) {
            return Collections.unmodifiableSet(this.m_allowedDependencyTypes);
        }
        return EnumSet.allOf(CoreParserDependencyType.class);
    }

    public boolean isAllowedDependencyType(CoreParserDependencyType type) {
        return this.m_allowedDependencyTypes.contains((Object)type);
    }

    @Override
    public String getFullyQualifiedNamePart() {
        return this.getShortName() + "(Interface)";
    }

    @Override
    public Collection<IAssignableToArtifact> getAssignedElements() {
        ArrayList<IAssignableToArtifact> result = new ArrayList<IAssignableToArtifact>();
        result.addAll(super.getAssignedElements());
        for (Interface iface : this.m_exportedInterfaces) {
            result.addAll(iface.getAssignedElements());
        }
        return result;
    }

    @Override
    public int getNumberOfAssignedElements() {
        int result = super.getNumberOfAssignedElements();
        for (Interface iface : this.m_exportedInterfaces) {
            result += iface.getNumberOfAssignedElements();
        }
        return result;
    }

    @Override
    public void override(FilePath definingFile, int line) {
        this.m_exportedInterfaces.clear();
        this.m_allowedDependencyTypes = null;
        super.override(definingFile, line);
    }

    @Override
    public boolean ignoreInModelRepresentation() {
        return true;
    }

    public void markAsReferenced() {
        this.getParent(IArtifact.class, new Class[0]).markAsReferenced();
    }

    void reset() {
        this.m_exportedInterfaces.clear();
    }

    @Override
    public final void accept(NamedElement.INamedElementVisitor visitor) {
        assert (visitor != null) : "Parameter 'visitor' of method 'accept' must not be null";
        if (visitor instanceof IVisitor) {
            ((IVisitor)visitor).visitInterface(this);
        } else {
            super.accept(visitor);
        }
    }

    private static /* synthetic */ void lambda$3(EnumSet enumSet, EnumSet childRestrictions) {
        boolean bl = enumSet.retainAll(childRestrictions);
    }

    public static interface IVisitor
    extends NamedElement.INamedElementVisitor {
        public void visitInterface(Interface var1);
    }
}

