/*
 * Decompiled with CFR 0.152.
 */
package com.hello2morrow.sonargraph.core.model.annotation;

import com.hello2morrow.sonargraph.core.model.annotation.AnnotationValue;
import com.hello2morrow.sonargraph.core.model.element.NamedElement;
import com.hello2morrow.sonargraph.core.model.snapshot.ISnapshotReader;
import com.hello2morrow.sonargraph.core.model.snapshot.ISnapshotWriter;
import com.hello2morrow.sonargraph.core.model.snapshot.SnapshotArgument;
import com.hello2morrow.sonargraph.foundation.utilities.StringUtility;
import java.io.IOException;

public final class ClassAnnotation
extends AnnotationValue
implements AnnotationValue.IClassAnnotation,
ISnapshotWriter.IWriteStorableContext {
    private String m_className;
    private NamedElement m_type;
    private int m_lineNumber;

    public ClassAnnotation() {
    }

    public ClassAnnotation(String className, int lineNumber) {
        assert (className != null && className.length() > 0) : "Parameter 'className' of method 'ClassAnnotation' must not be empty";
        this.m_className = className;
        this.m_lineNumber = lineNumber;
    }

    @Override
    public void removeInvalidElementReference() {
        if (this.m_type != null && !this.m_type.isValid()) {
            this.m_type = null;
        }
    }

    @Override
    public NamedElement getReferencedElement() {
        return this.m_type;
    }

    @Override
    public String getClassName() {
        if (this.m_type != null) {
            return this.m_type.getName();
        }
        return this.m_className;
    }

    @Override
    public NamedElement getType() {
        return this.m_type;
    }

    public void setType(NamedElement type) {
        this.m_type = type;
    }

    public int getLineNumber() {
        return this.m_lineNumber;
    }

    @Override
    public void store(ISnapshotWriter writer) throws IOException {
        assert (writer != null) : "Parameter 'writer' of method 'store' must not be null";
        writer.writeString(this.m_className);
        writer.write(this.m_type, this);
        writer.writeInt(this.m_lineNumber);
    }

    @Override
    public void addDiagnosticInfo(StringBuilder builder) {
        assert (builder != null) : "Parameter 'builder' of method 'addDiagnosticInfo' must not be null";
        builder.append("Class Name: ").append(this.m_className).append("\n");
    }

    @Override
    public void retrieve(ISnapshotReader reader) throws ClassNotFoundException, IOException {
        assert (reader != null) : "Parameter 'reader' of method 'retrieve' must not be null";
        this.m_className = reader.readString();
        this.m_type = reader.read(NamedElement.class, new SnapshotArgument[0]);
        this.m_lineNumber = reader.readInt();
    }

    @Override
    public AnnotationValue.IClassAnnotation asClass() {
        return this;
    }

    @Override
    public void accept(AnnotationValue.AnnotationVisitor v) {
        if (v instanceof IVisitor) {
            ((IVisitor)((Object)v)).visitClassAnnotation(this);
        } else {
            super.accept(v);
        }
    }

    public String toString() {
        return this.m_className + ".class";
    }

    @Override
    public String getDebugInfo() {
        StringBuilder builder = new StringBuilder(super.getDebugInfo());
        builder.append(StringUtility.LINE_SEPARATOR);
        builder.append("Class name: ");
        builder.append(this.m_className);
        builder.append(" [");
        if (this.m_type == null) {
            builder.append("null");
        } else if (!this.m_type.isValid()) {
            builder.append("reference not valid");
        } else {
            builder.append("reference is valid - full name: ").append(this.m_type.getName());
        }
        builder.append("]");
        return builder.toString();
    }

    public static interface IVisitor {
        public void visitClassAnnotation(ClassAnnotation var1);
    }
}

