/*
 * Decompiled with CFR 0.152.
 */
package com.hello2morrow.sonargraph.core.controller.system.treemap;

import com.hello2morrow.sonargraph.core.controller.system.treemap.FloatValueAdapter;
import com.hello2morrow.sonargraph.core.model.element.NamedElement;
import com.hello2morrow.sonargraph.core.model.path.IComponent;
import com.hello2morrow.sonargraph.core.model.path.SourceFile;

final class ComponentAggregatorFloatValueAdapter
extends FloatValueAdapter {
    private final FloatValueAdapter m_valueAdapter;

    ComponentAggregatorFloatValueAdapter(FloatValueAdapter valueAdapter) {
        assert (valueAdapter != null) : "Parameter 'valueAdapter' of method 'ComponentAggregatorFloatValueAdapter' must not be null";
        this.m_valueAdapter = valueAdapter;
    }

    @Override
    public final float getValue(NamedElement element) {
        assert (element != null && element instanceof IComponent) : "Unexpected class in method 'get': " + String.valueOf(element);
        float value = 0.0f;
        if (element instanceof SourceFile) {
            float nextValue = this.m_valueAdapter.getValue(element);
            if (nextValue != -1.0f) {
                value += nextValue;
            }
        } else {
            for (SourceFile next : element.getChildren(SourceFile.class)) {
                float nextValue = this.m_valueAdapter.getValue(next);
                if (nextValue == -1.0f) continue;
                value += nextValue;
            }
        }
        return value <= 0.0f ? -1.0f : value;
    }
}

