/*
 * Decompiled with CFR 0.152.
 */
package com.hello2morrow.sonargraph.core.controller.system.report;

import com.hello2morrow.sonargraph.core.model.element.Element;
import com.hello2morrow.sonargraph.core.model.element.NamedElement;
import com.hello2morrow.sonargraph.core.model.element.NamedElementVisitor;
import com.hello2morrow.sonargraph.core.model.system.diff.IDiffElement;
import com.hello2morrow.sonargraph.core.model.system.qualitygate.AbstractQualityGateElementCheckResult;
import com.hello2morrow.sonargraph.core.model.system.qualitygate.QualityGateIssueConditionCheckResult;
import com.hello2morrow.sonargraph.core.model.system.qualitygate.QualityGateMetricConditionCheckResult;
import com.hello2morrow.sonargraph.core.model.system.qualitygate.QualityGateResult;
import com.hello2morrow.sonargraph.core.model.system.qualitygate.QualityGateResultStatus;
import java.util.Set;

public class QualityGateElementCollector {
    public static void collect(QualityGateResult result, final Set<Element> issuesAffectingQualityGateConditions, final Set<Element> metricValuesAffectingQualityGateConditions) {
        assert (result != null) : "Parameter 'result' of method 'extractQualityGateElements' must not be null";
        assert (issuesAffectingQualityGateConditions != null) : "Parameter 'issuesAffectingQualityGateConditions' of method 'collectQualityGateElements' must not be null";
        assert (metricValuesAffectingQualityGateConditions != null) : "Parameter 'metricValuesAffectingQualityGateConditions' of method 'collectQualityGateElements' must not be null";
        NamedElementVisitor qualityGateResultVisitor = new NamedElementVisitor(){

            @Override
            public void visitNamedElement(NamedElement element) {
                Set<Element> resultingElements;
                AbstractQualityGateElementCheckResult checkResult;
                if (element instanceof AbstractQualityGateElementCheckResult && (checkResult = (AbstractQualityGateElementCheckResult)element).getResultStatus() != QualityGateResultStatus.FAILED) {
                    return;
                }
                if (element instanceof QualityGateIssueConditionCheckResult) {
                    resultingElements = ((QualityGateIssueConditionCheckResult)element).getResultingElements();
                    for (Element next : resultingElements) {
                        if (next instanceof IDiffElement) {
                            issuesAffectingQualityGateConditions.add(((IDiffElement)((Object)next)).getCurrentElement());
                            continue;
                        }
                        issuesAffectingQualityGateConditions.add(next);
                    }
                    return;
                }
                if (element instanceof QualityGateMetricConditionCheckResult) {
                    resultingElements = ((QualityGateMetricConditionCheckResult)element).getResultingElements();
                    for (Element next : resultingElements) {
                        if (!$assertionsDisabled && !(next instanceof IDiffElement)) {
                            throw new AssertionError((Object)("unexpected element class: " + next.getClass().getCanonicalName()));
                        }
                        metricValuesAffectingQualityGateConditions.add(((IDiffElement)((Object)next)).getCurrentElement());
                    }
                    return;
                }
                super.visitNamedElement(element);
            }
        };
        result.accept(qualityGateResultVisitor);
    }
}

