/*
 * Decompiled with CFR 0.152.
 */
package com.hello2morrow.sonargraph.core.controller.system.explorationview;

import com.hello2morrow.sonargraph.core.controller.system.explorationview.ArchitecturalViewElementResolver;
import com.hello2morrow.sonargraph.core.controller.system.explorationview.AssignableToArtifactCollector;
import com.hello2morrow.sonargraph.core.controller.system.explorationview.AssignableToArtifactRenameValidator;
import com.hello2morrow.sonargraph.core.controller.system.explorationview.IAssignmentToArtifactCheck;
import com.hello2morrow.sonargraph.core.controller.system.explorationview.IExplorationViewRepresentationHandler;
import com.hello2morrow.sonargraph.core.controller.system.explorationview.NodeHandler;
import com.hello2morrow.sonargraph.core.controller.system.explorationview.NonRecursiveDeleteVisitor;
import com.hello2morrow.sonargraph.core.controller.system.explorationview.RecursiveDeleteVisitor;
import com.hello2morrow.sonargraph.core.controller.system.explorationview.RecursiveElementCreationValidator;
import com.hello2morrow.sonargraph.core.controller.system.explorationview.RecursiveNodeMoveRenameProcessor;
import com.hello2morrow.sonargraph.core.controller.system.explorationview.RepresentationHandler;
import com.hello2morrow.sonargraph.core.foundation.common.base.Language;
import com.hello2morrow.sonargraph.core.model.common.PresentationMode;
import com.hello2morrow.sonargraph.core.model.element.NamedElement;
import com.hello2morrow.sonargraph.core.model.element.ParentMode;
import com.hello2morrow.sonargraph.core.model.explorationview.ArchitecturalViewElement;
import com.hello2morrow.sonargraph.core.model.explorationview.ArchitecturalViewFile;
import com.hello2morrow.sonargraph.core.model.explorationview.ArchitecturalViewNode;
import com.hello2morrow.sonargraph.core.model.explorationview.ArtifactNode;
import com.hello2morrow.sonargraph.core.model.explorationview.ArtifactPropertiesNode;
import com.hello2morrow.sonargraph.core.model.explorationview.AssignableNode;
import com.hello2morrow.sonargraph.core.model.explorationview.AssignableToArtifactNode;
import com.hello2morrow.sonargraph.core.model.explorationview.DescendingRelativePathComparator;
import com.hello2morrow.sonargraph.core.model.explorationview.ExpandSelectInfo;
import com.hello2morrow.sonargraph.core.model.explorationview.ExplorationViewRepresentation;
import com.hello2morrow.sonargraph.core.model.explorationview.ExplorationViewStructureMode;
import com.hello2morrow.sonargraph.core.model.explorationview.IAssignableContainer;
import com.hello2morrow.sonargraph.core.model.explorationview.IAssignableTarget;
import com.hello2morrow.sonargraph.core.model.explorationview.MoveElementsInfo;
import com.hello2morrow.sonargraph.core.model.explorationview.NodeLocation;
import com.hello2morrow.sonargraph.core.model.explorationview.NonRecursiveNonLeafNode;
import com.hello2morrow.sonargraph.core.model.explorationview.NonRecursiveNonRootNode;
import com.hello2morrow.sonargraph.core.model.explorationview.NonRecursiveRootNode;
import com.hello2morrow.sonargraph.core.model.explorationview.ParserDependencyEndPoints;
import com.hello2morrow.sonargraph.core.model.explorationview.ProgrammingElementAggregatingNode;
import com.hello2morrow.sonargraph.core.model.explorationview.RecursiveElementCreationInfo;
import com.hello2morrow.sonargraph.core.model.explorationview.RecursiveNode;
import com.hello2morrow.sonargraph.core.model.explorationview.RenameElementInfo;
import com.hello2morrow.sonargraph.core.model.path.IComponent;
import com.hello2morrow.sonargraph.core.model.path.PhysicalRecursiveElement;
import com.hello2morrow.sonargraph.core.model.programming.ParserDependency;
import com.hello2morrow.sonargraph.core.model.programming.ProgrammingElement;
import com.hello2morrow.sonargraph.core.model.refactoring.AssignableToArtifactRefactoringDescriptor;
import com.hello2morrow.sonargraph.core.model.refactoring.ElementRefactoringDescriptor;
import com.hello2morrow.sonargraph.core.model.refactoring.RecursiveElementRefactoringDescriptor;
import gnu.trove.set.hash.THashSet;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import java.util.TreeSet;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class StructureHandler
implements IExplorationViewRepresentationHandler {
    private static Logger LOGGER = LoggerFactory.getLogger(StructureHandler.class);

    private StructureHandler() {
    }

    private static ArchitecturalViewElement getOrCreateTargetParentUnderneath(ArchitecturalViewElement target, AssignableNode toBeAssigned, Set<ArchitecturalViewNode> checkForRemoval, Set<ArchitecturalViewNode> newParents, boolean recursively, ExplorationViewRepresentation representation) {
        assert (target != null) : "Parameter 'target' of method 'getOrCreateTargetParentUnderneath' must not be null";
        assert (toBeAssigned != null) : "Parameter 'toBeAssigned' of method 'getOrCreateTargetParentUnderneath' must not be null";
        assert (checkForRemoval != null) : "Parameter 'checkForRemoval' of method 'getOrCreateTargetParentUnderneath' must not be null";
        assert (newParents != null) : "Parameter 'newParents' of method 'getOrCreateTargetParentUnderneath' must not be null";
        assert (representation != null) : "Parameter 'representation' of method 'getOrCreateTargetParentUnderneath' must not be null";
        Collection<ProgrammingElement> toBeAssignedProgrammingElements = toBeAssigned.getRelevantProgrammingElements(recursively);
        for (ProgrammingElementAggregatingNode nextPreviousParent : toBeAssigned.getParents(ProgrammingElementAggregatingNode.class, ExplorationViewRepresentation.class)) {
            nextPreviousParent.removeProgrammingElements(toBeAssignedProgrammingElements);
            checkForRemoval.add(nextPreviousParent);
        }
        if (target instanceof ArchitecturalViewNode) {
            newParents.add((ArchitecturalViewNode)target);
        }
        if (target instanceof ProgrammingElementAggregatingNode) {
            ((ProgrammingElementAggregatingNode)target).addProgrammingElements(toBeAssignedProgrammingElements);
        }
        target.getParents(ProgrammingElementAggregatingNode.class, ExplorationViewRepresentation.class).forEach(n -> n.addProgrammingElements(toBeAssignedProgrammingElements));
        List<ArchitecturalViewNode> parents = toBeAssigned.getParents(ArchitecturalViewNode.class, ArtifactPropertiesNode.class, ExplorationViewRepresentation.class);
        if (parents.isEmpty()) {
            return target;
        }
        Collections.reverse(parents);
        ArrayDeque<ArchitecturalViewNode> sourceParents = new ArrayDeque<ArchitecturalViewNode>(parents);
        ArchitecturalViewElement currentTargetParent = target;
        while (!sourceParents.isEmpty()) {
            ArchitecturalViewNode nextSourceParent = sourceParents.pop();
            List<ArchitecturalViewNode> currentTargetParentChildren = currentTargetParent.getChildren(ArchitecturalViewNode.class);
            ArchitecturalViewNode foundTargetParentChild = null;
            for (ArchitecturalViewNode nextTargetParentChild : currentTargetParentChildren) {
                if (!nextTargetParentChild.getUnderlyingElements().equals(nextSourceParent.getUnderlyingElements())) continue;
                foundTargetParentChild = nextTargetParentChild;
                break;
            }
            if (foundTargetParentChild == null) {
                foundTargetParentChild = nextSourceParent.copy(currentTargetParent);
                currentTargetParent.addChild(foundTargetParentChild);
            } else if (!representation.inModification() && foundTargetParentChild != nextSourceParent) {
                assert (foundTargetParentChild != nextSourceParent) : "Same instances";
                if (nextSourceParent.isExpanded()) {
                    foundTargetParentChild.setExpanded(true);
                }
                if (nextSourceParent.isSelected()) {
                    foundTargetParentChild.setSelected(true);
                }
            }
            newParents.add(foundTargetParentChild);
            if (foundTargetParentChild instanceof ProgrammingElementAggregatingNode) {
                ((ProgrammingElementAggregatingNode)foundTargetParentChild).addProgrammingElements(toBeAssignedProgrammingElements);
            }
            currentTargetParent = foundTargetParentChild;
        }
        return currentTargetParent;
    }

    static void integrate(ArchitecturalViewNode currentSourceNode, ArchitecturalViewElement currentTargetParent, Set<ArchitecturalViewNode> checkForRemoval, boolean recursively, ExplorationViewRepresentation representation) {
        assert (currentSourceNode != null) : "Parameter 'currentSourceNode' of method 'integrate' must not be null";
        assert (currentTargetParent != null) : "Parameter 'currentTargetParent' of method 'integrate' must not be null";
        assert (representation != null) : "Parameter 'representation' of method 'integrate' must not be null";
        if (!currentSourceNode.supportsCopy()) {
            currentSourceNode.changeParentAndOrPos(currentTargetParent, -1);
            RepresentationHandler.resetRelativePath(currentSourceNode);
        } else {
            if (checkForRemoval != null) {
                checkForRemoval.add(currentSourceNode);
            }
            List<ArchitecturalViewNode> children = currentTargetParent.getChildren(ArtifactPropertiesNode.EXCLUDE_ARTIFACT_PROPERTY_NODES, ArchitecturalViewNode.class);
            ArchitecturalViewNode matchingTargetChild = null;
            for (ArchitecturalViewNode nextChild : children) {
                if (!nextChild.getUnderlyingElements().equals(currentSourceNode.getUnderlyingElements())) continue;
                matchingTargetChild = nextChild;
                break;
            }
            if (matchingTargetChild == null) {
                matchingTargetChild = currentSourceNode.copy(currentTargetParent);
                currentTargetParent.addChild(matchingTargetChild);
                NodeHandler.addEmptyNodeProgrammingElement(matchingTargetChild, currentTargetParent);
            } else if (!representation.inModification() && matchingTargetChild != currentSourceNode) {
                assert (matchingTargetChild != currentSourceNode) : "Same instances";
                if (currentSourceNode.isExpanded()) {
                    matchingTargetChild.setExpanded(true);
                }
                if (currentSourceNode.isSelected()) {
                    matchingTargetChild.setSelected(true);
                }
            }
            if (matchingTargetChild instanceof ProgrammingElementAggregatingNode) {
                ((ProgrammingElementAggregatingNode)matchingTargetChild).addProgrammingElements(currentSourceNode.getProgrammingElements());
                NodeHandler.removeEmptyNodeProgrammingElement(currentSourceNode, matchingTargetChild);
            }
            if (recursively) {
                for (ArchitecturalViewNode nextCurrentSourceNodeChild : currentSourceNode.getChildren(ArchitecturalViewNode.class)) {
                    StructureHandler.integrate(nextCurrentSourceNodeChild, matchingTargetChild, checkForRemoval, recursively, representation);
                }
            } else {
                for (ArchitecturalViewNode nextCurrentSourceNodeChild : currentSourceNode.getChildren(ArchitecturalViewNode.class)) {
                    if (nextCurrentSourceNodeChild.isRecursive()) continue;
                    StructureHandler.integrate(nextCurrentSourceNodeChild, matchingTargetChild, checkForRemoval, recursively, representation);
                }
            }
        }
    }

    static IAssignableTarget getAssignableTargetForAssign(ArchitecturalViewElement target) {
        assert (target != null) : "Parameter 'target' of method 'getAssignableTargetForAssign' must not be null";
        if (target instanceof IAssignableTarget) {
            return (IAssignableTarget)((Object)target);
        }
        IAssignableTarget assignableTarget = target.getParent(IAssignableTarget.class, ArchitecturalViewFile.class);
        assert (assignableTarget != null) : "'assignableTarget' of method 'getAssignableTargetForMove' must not be null";
        return assignableTarget;
    }

    static void assign(PresentationMode presentationMode, Collection<? extends AssignableNode> assignables, IAssignableContainer assignableContainer, ExplorationViewRepresentation representation) {
        assert (assignables != null && !assignables.isEmpty()) : "Parameter 'assignables' of method 'assign' must not be empty";
        assert (assignableContainer != null) : "Parameter 'assignableContainer' of method 'assign' must not be null";
        assert (representation != null) : "Parameter 'representation' of method 'assign' must not be null";
        ArchitecturalViewElement target = assignableContainer.getArchitecturalViewElement();
        LOGGER.debug("Assign " + assignables.size() + " assignable(s) to '" + target.getElementInfo(true, false) + "'");
        LinkedHashSet<ArchitecturalViewNode> affectedParents = new LinkedHashSet<ArchitecturalViewNode>();
        TreeSet<ArchitecturalViewNode> checkForRemoval = new TreeSet<ArchitecturalViewNode>(new DescendingRelativePathComparator());
        LinkedHashSet<ArchitecturalViewNode> newParents = new LinkedHashSet<ArchitecturalViewNode>();
        for (AssignableNode assignableNode : assignables) {
            boolean recursively = NodeHandler.recursively(assignableNode, presentationMode) == null;
            ArchitecturalViewElement nextTargetParent = StructureHandler.getOrCreateTargetParentUnderneath(target, assignableNode, checkForRemoval, newParents, recursively, representation);
            StructureHandler.integrate(assignableNode, nextTargetParent, checkForRemoval, recursively, representation);
            ArchitecturalViewNode currentNodeParent = assignableNode.getParent(ArchitecturalViewNode.class, new Class[0]);
            while (currentNodeParent != null) {
                affectedParents.add(currentNodeParent);
                currentNodeParent = currentNodeParent.getParent(ArchitecturalViewNode.class, new Class[0]);
            }
        }
        Iterator iterator = checkForRemoval.iterator();
        while (iterator.hasNext()) {
            ArchitecturalViewNode next = (ArchitecturalViewNode)iterator.next();
            if (!next.supportsCopy() || next.hasAllNodeChildren(n -> true)) continue;
            next.remove();
            iterator.remove();
        }
        NodeHandler.finishAssignMoveRename(affectedParents, representation);
        if (!representation.inModification()) {
            newParents.forEach(p -> NodeHandler.updateExpandableState(p, representation));
            if (target instanceof ArchitecturalViewNode) {
                NodeHandler.updateExpandableState((ArchitecturalViewNode)target, representation);
                if (target.isExpandable()) {
                    ((ArchitecturalViewNode)target).setExpanded(true);
                }
            }
        }
        LOGGER.debug("Assign " + assignables.size() + " assignable(s) to '" + target.getElementInfo(true, false) + "' - done");
    }

    static RecursiveElementCreationInfo isCreateElementPossible(ArchitecturalViewElement element) {
        assert (element != null) : "Parameter 'element' of method 'isCreateElementPossible' must not be null";
        ExplorationViewRepresentation representation = RepresentationHandler.getRepresentation(Collections.singletonList(element));
        if (representation != null && representation.getPresentationMode() != PresentationMode.NONE && !element.isExternal() && (element instanceof RecursiveNode || element instanceof NonRecursiveNonLeafNode)) {
            RecursiveElementRefactoringDescriptor descriptor = representation.getRecursiveElementCreationDescriptor(element.getFirstUnderlyingElement().getLanguage());
            NonRecursiveNonLeafNode rootNode = switch (representation.getStructureMode()) {
                case ExplorationViewStructureMode.PHYSICAL_WITHOUT_ROOT_DIRECTORIES, ExplorationViewStructureMode.LOGICAL_MODULE_SCOPE, ExplorationViewStructureMode.LOGICAL_SYSTEM_SCOPE -> element.getParent(NonRecursiveRootNode.class, ParentMode.SELF_OR_FIRST_PARENT);
                case ExplorationViewStructureMode.PHYSICAL_WITH_ROOT_DIRECTORIES -> element.getParent(NonRecursiveNonRootNode.class, ParentMode.SELF_OR_FIRST_PARENT);
                default -> {
                    if (!$assertionsDisabled) {
                        throw new AssertionError((Object)("Unhandled mode: " + String.valueOf((Object)representation.getStructureMode())));
                    }
                    yield null;
                }
            };
            if (rootNode != null) {
                String nameProposal = element instanceof RecursiveNode ? element.getFirstUnderlyingElement().getName() : "";
                RecursiveElementCreationValidator validator = new RecursiveElementCreationValidator(descriptor, RecursiveNodeMoveRenameProcessor.getNameValidator(descriptor), rootNode, representation);
                return new RecursiveElementCreationInfo(validator, validator.isNewElementNameValid(nameProposal).isFailure() ? "" : nameProposal);
            }
        }
        return null;
    }

    static RecursiveNode createRecursiveElement(RecursiveElementCreationInfo creationInfo, String name, ExplorationViewRepresentation representation) {
        assert (creationInfo != null) : "Parameter 'creationInfo' of method 'createRecursiveElement' must not be null";
        assert (name != null && name.length() > 0) : "Parameter 'name' of method 'createRecursiveElement' must not be empty";
        assert (representation != null) : "Parameter 'representation' of method 'createRecursiveElement' must not be null";
        assert (creationInfo.getValidator().isValid("", name).isSuccess()) : "Not a valid name: " + name;
        RecursiveElementRefactoringDescriptor recursiveDescriptor = creationInfo.getValidator().getDescriptor();
        AssignableToArtifactRefactoringDescriptor assignableDescriptor = representation.getAssignableToArtifactCreationDescriptor(recursiveDescriptor.getLanguage());
        LOGGER.debug("Create recursive element '" + name + "' (" + String.valueOf(recursiveDescriptor) + ")");
        RecursiveNodeMoveRenameProcessor processor = new RecursiveNodeMoveRenameProcessor(representation, recursiveDescriptor, assignableDescriptor, creationInfo.getValidator().getRootNode());
        RecursiveNode leafNode = processor.getOrCreateRecursiveElement(name, representation);
        LOGGER.debug("Create recursive element '" + name + "' (" + String.valueOf(recursiveDescriptor) + ") - done");
        return leafNode;
    }

    static boolean isDeleteRefactoringPossible(AssignableNode node) {
        assert (node != null) : "Parameter 'node' of method 'isDeleteRefactoringPossible' must not be null";
        return !node.isExternal() && !node.isCreated() && (node instanceof AssignableToArtifactNode || node instanceof RecursiveNode) && node.getFirstUnderlyingElement().isDefinedInEnclosingElement();
    }

    private static void deleteUnreferencedExternalNodes(Set<ProgrammingElement> externalProgrammingElements, ExplorationViewRepresentation representation) {
        assert (externalProgrammingElements != null) : "Parameter 'externalProgrammingElements' of method 'deleteUnreferencedExternalNodes' must not be null";
        assert (representation != null) : "Parameter 'representation' of method 'deleteUnreferencedExternalNodes' must not be null";
        if (!externalProgrammingElements.isEmpty()) {
            LOGGER.debug("Delete unreferenced external nodes and collect deleted external programming elements");
            THashSet allToProcess = new THashSet(externalProgrammingElements);
            for (ProgrammingElement next : externalProgrammingElements) {
                for (ProgrammingElement programmingElement : next.getChildrenRecursively(ProgrammingElement.class, new Class[0])) {
                    if (representation.isExcluded(programmingElement)) continue;
                    allToProcess.add(programmingElement);
                }
                for (ProgrammingElement programmingElement : next.getParents(ProgrammingElement.class, PhysicalRecursiveElement.class, IComponent.class)) {
                    if (representation.isExcluded(programmingElement)) continue;
                    allToProcess.add(programmingElement);
                }
            }
            TreeSet<ArchitecturalViewNode> nodeParentsOfDeletedNodes = new TreeSet<ArchitecturalViewNode>(new DescendingRelativePathComparator());
            THashSet deletedExternalProgrammingElements = new THashSet();
            for (ProgrammingElement programmingElement : allToProcess) {
                Iterator<ParserDependency> nextDepIterator = programmingElement.getDependencyIterator();
                boolean hasIncomingDependencies = false;
                while (nextDepIterator.hasNext()) {
                    ParserDependency nextParserDependency = nextDepIterator.next();
                    if (!representation.includeIncomingParserDependency(programmingElement, nextParserDependency, false, null).isIncluded()) continue;
                    hasIncomingDependencies = true;
                    break;
                }
                if (hasIncomingDependencies) continue;
                ArchitecturalViewNode nextExternalLeafNode = representation.getLeafNode(programmingElement);
                assert (nextExternalLeafNode != null) : "'nextExternalLeafNode' of method 'applyDeleteRefactoring' must not be null";
                if (!nextExternalLeafNode.isDeleted()) {
                    nextExternalLeafNode.setDeleted(true);
                    nextExternalLeafNode.setDeletedRecycled(false);
                }
                deletedExternalProgrammingElements.add(programmingElement);
                ArchitecturalViewNode currentParent = nextExternalLeafNode.getParent(ArchitecturalViewNode.class, ParentMode.ONLY_DIRECT_PARENT);
                while (currentParent != null) {
                    currentParent = nodeParentsOfDeletedNodes.add(currentParent) ? currentParent.getParent(ArchitecturalViewNode.class, ParentMode.ONLY_DIRECT_PARENT) : null;
                }
            }
            if (!deletedExternalProgrammingElements.isEmpty()) {
                representation.addDeletedProgrammingElements((Collection<ProgrammingElement>)deletedExternalProgrammingElements);
            }
            if (!nodeParentsOfDeletedNodes.isEmpty()) {
                for (ArchitecturalViewNode architecturalViewNode : nodeParentsOfDeletedNodes) {
                    if (architecturalViewNode.hasNodeChildren(n -> !n.isDeleted())) continue;
                    architecturalViewNode.setDeleted(true);
                    architecturalViewNode.setDeletedRecycled(false);
                }
            }
            LOGGER.debug("Delete unreferenced external nodes and collect deleted external programming elements - done");
        }
    }

    static void delete(PresentationMode presentationMode, Set<ParserDependency> dependencies, ExplorationViewRepresentation representation) {
        assert (presentationMode != null) : "Parameter 'presentationMode' of method 'delete' must not be null";
        assert (dependencies != null && !dependencies.isEmpty()) : "Parameter 'dependencies' of method 'delete' must not be empty";
        assert (representation != null) : "Parameter 'representation' of method 'delete' must not be null";
        LOGGER.debug("Delete (refactoring) of " + dependencies.size() + (dependencies.size() == 1 ? " parser dependency" : " parser dependencies"));
        representation.addDeletedParserDependencies(dependencies);
        THashSet affectedExternalProgrammingElements = new THashSet();
        for (ParserDependency next : dependencies) {
            ProgrammingElement nextTo;
            ArchitecturalViewNode nextLeafNode = representation.getLeafNode(next.getFrom());
            assert (nextLeafNode != null) : "'nextLeafNode' of method 'delete' must not be null";
            if (!nextLeafNode.isRefactored()) {
                nextLeafNode.setRefactored(true);
                AssignableNode currentParent = nextLeafNode.getParent(AssignableNode.class, ParentMode.ONLY_DIRECT_PARENT);
                while (currentParent != null) {
                    if (!currentParent.isRefactored()) {
                        currentParent.setRefactored(true);
                        currentParent = currentParent.getParent(AssignableNode.class, ParentMode.ONLY_DIRECT_PARENT);
                        continue;
                    }
                    currentParent = null;
                }
            }
            if (!(nextTo = next.getTo()).isExternal()) continue;
            affectedExternalProgrammingElements.add(nextTo);
        }
        StructureHandler.deleteUnreferencedExternalNodes((Set<ProgrammingElement>)affectedExternalProgrammingElements, representation);
        LOGGER.debug("Delete (refactoring) of " + dependencies.size() + (dependencies.size() == 1 ? " parser dependency" : " parser dependencies") + " - done");
    }

    static void delete(PresentationMode presentationMode, Collection<AssignableNode> assignables, ExplorationViewRepresentation representation) {
        assert (presentationMode != null) : "Parameter 'presentationMode' of method 'delete' must not be null";
        assert (assignables != null && !assignables.isEmpty()) : "Parameter 'assignables' of method 'delete' must not be empty";
        assert (representation != null) : "Parameter 'representation' of method 'delete' must not be null";
        LOGGER.debug("Delete (refactoring) of " + assignables.size() + " node(s)");
        TreeSet<ArchitecturalViewNode> nodeParentsOfDeletedNodes = new TreeSet<ArchitecturalViewNode>(new DescendingRelativePathComparator());
        THashSet deletedProgrammingElements = new THashSet();
        for (AssignableNode next : assignables) {
            assert (!next.isDeleted()) : "Already deleted: " + next.getElementInfo();
            assert (StructureHandler.isDeleteRefactoringPossible(next)) : "Deleted refactoring not possible: " + next.getElementInfo();
            RecursiveNode recursiveNode = NodeHandler.recursively(next, presentationMode);
            if (recursiveNode == null) {
                next.accept(new RecursiveDeleteVisitor());
                deletedProgrammingElements.addAll(next.getRelevantProgrammingElements(true));
            } else {
                recursiveNode.setSelected(false);
                recursiveNode.setExpanded(false);
                recursiveNode.setDeletedFlat(true);
                recursiveNode.setDeletedRecycled(false);
                recursiveNode.getChildren().forEach(c -> c.accept(new NonRecursiveDeleteVisitor()));
                if (!recursiveNode.hasAllNodeChildren(c -> c instanceof RecursiveNode && !c.isDeleted())) {
                    recursiveNode.setDeleted(true);
                } else {
                    recursiveNode.setRefactored(true);
                }
                deletedProgrammingElements.addAll(next.getRelevantProgrammingElements(false));
            }
            AssignableNode currentParent = next.getParent(AssignableNode.class, ParentMode.ONLY_DIRECT_PARENT);
            while (currentParent != null) {
                currentParent = nodeParentsOfDeletedNodes.add(currentParent) ? currentParent.getParent(AssignableNode.class, ParentMode.ONLY_DIRECT_PARENT) : null;
            }
        }
        ParserDependencyEndPoints endPoints = new ParserDependencyEndPoints();
        THashSet affectedExternalProgrammingElements = new THashSet();
        for (ProgrammingElement programmingElement : deletedProgrammingElements) {
            Iterator<ParserDependency> nextDepIterator = programmingElement.getDependencyIterator();
            while (nextDepIterator.hasNext()) {
                ParserDependency nextParserDependency = nextDepIterator.next();
                if (representation.includeOutgoingParserDependency(programmingElement, nextParserDependency, false, endPoints).isIncluded() && endPoints.getTo().isExternal()) {
                    affectedExternalProgrammingElements.add(endPoints.getTo());
                }
                endPoints.reset();
            }
        }
        assert (deletedProgrammingElements != null && !deletedProgrammingElements.isEmpty()) : "'deletedProgrammingElements' of method 'delete' must not be empty";
        representation.addDeletedProgrammingElements((Collection<ProgrammingElement>)deletedProgrammingElements);
        if (!nodeParentsOfDeletedNodes.isEmpty()) {
            for (AssignableNode assignableNode : nodeParentsOfDeletedNodes) {
                if (assignableNode.isRecursive()) {
                    if (!assignableNode.hasNodeChildren(n -> !n.isDeleted())) {
                        assignableNode.setDeleted(true);
                        assignableNode.setDeletedRecycled(false);
                        continue;
                    }
                    assignableNode.setRefactored(true);
                    continue;
                }
                assignableNode.setRefactored(true);
            }
        }
        StructureHandler.deleteUnreferencedExternalNodes((Set<ProgrammingElement>)affectedExternalProgrammingElements, representation);
        LOGGER.debug("Delete (refactoring) " + assignables.size() + " node(s) - done");
    }

    static boolean isMoveRefactoringPossible(AssignableNode node) {
        assert (node != null) : "Parameter 'node' of method 'isMoveRefactoringPossible' must not be null";
        return !node.isExternal() && (node instanceof AssignableToArtifactNode || node instanceof RecursiveNode);
    }

    private static boolean isMoveRefactoringTargetPossible(AssignableNode node, ArchitecturalViewElement target, ExplorationViewStructureMode structureMode) {
        assert (node != null) : "Parameter 'node' of method 'isMoveRefactoringPossible' must not be null";
        assert (target != null) : "Parameter 'target' of method 'isMoveRefactoringPossible' must not be null";
        assert (!target.isExternal()) : "'target' is external";
        assert (structureMode != null) : "Parameter 'structureMode' of method 'isMoveRefactoringPossible' must not be null";
        if (node == target || target.hasAsParent(node, false)) {
            return false;
        }
        if (node instanceof AssignableToArtifactNode) {
            return target instanceof RecursiveNode;
        }
        if (node instanceof RecursiveNode) {
            if (target instanceof RecursiveNode) {
                return true;
            }
            switch (structureMode) {
                case PHYSICAL_WITHOUT_ROOT_DIRECTORIES: 
                case LOGICAL_MODULE_SCOPE: 
                case LOGICAL_SYSTEM_SCOPE: {
                    return target instanceof NonRecursiveRootNode;
                }
                case PHYSICAL_WITH_ROOT_DIRECTORIES: {
                    return target instanceof NonRecursiveNonRootNode;
                }
            }
            assert (false) : "Unhandled structure mode: " + String.valueOf((Object)structureMode);
        }
        return false;
    }

    static void isMoveToTargetPossible(Set<AssignableNode> assignables, MoveElementsInfo moveElementsInfo, IAssignmentToArtifactCheck check, ExplorationViewRepresentation representation) {
        ArchitecturalViewNode refactoringTarget;
        assert (assignables != null && !assignables.isEmpty()) : "Parameter 'assignables' of method 'isMoveToTargetPossible' must not be empty";
        assert (moveElementsInfo != null) : "Parameter 'moveElementsInfo' of method 'isMoveToTargetPossible' must not be null";
        assert (check != null) : "Parameter 'check' of method 'isMoveToTargetPossible' must not be null";
        assert (representation != null) : "Parameter 'representation' of method 'isMoveToTargetPossible' must not be null";
        ArchitecturalViewElement target = moveElementsInfo.getTargetInfo().getTarget();
        LOGGER.debug("Is move " + assignables.size() + " assignable(s) to target " + target.getElementInfo(true, false) + " possible");
        IAssignableTarget assignmentTarget = target instanceof IAssignableTarget ? (IAssignableTarget)((Object)target) : null;
        ArchitecturalViewNode architecturalViewNode = refactoringTarget = assignmentTarget == null && target instanceof ArchitecturalViewNode && !target.isExternal() ? (ArchitecturalViewNode)target : null;
        if (assignmentTarget != null || refactoringTarget != null) {
            if (refactoringTarget != null) {
                assert (assignmentTarget == null) : "'assignmentTarget' of method 'isMoveToTargetPossible' must be null";
                THashSet alreadyContained = new THashSet(refactoringTarget.getNodeChildren(n -> !n.isDeleted(), false));
                IAssignableTarget assignableTargetParent = refactoringTarget.getParent(IAssignableTarget.class, ExplorationViewRepresentation.class);
                for (AssignableNode next : assignables) {
                    boolean add = true;
                    if (!StructureHandler.isMoveRefactoringPossible(next)) {
                        moveElementsInfo.addNotMovable(next, "Does not support move refactoring.");
                        add = false;
                    } else if (!StructureHandler.isMoveRefactoringTargetPossible(next, target, moveElementsInfo.getRepresentation().getStructureMode())) {
                        moveElementsInfo.addNotMovable(next, "'" + target.getName() + "' is not a valid move refactoring target.");
                        add = false;
                    } else if (!next.getLanguage().equals(target.getLanguage())) {
                        moveElementsInfo.addNotMovable(next, "'" + target.getName() + "' is not a valid move refactoring target (different languages).");
                        add = false;
                    } else if (next instanceof AssignableToArtifactNode) {
                        if (alreadyContained.contains(next)) {
                            moveElementsInfo.addNotMovable(next, "Already underneath parent '" + target.getName() + "'");
                            add = false;
                        } else {
                            for (ArchitecturalViewNode nextExistingChild : alreadyContained) {
                                if (!nextExistingChild.getShortName().equalsIgnoreCase(next.getShortName())) continue;
                                moveElementsInfo.addNotMovable(next, "'" + target.getName() + "' already contains a child with name '" + nextExistingChild.getShortName() + "'.");
                                add = false;
                                break;
                            }
                        }
                    } else {
                        assert (next instanceof RecursiveNode) : "Unexpected class: " + String.valueOf(next.getClass());
                        RecursiveNode moveTarget = ArchitecturalViewElementResolver.resolveByShortName(Collections.singletonList(next.getShortName()), RecursiveNode.class, target, representation);
                        if (moveTarget != null) {
                            if (moveTarget != next) {
                                AssignableToArtifactRefactoringDescriptor assignableDescriptor = moveElementsInfo.getRepresentation().getAssignableToArtifactCreationDescriptor(next.getLanguage());
                                RecursiveNodeMoveRenameProcessor.State state = RecursiveNodeMoveRenameProcessor.check(assignableDescriptor, (RecursiveNode)next, moveTarget, representation);
                                if (state == RecursiveNodeMoveRenameProcessor.State.CONTAINS_ONLY_COLLIDING) {
                                    moveElementsInfo.addNotMovable(next, "All contained assignables collide with existing ones in '" + target.getName() + "'.");
                                    add = false;
                                }
                            } else {
                                moveElementsInfo.addNotMovable(next, "Already exists in the root container '" + target.getName() + "'.");
                                add = false;
                            }
                        }
                    }
                    if (!add) continue;
                    IAssignableTarget nextSourceAssignableTarget = next.getParent(IAssignableTarget.class, ExplorationViewRepresentation.class);
                    if (nextSourceAssignableTarget != assignableTargetParent) {
                        RecursiveNode parentRecursiveNode;
                        boolean assignmentOnly = false;
                        if (refactoringTarget.isRecursive() && (parentRecursiveNode = next.getParent(RecursiveNode.class, ExplorationViewRepresentation.class, ArtifactNode.class)) != null && refactoringTarget.getName().equals(parentRecursiveNode.getName()) && NodeHandler.inSameNonRecursiveParent(parentRecursiveNode, (RecursiveNode)refactoringTarget)) {
                            assignmentOnly = true;
                        }
                        if (assignmentOnly) {
                            moveElementsInfo.addToBeAssigned(next);
                            continue;
                        }
                        moveElementsInfo.addToBeRefactoredAndAssigned(next);
                        continue;
                    }
                    moveElementsInfo.addToBeRefactored(next);
                }
            } else {
                for (AssignableNode next : assignables) {
                    IAssignableTarget nextSourceAssignableTarget = next.getParent(IAssignableTarget.class, ExplorationViewRepresentation.class);
                    if (nextSourceAssignableTarget != assignmentTarget) {
                        boolean atLeastOneCanBeAssigned = true;
                        if (assignmentTarget instanceof ArtifactNode) {
                            atLeastOneCanBeAssigned = check.isPossible(next, (ArtifactNode)assignmentTarget, moveElementsInfo);
                        }
                        if (!atLeastOneCanBeAssigned) continue;
                        moveElementsInfo.addToBeAssigned(next);
                        continue;
                    }
                    moveElementsInfo.addNotMovable(next, "'" + next.getName() + "' already assigned to '" + assignmentTarget.getArchitecturalViewElement().getName() + "'");
                }
            }
        } else {
            assignables.forEach(a -> moveElementsInfo.addNotMovable((AssignableNode)a, "'" + target.getName() + "' is not a suitable target for neither an assignment nor a refactoring."));
        }
        LOGGER.debug("Is move " + assignables.size() + " assignable(s) to target " + target.getElementInfo(true, false) + " possible - done:" + String.valueOf(moveElementsInfo));
    }

    private static void move(AssignableToArtifactNode node, ArchitecturalViewElement target, AssignableToArtifactRefactoringDescriptor descriptor, ExplorationViewRepresentation representation) {
        assert (node != null) : "Parameter 'node' of method 'move' must not be null";
        assert (target != null) : "Parameter 'target' of method 'move' must not be null";
        assert (descriptor != null) : "Parameter 'descriptor' of method 'move' must not be null";
        assert (representation != null) : "Parameter 'representation' of method 'move' must not be null";
        NodeLocation originalLocation = representation.getOriginalLocation(node);
        if (originalLocation == null) {
            representation.addOriginalLocation(node, NodeHandler.createLocation(node));
            node.changeParentAndOrPos(target, -1);
            RepresentationHandler.resetRelativePath(node);
            node.setRefactored(true);
            node.setPrototypeElement(descriptor.createPrototype(target.getFirstUnderlyingElement(), node.getShortName(), node.getFirstUnderlyingElement()));
        } else {
            node.changeParentAndOrPos(target, -1);
            RepresentationHandler.resetRelativePath(node);
            if (originalLocation.equals(NodeHandler.createLocation(node))) {
                node.setPrototypeElement(null);
                node.setRefactored(false);
                representation.removeOriginalLocation(node);
            }
        }
    }

    private static List<String> move(RecursiveNodeMoveRenameProcessor processor, RecursiveNode source, ArchitecturalViewNode target, final AssignableToArtifactRefactoringDescriptor descriptor, boolean recursively, final ExplorationViewRepresentation representation) {
        assert (processor != null) : "Parameter 'processor' of method 'move' must not be null";
        assert (source != null) : "Parameter 'source' of method 'move' must not be null";
        assert (target != null) : "Parameter 'target' of method 'move' must not be null";
        assert (source != target) : "Same instances";
        assert (descriptor != null) : "Parameter 'descriptor' of method 'move' must not be null";
        assert (representation != null) : "Parameter 'representation' of method 'move' must not be null";
        final ArrayList<String> collidingElementInfo = new ArrayList<String>();
        final TreeSet<ArchitecturalViewNode> affectedAssignableNodeParents = new TreeSet<ArchitecturalViewNode>(new DescendingRelativePathComparator());
        processor.process(source, target, recursively, new RecursiveNodeMoveRenameProcessor.IMoveableConsumer(){

            @Override
            public void consume(RecursiveNode source, ArchitecturalViewNode target, List<AssignableToArtifactNode> moveables, List<AssignableToArtifactNode> colliding) {
                if (!$assertionsDisabled && source == null) {
                    throw new AssertionError((Object)"Parameter 'source' of method 'consume' must not be null");
                }
                if (!$assertionsDisabled && target == null) {
                    throw new AssertionError((Object)"Parameter 'target' of method 'consume' must not be null");
                }
                if (!$assertionsDisabled && source == target) {
                    throw new AssertionError((Object)"Same instances");
                }
                if (!$assertionsDisabled && moveables == null) {
                    throw new AssertionError((Object)"Parameter 'moveables' of method 'consume' must not be null");
                }
                if (!$assertionsDisabled && colliding == null) {
                    throw new AssertionError((Object)"Parameter 'colliding' of method 'consume' must not be null");
                }
                if (!representation.inModification() && source.isSelected()) {
                    target.setSelected(true);
                }
                if (!moveables.isEmpty()) {
                    ArrayList<ProgrammingElement> allProgrammingElements = new ArrayList<ProgrammingElement>();
                    moveables.forEach(m -> {
                        boolean bl = allProgrammingElements.addAll(m.getProgrammingElements());
                    });
                    RepresentationHandler.removeProgrammingElementsFromParents(allProgrammingElements, source, affectedAssignableNodeParents);
                    moveables.forEach(m -> StructureHandler.move(m, target, descriptor, representation));
                    RepresentationHandler.addProgrammingElementsToParents(allProgrammingElements, target, affectedAssignableNodeParents);
                } else {
                    affectedAssignableNodeParents.add(source);
                }
                colliding.forEach(c -> {
                    boolean bl = collidingElementInfo.add("Colliding: " + c.getName());
                });
            }
        }, representation);
        NodeHandler.finishAssignMoveRename(affectedAssignableNodeParents, representation);
        return collidingElementInfo;
    }

    static ExpandSelectInfo move(PresentationMode presentationMode, Collection<AssignableNode> assignables, ArchitecturalViewNode target, MoveElementsInfo moveElementInfo, ExplorationViewRepresentation representation) {
        assert (presentationMode != null) : "Parameter 'presentationMode' of method 'move' must not be null";
        assert (assignables != null && !assignables.isEmpty()) : "Parameter 'assignables' of method 'move' must not be empty";
        assert (target != null) : "Parameter 'target' of method 'move' must not be null";
        assert (moveElementInfo != null) : "Parameter 'moveElementInfo' of method 'move' must not be null";
        assert (representation != null) : "Parameter 'representation' of method 'move' must not be null";
        ExpandSelectInfo expandSelectInfo = new ExpandSelectInfo();
        ArrayList<RecursiveNode> recursives = new ArrayList<RecursiveNode>();
        ArrayList<AssignableToArtifactNode> assignableToArtifacts = new ArrayList<AssignableToArtifactNode>();
        for (AssignableNode next : assignables) {
            if (next instanceof RecursiveNode) {
                recursives.add((RecursiveNode)next);
                continue;
            }
            assert (next instanceof AssignableToArtifactNode) : "Unexpected class in method 'applyMoveRefactoring': " + String.valueOf(next);
            assignableToArtifacts.add((AssignableToArtifactNode)next);
            expandSelectInfo.addExpandParentsOf(next);
        }
        int moved = 0;
        int colliding = 0;
        if (!assignableToArtifacts.isEmpty()) {
            ArrayList<AssignableToArtifactNode> assignableToArtifactNodes = new ArrayList<AssignableToArtifactNode>();
            AssignableToArtifactCollector assignableToArtifactNodeCollector = new AssignableToArtifactCollector(assignableToArtifactNodes);
            TreeSet<ArchitecturalViewNode> affectedAssignableNodeParents = new TreeSet<ArchitecturalViewNode>(new DescendingRelativePathComparator());
            for (AssignableToArtifactNode next : assignableToArtifacts) {
                next.accept(assignableToArtifactNodeCollector);
                AssignableToArtifactRefactoringDescriptor nextDescriptor = representation.getAssignableToArtifactCreationDescriptor(next.getLanguage());
                RepresentationHandler.removeProgrammingElementsFromParents(next, affectedAssignableNodeParents);
                StructureHandler.move(next, target, nextDescriptor, representation);
                RepresentationHandler.addProgrammingElementsToParents(next, affectedAssignableNodeParents);
            }
            NodeHandler.finishAssignMoveRename(affectedAssignableNodeParents, representation);
        }
        if (!recursives.isEmpty()) {
            NonRecursiveNonLeafNode root = target.getParent(NonRecursiveNonLeafNode.class, ParentMode.SELF_OR_FIRST_PARENT);
            assert (root != null) : "'root' of method 'applyMoveRefactoring' must not be null";
            for (RecursiveNode next : recursives) {
                boolean recursively = NodeHandler.recursively(next, presentationMode) == null;
                Language nextLanguage = next.getLanguage();
                RecursiveElementRefactoringDescriptor recursiveDescriptor = representation.getRecursiveElementCreationDescriptor(nextLanguage);
                AssignableToArtifactRefactoringDescriptor assignableDescriptor = representation.getAssignableToArtifactCreationDescriptor(nextLanguage);
                RecursiveNodeMoveRenameProcessor processor = new RecursiveNodeMoveRenameProcessor(representation, recursiveDescriptor, assignableDescriptor, root);
                RecursiveNode nextLeafNode = processor.getOrCreateRecursiveElement(RecursiveNodeMoveRenameProcessor.getRecursiveNodeMoveTargetName(recursiveDescriptor, next, target, recursively), representation);
                List<String> collidingElementInfo = StructureHandler.move(processor, next, nextLeafNode, assignableDescriptor, recursively, representation);
                expandSelectInfo.addExpandParentsOf(nextLeafNode);
                collidingElementInfo.forEach(c -> moveElementInfo.addElementInfo((String)c));
                moved += processor.getNumberOfMoveables();
                colliding += processor.getNumberOfColliding();
            }
        }
        if (moved > 0 || colliding > 0) {
            moveElementInfo.setAdditionalOverallInfo(moved + " movable and " + colliding + " colliding assignable(s)");
        }
        return expandSelectInfo;
    }

    static RenameElementInfo isRenamePossible(ArchitecturalViewElement element, ExplorationViewRepresentation representation) {
        assert (element != null) : "Parameter 'element' of method 'isRenamePossible' must not be null";
        assert (representation != null) : "Parameter 'representation' of method 'isRenamePossible' must not be null";
        if (!element.isExternal()) {
            Language language = element.getFirstUnderlyingElement().getLanguage();
            if (element instanceof AssignableToArtifactNode) {
                AssignableToArtifactRefactoringDescriptor descriptor = representation.getAssignableToArtifactCreationDescriptor(language);
                if (descriptor.isRenamePossible(element.getUnderlyingElements())) {
                    ArchitecturalViewNode parent = ((AssignableToArtifactNode)element).getNodeParent();
                    assert (parent != null) : "'parent' of method 'isRenamePossible' must not be null";
                    THashSet alreadyContained = new THashSet(parent.getNodeChildren(n -> !n.isDeleted() && n instanceof AssignableToArtifactNode, false));
                    return new RenameElementInfo(descriptor, new AssignableToArtifactRenameValidator(descriptor, (AssignableToArtifactNode)element, (Set<ArchitecturalViewNode>)alreadyContained), descriptor.getRelevantNamePartForRename(element.getName()));
                }
            } else if (element instanceof RecursiveNode) {
                NonRecursiveNonLeafNode root = element.getParent(NonRecursiveNonLeafNode.class, ExplorationViewRepresentation.class);
                assert (root != null) : "'root' of method 'isRenamePossible' must not be null";
                RecursiveElementRefactoringDescriptor recursiveDescriptor = representation.getRecursiveElementCreationDescriptor(language);
                AssignableToArtifactRefactoringDescriptor assignableDescriptor = representation.getAssignableToArtifactCreationDescriptor(language);
                return new RenameElementInfo(recursiveDescriptor, RecursiveNodeMoveRenameProcessor.getRenameValidator(recursiveDescriptor, assignableDescriptor, root, (RecursiveNode)element, representation), element.getName());
            }
        }
        return null;
    }

    static RenameElementInfo rename(PresentationMode presentationMode, ArchitecturalViewElement element, String name, ExplorationViewRepresentation representation) {
        assert (presentationMode != null) : "Parameter 'presentationMode' of method 'rename' must not be null";
        LOGGER.debug("Rename '" + element.getElementInfo(true, false) + "' to '" + name + "'");
        RenameElementInfo info = StructureHandler.isRenamePossible(element, representation);
        assert (info != null) : "Parameter 'info' of method 'rename' must not be null";
        assert (info.getValidator().isValid("", name).isSuccess()) : "Not a valid name: " + name;
        ElementRefactoringDescriptor descriptor = info.getCreationDescriptor();
        if (element instanceof AssignableToArtifactNode) {
            AssignableToArtifactNode node = (AssignableToArtifactNode)element;
            assert (descriptor != null && descriptor instanceof AssignableToArtifactRefactoringDescriptor) : "Unexpected class in method 'rename': " + String.valueOf(descriptor);
            ArchitecturalViewElement parent = node.getParent(ArchitecturalViewElement.class, ParentMode.ONLY_DIRECT_PARENT);
            assert (parent != null) : "'parent' of method 'rename' must not be null";
            NamedElement underlyingParent = parent.getFirstUnderlyingElement();
            assert (underlyingParent != null) : "'underlyingParent' of method 'rename' must not be null";
            String newName = ((AssignableToArtifactRefactoringDescriptor)descriptor).getNewNameForRename(node.getName(), name);
            NodeLocation originalLocation = representation.getOriginalLocation(node);
            if (originalLocation == null) {
                representation.addOriginalLocation(node, NodeHandler.createLocation(node));
                node.setRefactored(true);
            }
            node.setPrototypeElement(descriptor.createPrototype(underlyingParent, newName, node.getFirstUnderlyingElement()));
            if (originalLocation != null && originalLocation.equals(NodeHandler.createLocation(node))) {
                node.setPrototypeElement(null);
                node.setRefactored(false);
                representation.removeOriginalLocation(node);
            }
            info.setContainsRefactoring(true);
            NodeHandler.finishAssignMoveRename(node.getParents(AssignableNode.class, ArtifactNode.class, ExplorationViewRepresentation.class), representation);
        } else if (element instanceof RecursiveNode) {
            assert (descriptor instanceof RecursiveElementRefactoringDescriptor) : "Unexpected class in method 'rename': " + String.valueOf(descriptor);
            RecursiveElementRefactoringDescriptor recursiveDescriptor = (RecursiveElementRefactoringDescriptor)descriptor;
            AssignableToArtifactRefactoringDescriptor assignableDescriptor = representation.getAssignableToArtifactCreationDescriptor(descriptor.getLanguage());
            RecursiveNode recursiveNode = (RecursiveNode)element;
            NonRecursiveNonLeafNode root = recursiveNode.getParent(NonRecursiveNonLeafNode.class, ExplorationViewRepresentation.class);
            assert (root != null) : "'root' of method 'isRenamePossible' must not be null";
            RecursiveNodeMoveRenameProcessor processor = new RecursiveNodeMoveRenameProcessor(representation, recursiveDescriptor, assignableDescriptor, root);
            RecursiveNode leafNode = processor.getOrCreateRecursiveElement(name, representation);
            List<String> collidingElementInfo = StructureHandler.move(processor, recursiveNode, leafNode, assignableDescriptor, NodeHandler.recursively(recursiveNode, presentationMode) == null, representation);
            info.setContainsRefactoring(true);
            info.setInfo(processor.getNumberOfMoveables() + " movable and " + processor.getNumberOfColliding() + " colliding " + String.valueOf(assignableDescriptor.getLanguage()) + " " + assignableDescriptor.getPresentationKind().toLowerCase() + "(s)", collidingElementInfo);
        } else assert (false) : "Unexpected element: " + String.valueOf(element);
        LOGGER.debug("Rename '" + element.getElementInfo(true, false) + "' to '" + name + "' - done");
        return info;
    }
}

