/*
 * Decompiled with CFR 0.152.
 */
package com.hello2morrow.sonargraph.core.controller.system.explorationview;

import com.hello2morrow.sonargraph.core.controller.system.explorationview.ArchitecturalViewNodesInfo;
import com.hello2morrow.sonargraph.core.controller.system.explorationview.ArchitecturalViewVisitor;
import com.hello2morrow.sonargraph.core.controller.system.explorationview.ArtifactNodeQualifiedNameSupport;
import com.hello2morrow.sonargraph.core.controller.system.explorationview.AssignedToplevelNodesCollector;
import com.hello2morrow.sonargraph.core.controller.system.explorationview.FilterHandler;
import com.hello2morrow.sonargraph.core.controller.system.explorationview.FocusHandler;
import com.hello2morrow.sonargraph.core.controller.system.explorationview.IExplorationViewRepresentationHandler;
import com.hello2morrow.sonargraph.core.controller.system.explorationview.NodeHandler;
import com.hello2morrow.sonargraph.core.controller.system.explorationview.RepresentationHandler;
import com.hello2morrow.sonargraph.core.controller.system.explorationview.StructureHandler;
import com.hello2morrow.sonargraph.core.model.architecture.ArtifactNameUtility;
import com.hello2morrow.sonargraph.core.model.common.PresentationMode;
import com.hello2morrow.sonargraph.core.model.element.NamedElementUtility;
import com.hello2morrow.sonargraph.core.model.element.ParentMode;
import com.hello2morrow.sonargraph.core.model.explorationview.ArchitecturalViewArtifactNameValidator;
import com.hello2morrow.sonargraph.core.model.explorationview.ArchitecturalViewArtifactOperationAvailability;
import com.hello2morrow.sonargraph.core.model.explorationview.ArchitecturalViewElement;
import com.hello2morrow.sonargraph.core.model.explorationview.ArchitecturalViewNode;
import com.hello2morrow.sonargraph.core.model.explorationview.ArtifactNode;
import com.hello2morrow.sonargraph.core.model.explorationview.ArtifactNodeConnection;
import com.hello2morrow.sonargraph.core.model.explorationview.ArtifactNodeFilter;
import com.hello2morrow.sonargraph.core.model.explorationview.ArtifactProperties;
import com.hello2morrow.sonargraph.core.model.explorationview.AssignableNode;
import com.hello2morrow.sonargraph.core.model.explorationview.AssignableTargetInfo;
import com.hello2morrow.sonargraph.core.model.explorationview.AssignableToArtifactNode;
import com.hello2morrow.sonargraph.core.model.explorationview.ExplorationViewRepresentation;
import com.hello2morrow.sonargraph.core.model.explorationview.IAssignableTarget;
import com.hello2morrow.sonargraph.core.model.explorationview.MoveElementsInfo;
import com.hello2morrow.sonargraph.core.model.explorationview.NonRecursiveRootNode;
import com.hello2morrow.sonargraph.core.model.explorationview.RecursiveNode;
import gnu.trove.set.hash.THashSet;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Deque;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class ArtifactHandler
implements IExplorationViewRepresentationHandler {
    private static final Logger LOGGER = LoggerFactory.getLogger(ArtifactHandler.class);

    private ArtifactHandler() {
    }

    private static IAssignableTarget getCommonAssignableTargetParent(Collection<? extends ArchitecturalViewElement> elements) {
        assert (elements != null && !elements.isEmpty()) : "Parameter 'elements' of method 'getCommonAssignableTargetParent' must not be empty";
        ArtifactNode commonArtifact = null;
        for (ArchitecturalViewElement architecturalViewElement : elements) {
            ArtifactNode nextArtifactNode = architecturalViewElement.getParent(ArtifactNode.class, ExplorationViewRepresentation.class);
            if (nextArtifactNode == null) continue;
            if (commonArtifact == null) {
                commonArtifact = nextArtifactNode;
                continue;
            }
            if (nextArtifactNode == commonArtifact) continue;
            commonArtifact = null;
            break;
        }
        if (commonArtifact != null) {
            return commonArtifact;
        }
        return RepresentationHandler.getRepresentation(elements);
    }

    private static IAssignableTarget getTargetParent(Collection<ArtifactNode> toBeDeletedArtifacts, ExplorationViewRepresentation representation) {
        assert (toBeDeletedArtifacts != null && !toBeDeletedArtifacts.isEmpty()) : "Parameter 'toBeDeletedArtifacts' of method 'getTargetParent' must not be empty";
        assert (representation != null) : "Parameter 'representation' of method 'getTargetParent' must not be null";
        ArtifactNode commonDirectArtifactParent = null;
        for (ArtifactNode nextToBeDeletedArtifact : toBeDeletedArtifacts) {
            ArtifactNode nextArtifactParent = nextToBeDeletedArtifact.getParent(ArtifactNode.class, ParentMode.ONLY_DIRECT_PARENT);
            if (nextArtifactParent == null) {
                commonDirectArtifactParent = null;
                break;
            }
            if (commonDirectArtifactParent == null) {
                commonDirectArtifactParent = nextArtifactParent;
                continue;
            }
            if (commonDirectArtifactParent == nextArtifactParent) continue;
            commonDirectArtifactParent = null;
            break;
        }
        if (commonDirectArtifactParent != null) {
            return commonDirectArtifactParent;
        }
        return representation;
    }

    private static String getLastShortNamePart(String name) {
        assert (name != null && name.length() > 0) : "Parameter 'name' of method 'getLastShortNamePart' must not be empty";
        int pos = name.lastIndexOf(46);
        if (pos == -1) {
            pos = name.lastIndexOf(47);
        }
        return pos == -1 ? name : name.substring(pos + 1);
    }

    private static String getArtifactNameProposal(AssignableNode assignable, PresentationMode presentationMode) {
        String proposal;
        assert (assignable != null) : "Parameter 'assignable' of method 'getArtifactNameProposal' must not be null";
        assert (presentationMode != null) : "Parameter 'presentationMode' of method 'getArtifactNameProposal' must not be null";
        if (assignable instanceof AssignableToArtifactNode) {
            String shortName = assignable.getShortName();
            int pos = shortName.lastIndexOf(46);
            proposal = pos == -1 ? shortName : shortName.substring(0, pos);
        } else if (assignable instanceof RecursiveNode) {
            switch (presentationMode) {
                case HIERARCHICAL: {
                    proposal = assignable.getShortName();
                    break;
                }
                case FLAT: 
                case MIXED: {
                    proposal = ArtifactHandler.getLastShortNamePart(assignable.getName());
                    break;
                }
                default: {
                    assert (false) : "Unhandled presentation mode: " + String.valueOf((Object)assignable.getPresentationMode());
                    proposal = null;
                    break;
                }
            }
        } else {
            proposal = assignable.getShortName();
        }
        assert (!proposal.isEmpty()) : "Empty proposal for: " + String.valueOf(assignable);
        proposal = ArtifactNameUtility.createValidName(proposal);
        return proposal;
    }

    public static ArchitecturalViewArtifactNameValidator getArtifactNameValidator(AssignableTargetInfo assignableTargetInfo, ArtifactNode artifactNodeToBeEdited) {
        assert (assignableTargetInfo != null) : "Parameter 'assignableTargetInfo' of method 'getArtifactNameValidator' must not be null";
        return new ArchitecturalViewArtifactNameValidator(assignableTargetInfo, artifactNodeToBeEdited != null ? Collections.singleton(artifactNodeToBeEdited) : Collections.emptySet());
    }

    public static final ArchitecturalViewArtifactNameValidator getArtifactFromElementsNameValidator(AssignableTargetInfo assignableTargetInfo, List<? extends ArchitecturalViewElement> elements) {
        assert (assignableTargetInfo != null) : "Parameter 'assignableTargetInfo' of method 'getArtifactFromElementsNameValidator' must not be null";
        assert (elements != null) : "Parameter 'elements' of method 'getArtifactFromElementsNameValidator' must not be null";
        THashSet ignore = new THashSet();
        for (ArchitecturalViewElement architecturalViewElement : elements) {
            if (!(architecturalViewElement instanceof ArtifactNode)) continue;
            ignore.add((ArtifactNode)architecturalViewElement);
        }
        return new ArchitecturalViewArtifactNameValidator(assignableTargetInfo, (Set<ArtifactNode>)ignore);
    }

    /*
     * WARNING - void declaration
     */
    static String getSingleNameProposal(IAssignableTarget parent, List<? extends ArchitecturalViewElement> elements, PresentationMode presentationMode) {
        void var3_12;
        assert (parent != null) : "Parameter 'parent' of method 'getSingleNameProposal' must not be null";
        assert (elements != null && !elements.isEmpty()) : "Parameter 'elements' of method 'getSingleNameProposal' must not be empty";
        assert (presentationMode != null) : "Parameter 'presentationMode' of method 'getSingleNameProposal' must not be null";
        for (ArchitecturalViewElement architecturalViewElement : elements) {
            if (architecturalViewElement instanceof AssignableNode) continue;
            return "";
        }
        Object var3_8 = null;
        if (elements.size() == 1) {
            String string = ArtifactHandler.getArtifactNameProposal((AssignableNode)elements.get(0), presentationMode);
        } else {
            for (ArchitecturalViewElement architecturalViewElement : NamedElementUtility.normalize(elements, true, new Class[0])) {
                void var3_10;
                String nextProposal = ArtifactHandler.getArtifactNameProposal((AssignableNode)architecturalViewElement, presentationMode);
                if (nextProposal.isEmpty()) {
                    return "";
                }
                if (var3_10 == null) {
                    String string = nextProposal;
                    continue;
                }
                if (var3_10.equals(nextProposal)) continue;
                return "";
            }
        }
        if (var3_12 != null) {
            void var3_13;
            THashSet tHashSet = new THashSet();
            parent.getArchitecturalViewElement().getChildren(ArtifactNode.class).forEach(arg_0 -> ArtifactHandler.lambda$0((Set)tHashSet, arg_0));
            int index = 0;
            boolean addedSuccessfully = false;
            do {
                void nextProposalToCheck;
                if (!(addedSuccessfully = tHashSet.add(nextProposalToCheck = index == 0 ? var3_13 : (String)var3_13 + "_" + index))) {
                    ++index;
                    continue;
                }
                void var3_14 = nextProposalToCheck;
            } while (!addedSuccessfully);
            return var3_13;
        }
        return "";
    }

    static List<String> getMultipleNameProposals(IAssignableTarget assignableTarget, Collection<AssignableNode> assignables, PresentationMode presentationMode) {
        assert (assignableTarget != null) : "Parameter 'assignableTarget' of method 'getMultipleNameProposals' must not be null";
        assert (assignables != null && !assignables.isEmpty()) : "Parameter 'assignables' of method 'getMultipleNameProposals' must not be empty";
        assert (presentationMode != null) : "Parameter 'presentationMode' of method 'getMultipleNameProposals' must not be null";
        THashSet existingNames = new THashSet();
        assignableTarget.getArchitecturalViewElement().getChildren(ArtifactNode.class).forEach(arg_0 -> ArtifactHandler.lambda$1((Set)existingNames, arg_0));
        ArrayList<String> names = new ArrayList<String>(assignables.size());
        for (AssignableNode nextAssignable : assignables) {
            String nextProposal = ArtifactHandler.getArtifactNameProposal(nextAssignable, presentationMode);
            int index = 0;
            boolean addedSuccessfully = false;
            do {
                String nextProposalToCheck;
                if (addedSuccessfully = existingNames.add(nextProposalToCheck = index == 0 ? nextProposal : nextProposal + "_" + index)) {
                    names.add(nextProposalToCheck);
                    continue;
                }
                ++index;
            } while (!addedSuccessfully);
        }
        return names;
    }

    static void setArtifactProperties(List<ArtifactNode> artifacts, ArtifactProperties properties) {
        assert (artifacts != null && !artifacts.isEmpty()) : "Parameter 'artifacts' of method 'setArtifactProperties' must not be empty";
        assert (properties != null) : "Parameter 'properties' of method 'setArtifactProperties' must not be null";
        artifacts.forEach(a -> {
            boolean bl = a.setArtifactProperties(properties);
        });
    }

    static ArchitecturalViewArtifactOperationAvailability isCreateArtifactFromElementsPossible(PresentationMode presentationMode, List<? extends ArchitecturalViewElement> elements) {
        assert (presentationMode != null) : "Parameter 'presentationMode' of method 'isCreateArtifactFromElementsPossible' must not be null";
        assert (elements != null && !elements.isEmpty()) : "Parameter 'elements' of method 'isCreateArtifactFromElementsPossible' must not be empty";
        ArchitecturalViewArtifactOperationAvailability availability = new ArchitecturalViewArtifactOperationAvailability("Create artifact from elements");
        ArchitecturalViewNodesInfo info = NodeHandler.createArchitecturalViewNodesInfo(presentationMode, elements);
        if (info.getNumberOfNodes() > 0) {
            IAssignableTarget targetParent = ArtifactHandler.getCommonAssignableTargetParent(info.getNodes());
            assert (targetParent != null) : "Parameter 'targetParent' of method 'isCreateArtifactFromElementsPossible' must not be null";
            availability.setAssignableTarget(targetParent);
            availability.addIgnoreSubTree(info.getArtifacts());
        }
        return availability;
    }

    static ArchitecturalViewArtifactOperationAvailability isCreateArtifactsForElementsPossible(PresentationMode presentationMode, List<? extends ArchitecturalViewElement> elements) {
        assert (presentationMode != null) : "Parameter 'presentationMode' of method 'isCreateArtifactsForElementsPossible' must not be null";
        assert (elements != null && !elements.isEmpty()) : "Parameter 'elements' of method 'isCreateArtifactsForElementsPossible' must not be empty";
        ArchitecturalViewArtifactOperationAvailability availability = new ArchitecturalViewArtifactOperationAvailability("Create artifacts for elements");
        ArchitecturalViewNodesInfo info = NodeHandler.createArchitecturalViewNodesInfo(presentationMode, elements);
        Set<ArtifactNode> artifacts = info.getArtifacts();
        Set<AssignableNode> assignables = info.getAssignables();
        if (artifacts.isEmpty() && assignables.size() > 1) {
            IAssignableTarget targetParent = ArtifactHandler.getCommonAssignableTargetParent(assignables);
            assert (targetParent != null) : "Parameter 'targetParent' of method 'isCreateArtifactsForElementsPossible' must not be null";
            availability.setAssignableTarget(targetParent);
        }
        return availability;
    }

    static ArtifactNodeConnection isCreateAllowedArtifactConnectionPossible(ArchitecturalViewElement from, ArchitecturalViewElement to) {
        ExplorationViewRepresentation representation;
        assert (from != null) : "Parameter 'from' of method 'isCreateAllowedArtifactConnectionPossible' must not be null";
        assert (to != null) : "Parameter 'to' of method 'isCreateAllowedArtifactConnectionPossible' must not be null";
        if (from instanceof ArtifactNode && to instanceof ArtifactNode && from != to && !to.hasAsParent(from, false) && !from.hasAsParent(to, false) && RepresentationHandler.getRepresentation(Arrays.asList(from, to)) != null && !((ArtifactNode)from).isAllowed((ArtifactNode)to) && (representation = RepresentationHandler.getRepresentation(Arrays.asList(from, to))) != null && ArtifactNodeQualifiedNameSupport.isArtifactReachableWithQualifiedName((ArtifactNode)from, (ArtifactNode)to)) {
            return new ArtifactNodeConnection((ArtifactNode)from, (ArtifactNode)to);
        }
        return null;
    }

    static void createAllowedArtifactConnection(ArtifactNodeConnection dependency, ExplorationViewRepresentation representation) {
        assert (dependency != null) : "Parameter 'dependency' of method 'createAllowedArtifactConnection' must not be null";
        assert (representation != null) : "Parameter 'representation' of method 'createAllowedArtifactConnection' must not be null";
        assert (ArtifactHandler.isCreateAllowedArtifactConnectionPossible(dependency.getFrom(), dependency.getTo()) != null) : "Create allowed artifact connection not possible";
        dependency.getFrom().addAllowed(dependency.getTo());
        RepresentationHandler.updateAggregatedDependencies(representation);
    }

    static ArchitecturalViewArtifactOperationAvailability isEditArtifactsPossible(List<ArtifactNode> artifacts) {
        assert (artifacts != null && !artifacts.isEmpty()) : "Parameter 'artifacts' of method 'isEditArtifactsPossible' must not be empty";
        ArchitecturalViewArtifactOperationAvailability availability = new ArchitecturalViewArtifactOperationAvailability("Edit artifacts");
        ExplorationViewRepresentation representation = RepresentationHandler.getRepresentation(artifacts);
        if (representation != null) {
            if (artifacts.size() == 1) {
                IAssignableTarget parent = artifacts.get(0).getParent(IAssignableTarget.class, new Class[0]);
                if (parent != null) {
                    availability.setAssignableTarget(parent);
                    availability.addIgnoreSubTree(artifacts.get(0).getChildren(ArtifactNode.class));
                }
            } else {
                IAssignableTarget parent = null;
                for (ArtifactNode next : artifacts) {
                    IAssignableTarget nextParent = next.getParent(IAssignableTarget.class, new Class[0]);
                    if (nextParent == null) {
                        parent = null;
                        break;
                    }
                    if (parent == null) {
                        parent = nextParent;
                        continue;
                    }
                    if (parent == nextParent) continue;
                    parent = null;
                    break;
                }
                if (parent != null) {
                    availability.setAssignableTarget(parent);
                    for (ArtifactNode next : artifacts) {
                        availability.addIgnoreSubTree(next.getChildren(ArtifactNode.class));
                    }
                }
            }
        }
        return availability;
    }

    private static int calculateArtifactTargetIndex(IAssignableTarget targetParent, int relativeIndex) {
        int realIndex;
        assert (targetParent != null) : "Parameter 'targetParent' of method 'calculateArtifactTargetIndex' must not be null";
        assert (relativeIndex >= -1) : "Invalid 'relativeIndex': " + relativeIndex;
        ArchitecturalViewElement element = targetParent.getArchitecturalViewElement();
        int offset = element.getRelativeIndexOffset();
        int numberOfArtifactChildren = element.getChildren(ArtifactNode.class).size();
        if (relativeIndex == -1) {
            realIndex = offset + numberOfArtifactChildren;
        } else {
            int relativeIndexInclOffset = offset + relativeIndex;
            assert (relativeIndexInclOffset >= offset) : "'relativeIndexInclOffset' must be greater than or equal to 'offset': " + relativeIndexInclOffset + "/" + offset;
            if (relativeIndexInclOffset > numberOfArtifactChildren + offset) {
                LOGGER.debug("Invalid 'relativeIndexInclOffset': " + relativeIndexInclOffset + " - parent has " + numberOfArtifactChildren + " artifact children");
                realIndex = offset + numberOfArtifactChildren;
            } else {
                realIndex = relativeIndexInclOffset;
            }
        }
        return realIndex;
    }

    static ArtifactNode createArtifact(IAssignableTarget assignableTarget, int relativeIndex, String shortName, ArtifactProperties properties, ArtifactNodeFilter filter, ExplorationViewRepresentation representation) {
        assert (assignableTarget != null) : "Parameter 'assignableTarget' of method 'createArtifact' must not be null";
        assert (shortName != null && shortName.length() > 0) : "Parameter 'shortName' of method 'createArtifact' must not be empty";
        assert (properties != null) : "Parameter 'properties' of method 'createArtifact' must not be null";
        assert (filter != null) : "Parameter 'filter' of method 'createArtifact' must not be null";
        assert (FilterHandler.isFilterValid(filter) == null) : "Not a valid filter: " + String.valueOf(filter);
        assert (representation != null) : "Parameter 'representation' of method 'createArtifact' must not be null";
        ArchitecturalViewElement parent = assignableTarget.getArchitecturalViewElement();
        ArtifactNode createdArtifact = new ArtifactNode(parent, representation.getPresentationMode(), shortName, properties, filter);
        assert (createdArtifact.getParent(ArchitecturalViewElement.class, ParentMode.ONLY_DIRECT_PARENT) == parent) : "Unexpected parent set: " + String.valueOf(createdArtifact.getParent(ArchitecturalViewElement.class, ParentMode.ONLY_DIRECT_PARENT));
        parent.appendOrInsertChild(createdArtifact, ArtifactHandler.calculateArtifactTargetIndex(assignableTarget, relativeIndex));
        if (parent instanceof ArchitecturalViewNode) {
            NodeHandler.updateExpandableState((ArchitecturalViewNode)parent, representation);
        }
        NodeHandler.expandParentChainOf(Collections.singletonList(createdArtifact), null, representation, false);
        RepresentationHandler.addProgrammingElementsToParents(createdArtifact);
        FocusHandler.finishElementCreation(Collections.singletonList(createdArtifact), representation);
        return createdArtifact;
    }

    static void finishArtifactModelModification(boolean force, ExplorationViewRepresentation representation) {
        assert (representation != null) : "Parameter 'representation' of method 'updateContainmentState' must not be null";
        if (force || !representation.inModification()) {
            LOGGER.debug("Finish artifact model modification");
            Map<AssignableToArtifactNode, ArtifactNode> cache = representation.clearAssignableToArtifactCache();
            List<ArtifactNode> topLevelArtifacts = representation.getChildren(ArtifactNode.class);
            if (!topLevelArtifacts.isEmpty()) {
                FinishArtifactModelVisitor visitor = new FinishArtifactModelVisitor(cache);
                topLevelArtifacts.forEach(a -> a.accept(visitor));
            }
            LOGGER.debug("Finish artifact model modification - done");
        }
    }

    static ArchitecturalViewArtifactOperationAvailability isCreateArtifactPossible(PresentationMode presentationMode, List<? extends ArchitecturalViewElement> elements) {
        assert (presentationMode != null) : "Parameter 'presentationMode' of method 'isCreateArtifactPossible' must not be null";
        assert (elements != null && !elements.isEmpty()) : "Parameter 'elements' of method 'isCreateArtifactPossible' must not be empty";
        ArchitecturalViewArtifactOperationAvailability availability = new ArchitecturalViewArtifactOperationAvailability("Create artifact");
        ArchitecturalViewNodesInfo info = NodeHandler.createArchitecturalViewNodesInfo(presentationMode, elements);
        if (info.getNumberOfAssignables() == 0 && info.getNumberOfArtifacts() <= 1) {
            IAssignableTarget parent = null;
            parent = info.getNumberOfArtifacts() == 1 ? (IAssignableTarget)info.getArtifacts().iterator().next() : info.getRepresentation();
            if (parent != null) {
                availability.setAssignableTarget(parent);
            }
        }
        return availability;
    }

    static void deleteArtifacts(Collection<ArtifactNode> artifacts, ExplorationViewRepresentation representation) {
        List<NonRecursiveRootNode> assignedTopLevelNodes;
        assert (artifacts != null && !artifacts.isEmpty()) : "Parameter 'artifacts' of method 'deleteArtifacts' must not be empty";
        assert (representation != null) : "Parameter 'representation' of method 'deleteArtifacts' must not be null";
        ArrayList<ArtifactNode> automatic = new ArrayList<ArtifactNode>(artifacts);
        ArrayList<ArtifactNode> manual = new ArrayList<ArtifactNode>(artifacts.size());
        Iterator iterator = automatic.iterator();
        while (iterator.hasNext()) {
            ArtifactNode nextArtifact = (ArtifactNode)iterator.next();
            if (!nextArtifact.hasManualFilter()) continue;
            iterator.remove();
            manual.add(nextArtifact);
        }
        if (!automatic.isEmpty()) {
            assignedTopLevelNodes = AssignedToplevelNodesCollector.collect(automatic);
            IAssignableTarget targetParent = ArtifactHandler.getTargetParent(artifacts, representation);
            ArchitecturalViewElement targetParentElement = targetParent.getArchitecturalViewElement();
            if (!representation.inModification()) assert (targetParentElement.isExpanded()) : "Not expanded: " + targetParentElement.getElementInfo();
            if (!assignedTopLevelNodes.isEmpty()) {
                StructureHandler.assign(null, assignedTopLevelNodes, targetParent, representation);
            }
        }
        if (!manual.isEmpty() && !(assignedTopLevelNodes = AssignedToplevelNodesCollector.collect(manual)).isEmpty()) {
            StructureHandler.assign(null, assignedTopLevelNodes, representation, representation);
        }
        artifacts.forEach(n -> n.remove());
    }

    static void isMoveToTargetPossible(Set<ArtifactNode> artifacts, MoveElementsInfo operationInfo) {
        assert (artifacts != null && !artifacts.isEmpty()) : "Parameter 'artifacts' of method 'isMoveToTargetPossible' must not be empty";
        assert (operationInfo != null) : "Parameter 'operationInfo' of method 'isMoveToTargetPossible' must not be null";
        ArchitecturalViewElement target = operationInfo.getTargetInfo().getTarget();
        if (!(target instanceof IAssignableTarget)) {
            for (ArtifactNode nextArtifact : artifacts) {
                operationInfo.addNotMovable(nextArtifact, "'" + target.getName() + "' is not a suitable target for artifact move.");
            }
            return;
        }
        if (artifacts.contains(target)) {
            for (ArtifactNode nextArtifact : artifacts) {
                operationInfo.addNotMovable(nextArtifact, "Target '" + target.getName() + "' is contained in seletion.");
            }
            return;
        }
        THashSet alreadyContainedArtifacts = new THashSet(target.getChildren(ArtifactNode.class));
        for (ArtifactNode nextArtifact : artifacts) {
            IAssignableTarget nextParentOfArtifact = nextArtifact.getParent(IAssignableTarget.class, new Class[0]);
            assert (nextParentOfArtifact != null) : "'nextParentOfArtifact' of method 'isMoveToTargetPossible' must not be null";
            boolean isMovable = true;
            if (target == nextArtifact) {
                operationInfo.addNotMovable(nextArtifact, "Cannot be dropped on itself.");
                isMovable = false;
            }
            if (target.hasAsParent(nextArtifact, false)) {
                operationInfo.addNotMovable(nextArtifact, "Cannot be dropped on a child.");
                isMovable = false;
            } else if (nextParentOfArtifact != target) {
                for (ArtifactNode nextExistingChild : alreadyContainedArtifacts) {
                    if (!nextExistingChild.getShortName().equalsIgnoreCase(nextArtifact.getShortName())) continue;
                    operationInfo.addNotMovable(nextArtifact, "'" + target.getName() + "' already contains artifact with name '" + nextExistingChild.getShortName() + "'.");
                    isMovable = false;
                }
            }
            if (!isMovable) continue;
            operationInfo.addToBeMoved(nextArtifact);
        }
    }

    static void move(Collection<ArtifactNode> artifacts, IAssignableTarget assignableTarget, int relativeIndex, ExplorationViewRepresentation representation) {
        assert (artifacts != null && !artifacts.isEmpty()) : "Parameter 'artifacts' of method 'move' must not be empty";
        assert (assignableTarget != null) : "Parameter 'assignableTarget' of method 'move' must not be null";
        assert (relativeIndex >= -1) : "Invalid 'relativeIndex': " + relativeIndex;
        assert (representation != null) : "Parameter 'representation' of method 'move' must not be null";
        boolean inModification = representation.inModification();
        THashSet previousParents = !inModification ? new THashSet(artifacts.size()) : Collections.emptySet();
        ArchitecturalViewElement targetParent = assignableTarget.getArchitecturalViewElement();
        LOGGER.debug("Move " + artifacts.size() + " artifacts(s) to: " + targetParent.getElementInfo(true, false));
        NodeHandler.expandParentChainOf(artifacts, null, representation, false);
        if (targetParent instanceof ArchitecturalViewNode) {
            NodeHandler.expandParentChainOf(Collections.singletonList((ArchitecturalViewNode)targetParent), null, representation, false);
        }
        int targetIndex = ArtifactHandler.calculateArtifactTargetIndex(assignableTarget, relativeIndex);
        for (ArtifactNode nextArtifact : artifacts) {
            List<ArtifactNode> nextArtifactParents = nextArtifact.getParents(ArtifactNode.class, ExplorationViewRepresentation.class);
            for (ArtifactNode nextArtifactParent : nextArtifactParents) {
                nextArtifactParent.removeProgrammingElements(nextArtifact.getProgrammingElements());
            }
            if (!inModification && !nextArtifactParents.isEmpty()) {
                previousParents.add(nextArtifactParents.get(0));
            }
            nextArtifact.changeParentAndOrPos(targetParent, targetIndex);
            RepresentationHandler.resetRelativePath(nextArtifact);
            RepresentationHandler.addProgrammingElementsToParents(nextArtifact);
        }
        if (!inModification) {
            for (ArtifactNode next : previousParents) {
                if (!next.isExpanded() || next.isExpandable()) continue;
                LOGGER.debug("Collapse previous parent: " + next.getElementInfo(true, false));
                next.setExpanded(false);
            }
            if (!targetParent.isExpanded() && targetParent instanceof ArchitecturalViewNode && ((ArchitecturalViewNode)targetParent).isExpandable()) {
                LOGGER.debug("Expand target parent: " + targetParent.getElementInfo(true, false));
                ((ArchitecturalViewNode)targetParent).setExpanded(true);
            }
        }
        LOGGER.debug("Move " + artifacts.size() + " artifacts(s) to: " + targetParent.getElementInfo(true, false) + " - done");
    }

    private static /* synthetic */ void lambda$0(Set set, ArtifactNode a) {
        boolean bl = set.add(a.getShortName());
    }

    private static /* synthetic */ void lambda$1(Set set, ArtifactNode a) {
        boolean bl = set.add(a.getShortName());
    }

    private static final class FinishArtifactModelVisitor
    extends ArchitecturalViewVisitor
    implements AssignableToArtifactNode.IVisitor,
    ArtifactNode.IVisitor {
        private final Map<AssignableToArtifactNode, ArtifactNode> m_assignableNodeToArtifactNode;
        private final Deque<ArtifactNode> m_stack = new ArrayDeque<ArtifactNode>();

        FinishArtifactModelVisitor(Map<AssignableToArtifactNode, ArtifactNode> assignableNodeToArtifactNode) {
            assert (assignableNodeToArtifactNode != null) : "Parameter 'assignableNodeToArtifactNode' of method 'FinishArtifactModelVisitor' must not be null";
            this.m_assignableNodeToArtifactNode = assignableNodeToArtifactNode;
        }

        @Override
        public void visitArtifactNode(ArtifactNode element) {
            assert (element != null) : "Parameter 'element' of method 'visitArtifactNode' must not be null";
            this.m_stack.push(element);
            for (ArtifactNode nextAllowed : new ArrayList<ArtifactNode>(element.getAllowed())) {
                if (ArtifactNodeQualifiedNameSupport.isArtifactReachableWithQualifiedName(element, nextAllowed)) continue;
                element.removeAllowed(nextAllowed);
            }
            this.visitChildrenOf(element);
            this.m_stack.pop();
        }

        @Override
        public void visitAssignableToArtifactNode(AssignableToArtifactNode element) {
            assert (element != null) : "Parameter 'element' of method 'visitNonRecursiveLeafNode' must not be null";
            assert (!this.m_stack.isEmpty()) : "'m_stack' of method 'visitNonRecursiveLeafNode' must not be empty";
            this.m_assignableNodeToArtifactNode.put(element, this.m_stack.peek());
        }

        @Override
        public void visitArchitecturalViewElement(ArchitecturalViewElement element) {
            assert (element != null) : "Parameter 'element' of method 'visitArchitecturalViewElement' must not be null";
            if (!this.m_stack.isEmpty()) {
                super.visitArchitecturalViewElement(element);
            }
        }
    }
}

