/*
 * Decompiled with CFR 0.152.
 */
package com.hello2morrow.sonargraph.core.controller.system.explorationview;

import com.hello2morrow.sonargraph.core.model.element.Element;
import com.hello2morrow.sonargraph.core.model.explorationview.ArchitecturalViewElement;
import com.hello2morrow.sonargraph.core.model.explorationview.ExplorationViewRepresentation;
import java.util.ArrayList;
import java.util.List;

public final class ArchitecturalViewElementResolver {
    private ArchitecturalViewElementResolver() {
    }

    public static <T> T resolve(String relativePath, Class<T> clazz, ExplorationViewRepresentation representation, boolean all) {
        assert (relativePath != null) : "Parameter 'relativePath' of method 'resolve' must not be null";
        assert (clazz != null) : "Parameter 'clazz' of method 'resolve' must not be null";
        assert (representation != null) : "Parameter 'representation' of method 'resolve' must not be null";
        if (relativePath.isEmpty() && clazz.isAssignableFrom(ExplorationViewRepresentation.class)) {
            return (T)representation;
        }
        List<String> split = Element.splitDescriptor(relativePath);
        if (!split.isEmpty()) {
            ArchitecturalViewElement current = representation;
            int i = 0;
            while (i < split.size()) {
                String nextPathPart = split.get(i);
                if ((current = current.resolveByRelativePathPart(nextPathPart, all)) == null) {
                    return null;
                }
                if (i < split.size() - 1 && current.isLazyExpandable()) {
                    representation.getCreator().aboutToAccessChildrenOf(current, representation);
                }
                ++i;
            }
            assert (current != null) : "'current' of method 'resolve' must not be null";
            if (clazz.isAssignableFrom(current.getClass())) {
                return (T)current;
            }
        }
        return null;
    }

    public static <T> List<T> resolve(List<String> relativePaths, Class<T> clazz, ExplorationViewRepresentation representation, boolean all) {
        assert (relativePaths != null && !relativePaths.isEmpty()) : "Parameter 'relativePaths' of method 'resolve' must not be empty";
        assert (clazz != null) : "Parameter 'clazz' of method 'resolve' must not be null";
        assert (representation != null) : "Parameter 'representation' of method 'resolve' must not be null";
        ArrayList<T> resolved = new ArrayList<T>(relativePaths.size());
        for (String next : relativePaths) {
            T nextResolved = ArchitecturalViewElementResolver.resolve(next, clazz, representation, all);
            if (nextResolved == null) continue;
            resolved.add(nextResolved);
        }
        return resolved;
    }

    public static <T> T resolveByShortName(List<String> shortNames, Class<T> clazz, ArchitecturalViewElement startElement, ExplorationViewRepresentation representation) {
        assert (shortNames != null && !shortNames.isEmpty()) : "Parameter 'shortNames' of method 'resolveByShortName' must not be empty";
        assert (clazz != null) : "Parameter 'clazz' of method 'resolveByShortName' must not be null";
        assert (startElement != null) : "Parameter 'startElement' of method 'resolveByShortName' must not be null";
        assert (representation != null) : "Parameter 'representation' of method 'resolveByShortName' must not be null";
        ArchitecturalViewElement current = startElement;
        int i = 0;
        while (i < shortNames.size()) {
            representation.getCreator().aboutToAccessChildrenOf(current, representation);
            String nextShortName = shortNames.get(i);
            current = current.resolveByShortName(nextShortName);
            if (current == null) {
                return null;
            }
            ++i;
        }
        assert (current != null) : "'current' of method 'resolve' must not be null";
        if (clazz.isAssignableFrom(current.getClass())) {
            return (T)current;
        }
        return null;
    }
}

