/*
 * Decompiled with CFR 0.152.
 */
package com.hello2morrow.sonargraph.core.controller.system.diff;

import com.hello2morrow.sonargraph.core.controller.system.analysis.base.IAnalyzerController;
import com.hello2morrow.sonargraph.core.controller.system.diff.AbstractDiffProcessor;
import com.hello2morrow.sonargraph.core.controller.system.diff.AnalyzerDiffProcessor;
import com.hello2morrow.sonargraph.core.controller.system.diff.PluginDiffProcessor;
import com.hello2morrow.sonargraph.core.controller.system.diff.QualityGateDiffProcessor;
import com.hello2morrow.sonargraph.core.model.architecture.Architecture;
import com.hello2morrow.sonargraph.core.model.architecture.ArchitectureFile;
import com.hello2morrow.sonargraph.core.model.common.SonargraphFeature;
import com.hello2morrow.sonargraph.core.model.element.NamedElement;
import com.hello2morrow.sonargraph.core.model.report.IReport;
import com.hello2morrow.sonargraph.core.model.system.Files;
import com.hello2morrow.sonargraph.core.model.system.ISoftwareSystemProvider;
import com.hello2morrow.sonargraph.core.model.system.Installation;
import com.hello2morrow.sonargraph.core.model.system.SoftwareSystem;
import com.hello2morrow.sonargraph.core.model.system.diff.BasicSystemInfoDiff;
import com.hello2morrow.sonargraph.core.model.system.diff.FeatureDiff;
import com.hello2morrow.sonargraph.core.model.system.diff.FeaturesDiff;
import com.hello2morrow.sonargraph.core.model.system.diff.IDiffElement;
import com.hello2morrow.sonargraph.core.model.system.diff.SimplePropertyDiff;
import com.hello2morrow.sonargraph.core.model.system.diff.SystemDiffPropertyName;
import com.hello2morrow.sonargraph.core.model.system.diff.architecture.ArchitectureModelDiff;
import com.hello2morrow.sonargraph.core.model.system.diff.architecture.ArchitectureModelsDiff;
import com.hello2morrow.sonargraph.foundation.utilities.StrictPair;
import com.hello2morrow.sonargraph.foundation.utilities.StringUtility;
import com.hello2morrow.sonargraph.integration.access.controller.ISystemInfoProcessor;
import com.hello2morrow.sonargraph.integration.access.model.IFeature;
import com.hello2morrow.sonargraph.integration.access.model.ISoftwareSystem;
import com.hello2morrow.sonargraph.integration.access.model.ISystemFile;
import com.hello2morrow.sonargraph.integration.access.model.SystemFileType;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Map;
import java.util.stream.Collectors;

public final class BasicSystemInfoDiffProcessor
extends AbstractDiffProcessor {
    private final IReport m_currentSystemReport;

    public BasicSystemInfoDiffProcessor(ISoftwareSystem baselineSystem, ISystemInfoProcessor baselineSystemInfoProcessor, SoftwareSystem softwareSystem, IReport currentSystemReport) {
        super(baselineSystem, baselineSystemInfoProcessor, softwareSystem);
        assert (currentSystemReport != null) : "Parameter 'currentSystemReport' of method 'BasicSystemInfoDiffProcessor' must not be null";
        this.m_currentSystemReport = currentSystemReport;
    }

    @Override
    public void process(NamedElement parent) {
        assert (parent != null) : "Parameter 'systemDiff' of method 'process' must not be null";
        BasicSystemInfoDiff basicInfoDiff = new BasicSystemInfoDiff(parent);
        this.addPropertyDiffElement(basicInfoDiff, SystemDiffPropertyName.NAME, this.getBaselineSystem().getName(), this.getSoftwareSystem().getName());
        this.addPropertyDiffElement(basicInfoDiff, SystemDiffPropertyName.ID, this.getBaselineSystem().getSystemId(), this.getSoftwareSystem().getId());
        this.addPropertyDiffElement(basicInfoDiff, SystemDiffPropertyName.DESCRIPTION, StringUtility.harmonizeNewLineBreaks((String)this.getBaselineSystem().getDescription()), StringUtility.harmonizeNewLineBreaks((String)this.getSoftwareSystem().getDescription()));
        this.addPropertyDiffElement(basicInfoDiff, SystemDiffPropertyName.PATH, this.getBaselineSystem().getPath(), this.getSoftwareSystem().getUniqueExistingChild(Files.class).getSystemDirectory().getAbsolutePath());
        Installation installation = this.getSoftwareSystem().getExtension(ISoftwareSystemProvider.class).getInstallation();
        this.addPropertyDiffElement(basicInfoDiff, SystemDiffPropertyName.SONARGRAPH_VERSION, this.getBaselineSystem().getVersion(), installation.getVersion().toString());
        IAnalyzerController analyzerExtension = this.getSoftwareSystem().getExtension(IAnalyzerController.class);
        this.addPropertyDiffElement(basicInfoDiff, SystemDiffPropertyName.ANALYZER_EXECUTION_LEVEL, this.getBaselineSystem().getAnalyzerExecutionLevel().getPresentationName(), analyzerExtension.getAnalyzerExecutionLevel().getPresentationName());
        this.addPropertyDiffElement(basicInfoDiff, SystemDiffPropertyName.CURRENT_VIRTUAL_MODEL, this.getBaselineSystem().getVirtualModel(), this.getSoftwareSystem().getCurrentModel().getPresentationName(true));
        this.addFeaturesDiff(basicInfoDiff, this.m_currentSystemReport);
        AnalyzerDiffProcessor analyzerProcessor = new AnalyzerDiffProcessor(this.getBaselineSystem(), this.getBaselineSystemInfoProcessor(), this.getSoftwareSystem(), this.m_currentSystemReport);
        analyzerProcessor.process(basicInfoDiff);
        this.addArchitecturesDiff(basicInfoDiff, this.m_currentSystemReport);
        PluginDiffProcessor pluginProcessor = new PluginDiffProcessor(this.getBaselineSystem(), this.getBaselineSystemInfoProcessor(), this.getSoftwareSystem(), this.m_currentSystemReport);
        pluginProcessor.process(basicInfoDiff);
        QualityGateDiffProcessor qualityGateProcessor = new QualityGateDiffProcessor(this.getBaselineSystem(), this.getBaselineSystemInfoProcessor(), this.getSoftwareSystem());
        qualityGateProcessor.process(basicInfoDiff);
        parent.addChild(basicInfoDiff);
    }

    private void addPropertyDiffElement(BasicSystemInfoDiff basicInfoDiff, SystemDiffPropertyName property, String baselineValue, String currentSystemValue) {
        String trimmedCurrent;
        assert (basicInfoDiff != null) : "Parameter 'basicInfoDiff' of method 'addBasicInfoDiffChild' must not be null";
        assert (property != null) : "Parameter 'property' of method 'addBasicInfoDiffChild' must not be null";
        assert (currentSystemValue != null) : "Parameter 'currentSystemValue' of method 'addBasicInfoDiffChild' must not be null";
        assert (baselineValue != null) : "Parameter 'baselineValue' of method 'addBasicInfoDiffChild' must not be null";
        String trimmedBaseline = baselineValue.trim();
        IDiffElement.Change change = trimmedBaseline.equals(trimmedCurrent = currentSystemValue.trim()) ? IDiffElement.Change.UNMODIFIED : IDiffElement.Change.MODIFIED;
        SimplePropertyDiff diff = new SimplePropertyDiff(basicInfoDiff, property.getStandardName(), property.getPresentationName(), trimmedBaseline, trimmedCurrent, change);
        basicInfoDiff.addChild(diff);
    }

    private void addFeaturesDiff(BasicSystemInfoDiff basicInfoDiff, IReport currentSystemReport) {
        assert (basicInfoDiff != null) : "Parameter 'basicInfoDiff' of method 'addExtendedSystemInfoDiff' must not be null";
        assert (currentSystemReport != null) : "Parameter 'currentSystemReport' of method 'addExtendedSystemInfoDiff' must not be null";
        FeaturesDiff featuresDiff = new FeaturesDiff(basicInfoDiff);
        Map<String, IFeature> baselineFeatureMap = this.getBaselineSystemInfoProcessor().getFeatures().stream().collect(Collectors.toMap(f -> f.getName(), f -> f));
        Map<String, SonargraphFeature> currentUnlicensedFeatures = currentSystemReport.getUnavailableFeatures().stream().collect(Collectors.toMap(f -> f.getStandardName(), f -> f));
        ArrayList<FeatureDiff> children = new ArrayList<FeatureDiff>();
        for (Map.Entry<String, SonargraphFeature> nextUnavailable : currentUnlicensedFeatures.entrySet()) {
            String featureName = nextUnavailable.getKey();
            IFeature baselineFeature = baselineFeatureMap.remove(featureName);
            if (baselineFeature == null) continue;
            IDiffElement.Change change = baselineFeature.isLicensed() ? IDiffElement.Change.REMOVED : IDiffElement.Change.UNMODIFIED;
            FeatureDiff Diff2 = new FeatureDiff(featuresDiff, baselineFeature, nextUnavailable.getValue(), false, change);
            children.add(Diff2);
        }
        Map<String, SonargraphFeature> currentAvailableFeatures = currentSystemReport.getAvailableFeatures().stream().collect(Collectors.toMap(f -> f.getStandardName(), f -> f));
        for (Map.Entry<String, SonargraphFeature> nextAvailable : currentAvailableFeatures.entrySet()) {
            String featureName = nextAvailable.getKey();
            IFeature baselineFeature = baselineFeatureMap.remove(featureName);
            IDiffElement.Change change = baselineFeature != null ? (!baselineFeature.isLicensed() ? IDiffElement.Change.ADDED : IDiffElement.Change.UNMODIFIED) : IDiffElement.Change.ADDED;
            FeatureDiff Diff3 = new FeatureDiff(featuresDiff, baselineFeature, nextAvailable.getValue(), true, change);
            children.add(Diff3);
        }
        for (IFeature next : baselineFeatureMap.values()) {
            if (!next.isLicensed()) continue;
            FeatureDiff Diff4 = new FeatureDiff(featuresDiff, next, null, false, IDiffElement.Change.REMOVED);
            children.add(Diff4);
        }
        children.sort(Comparator.comparing(NamedElement::getName));
        children.forEach(child -> featuresDiff.addChild((NamedElement)child));
        basicInfoDiff.addChild(featuresDiff);
    }

    private void addArchitecturesDiff(BasicSystemInfoDiff basicInfoDiff, IReport currentSystemReport) {
        assert (basicInfoDiff != null) : "Parameter 'basicInfoDiff' of method 'addArchitecturesDiff' must not be null";
        assert (currentSystemReport != null) : "Parameter 'currentSystemReport' of method 'addArchitecturesDiff' must not be null";
        Architecture architecture = this.getSoftwareSystem().getUniqueExistingChild(Files.class).getArchitecture();
        ArchitectureModelsDiff architecturesDiff = new ArchitectureModelsDiff((NamedElement)basicInfoDiff, architecture);
        HashMap<String, StrictPair> currentArchitectures = new HashMap<String, StrictPair>();
        for (StrictPair<ArchitectureFile, String> next : currentSystemReport.getCheckedArchitectureFiles()) {
            currentArchitectures.put(((ArchitectureFile)next.getFirst()).getIdentifyingPath(), new StrictPair((Object)((ArchitectureFile)next.getFirst()), (Object)((String)next.getSecond())));
        }
        HashMap<String, ISystemFile> baselineArchitectures = new HashMap<String, ISystemFile>();
        for (ISystemFile iSystemFile : this.getBaselineSystemInfoProcessor().getSystemFiles().stream().filter(f -> f.getType() == SystemFileType.ARCHITECTURE).collect(Collectors.toList())) {
            baselineArchitectures.put(iSystemFile.getPath(), iSystemFile);
        }
        for (Map.Entry entry : baselineArchitectures.entrySet()) {
            ArchitectureModelDiff diff;
            String identifyingPath = (String)entry.getKey();
            ISystemFile baselineArch = (ISystemFile)entry.getValue();
            StrictPair currentPair = (StrictPair)currentArchitectures.remove(identifyingPath);
            if (currentPair != null) {
                String currentHash = (String)currentPair.getSecond();
                IDiffElement.Change change = baselineArch.getHash().equals(currentHash) ? IDiffElement.Change.UNMODIFIED : IDiffElement.Change.MODIFIED;
                diff = new ArchitectureModelDiff((NamedElement)architecturesDiff, baselineArch, (ArchitectureFile)currentPair.getFirst(), change);
            } else {
                diff = new ArchitectureModelDiff((NamedElement)architecturesDiff, baselineArch, null, IDiffElement.Change.REMOVED);
            }
            architecturesDiff.addChild(diff);
        }
        for (Map.Entry entry : currentArchitectures.entrySet()) {
            ArchitectureModelDiff diff = new ArchitectureModelDiff((NamedElement)architecturesDiff, null, (ArchitectureFile)((StrictPair)entry.getValue()).getFirst(), IDiffElement.Change.ADDED);
            architecturesDiff.addChild(diff);
        }
        basicInfoDiff.addChild(architecturesDiff);
    }
}

