/*
 * Decompiled with CFR 0.152.
 */
package com.hello2morrow.sonargraph.core.controller.system.base;

import com.hello2morrow.sonargraph.core.foundation.common.history.FileHistoryOperation;
import com.hello2morrow.sonargraph.core.foundation.common.history.ModifiableFileHistory;
import com.hello2morrow.sonargraph.core.foundation.common.history.RestoreStateDto;
import com.hello2morrow.sonargraph.core.model.path.IModifiableFile;
import com.hello2morrow.sonargraph.core.model.transaction.IUndoRedoProvider;
import com.hello2morrow.sonargraph.core.model.transaction.TransactionContext;
import com.hello2morrow.sonargraph.foundation.utilities.OperationResult;
import de.schlichtherle.truezip.file.TFile;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public abstract class AbstractUndoRedoProvider
implements IUndoRedoProvider {
    protected AbstractUndoRedoProvider() {
    }

    @Override
    public void updateState(IModifiableFile file, ModifiableFileHistory.FileHistoryEntry currentEntry, boolean invalidatesParserModel) {
        assert (file != null) : "Parameter 'file' of method 'updateState' must not be null";
        assert (currentEntry != null) : "Parameter 'currentEntry' of method 'updateState' must not be null";
        if (currentEntry.needsSave() != file.needsSave()) {
            currentEntry.setNeedsSave(file.needsSave(), true);
        }
    }

    @Override
    public ModifiableFileHistory createFileHistory(String name, String fileId) {
        assert (name != null && name.length() > 0) : "Parameter 'name' of method 'createFileHistory' must not be empty";
        assert (fileId != null && fileId.length() > 0) : "Parameter 'fileId' of method 'createFileHistory' must not be empty";
        return new ModifiableFileHistory(name, fileId);
    }

    protected final List<ModifiableFileHistory.FileHistoryEntry> createEntry(String commandName, long transactionId, IModifiableFile file, ModifiableFileHistory history, boolean needsSave, TFile stateFile) {
        assert (commandName != null && commandName.length() > 0) : "Parameter 'commandName' of method 'createEntry' must not be empty";
        assert (file != null) : "Parameter 'file' of method 'createEntry' must not be null";
        assert (history != null) : "Parameter 'history' of method 'createEntry' must not be null";
        assert (stateFile != null) : "Parameter 'stateFile' of method 'createEntry' must not be null";
        ModifiableFileHistory.FileHistoryEntry fileEntry = history.createEntry(transactionId, commandName, file.getIdentifyingPath());
        List<ModifiableFileHistory.FileHistoryEntry> toBeDeleted = history.addEntry(fileEntry);
        fileEntry.setPath(stateFile.getAbsolutePath());
        fileEntry.setNeedsSave(needsSave, true);
        return toBeDeleted;
    }

    @Override
    public final RestoreStateDto startRevertOperation(ModifiableFileHistory history, IModifiableFile file) {
        assert (history != null) : "Parameter 'history' of method 'createRevertEntry' must not be null";
        assert (file != null) : "Parameter 'file' of method 'createRevertEntry' must not be null";
        RestoreStateDto dto = new RestoreStateDto(FileHistoryOperation.REVERT);
        dto.setModifiableFileId(file.getFileId());
        dto.setModifiableFilePath(file.getAbsolutePath());
        dto.setCurrentStateFileEntry(history.getLastSavedEntry());
        return dto;
    }

    @Override
    public final List<ModifiableFileHistory.FileHistoryEntry> finishRevertOperation(ModifiableFileHistory history, RestoreStateDto dto) {
        assert (history != null) : "Parameter 'history' of method 'finishRevertOperation' must not be null";
        assert (dto != null) : "Parameter 'dto' of method 'finishRevertOperation' must not be null";
        dto.getCurrentStateFileEntry().setNeedsSave(false, false);
        ArrayList entries = new ArrayList(history.getEntries());
        history.clear();
        return Collections.unmodifiableList(entries);
    }

    @Override
    public List<ModifiableFileHistory.FileHistoryEntry> createEntry(TransactionContext context, IModifiableFile file, ModifiableFileHistory history, boolean needsSave, TFile stateFile) {
        assert (context != null) : "Parameter 'context' of method 'createEntry' must not be null";
        assert (file != null) : "Parameter 'file' of method 'createEntry' must not be null";
        assert (history != null) : "Parameter 'history' of method 'createEntry' must not be null";
        assert (stateFile != null) : "Parameter 'stateFile' of method 'createEntry' must not be null";
        return this.createEntry(context.getName(), context.getId(), file, history, needsSave, stateFile);
    }

    @Override
    public String getConfirmationMessageForNextRestore(RestoreStateDto dto) {
        return null;
    }

    @Override
    public OperationResult updatePreviousEntry(ModifiableFileHistory fileHistory, IModifiableFile file) {
        assert (fileHistory != null) : "Parameter 'fileHistory' of method 'updatePreviousEntry' must not be null";
        assert (file != null) : "Parameter 'file' of method 'updatePreviousEntry' must not be null";
        return new OperationResult("Updating previous entry of '" + file.getIdentifyingPath() + "' with file content prior of last modification");
    }
}

