/*
 * Decompiled with CFR 0.152.
 */
package com.hello2morrow.sonargraph.core.controller.system.analysis.cycles;

import com.hello2morrow.sonargraph.core.model.element.NamedElement;
import com.hello2morrow.sonargraph.core.model.programming.DependencyEndpointCollector;
import com.hello2morrow.sonargraph.core.model.programming.LogicalNamespace;
import com.hello2morrow.sonargraph.core.model.programming.ProgrammingElement;
import gnu.trove.map.hash.THashMap;
import gnu.trove.set.hash.THashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;

public final class LogicalNamespaceDependencyEndpointCollector
extends DependencyEndpointCollector {
    private final Map<ProgrammingElement, LogicalNamespace> m_programmingElementToLogicalNamespace = new THashMap();
    private final boolean m_isRecursive;
    private final LogicalNamespace[] m_exceptedNamespaces;

    public LogicalNamespaceDependencyEndpointCollector(boolean isRecursive, LogicalNamespace ... except) {
        assert (except.length == 0 || isRecursive) : "Excepted namespaces only make sense if recursion is on";
        this.m_isRecursive = isRecursive;
        this.m_exceptedNamespaces = except;
    }

    public LogicalNamespaceDependencyEndpointCollector() {
        this(false, new LogicalNamespace[0]);
    }

    public void addLogicalNamespaces(List<LogicalNamespace> logicalNamespaces) {
        assert (logicalNamespaces != null) : "Parameter 'logicalNamespaces' of method 'addLogicalNamespaces' must not be null";
        for (LogicalNamespace nextLogicalNamespace : logicalNamespaces) {
            List<ProgrammingElement> elements = nextLogicalNamespace.getAllProgrammingElements(this.m_isRecursive, this.m_exceptedNamespaces);
            for (ProgrammingElement nextProgrammingElement : elements) {
                this.m_programmingElementToLogicalNamespace.put(nextProgrammingElement, nextLogicalNamespace);
            }
        }
    }

    public void reset() {
        this.m_programmingElementToLogicalNamespace.clear();
    }

    public Set<ProgrammingElement> getProgrammingElements(NamedElement forNamedElement) {
        assert (forNamedElement != null) : "Parameter 'forNamedElement' of method 'getProgrammingElements' must not be null";
        assert (forNamedElement != null && forNamedElement instanceof LogicalNamespace) : "Unexpected class in method 'getProgrammingElements': " + String.valueOf(forNamedElement);
        THashSet result = new THashSet();
        LogicalNamespace lns = (LogicalNamespace)forNamedElement;
        result.addAll(lns.getAllProgrammingElements(this.m_isRecursive, this.m_exceptedNamespaces));
        return result;
    }

    @Override
    public NamedElement getFirstCandidateForNodeAdapterLookUp(NamedElement element) {
        NamedElement parent;
        assert (element instanceof ProgrammingElement) : "Unexpected class: " + element.getClass().getName();
        while ((parent = element.getParent()) instanceof ProgrammingElement) {
            element = parent;
        }
        return this.m_programmingElementToLogicalNamespace.get(element);
    }

    @Override
    public final NamedElement getNextCandidateForNodeAdapterLookUp(NamedElement element) {
        return null;
    }
}

