/*
 * Decompiled with CFR 0.152.
 */
package com.hello2morrow.sonargraph.core.controller.system.analysis.coupling;

import com.hello2morrow.sonargraph.core.controller.system.analysis.base.AnalyzerJob;
import com.hello2morrow.sonargraph.core.controller.system.analysis.base.IAnalyzerController;
import com.hello2morrow.sonargraph.core.controller.system.analysis.coupling.AbstractDependencyMetricsSystem;
import com.hello2morrow.sonargraph.core.foundation.common.graph.INode;
import com.hello2morrow.sonargraph.core.foundation.common.graph.IOutgoingDependencyCumulatorAdapter;
import com.hello2morrow.sonargraph.core.foundation.common.graph.OutgoingDependencyCumulator;
import com.hello2morrow.sonargraph.core.model.analysis.AnalyzerResult;
import com.hello2morrow.sonargraph.core.model.analysis.CoreAnalyzerId;
import com.hello2morrow.sonargraph.core.model.analysis.IConfigurableAnalyzerId;
import com.hello2morrow.sonargraph.core.model.analysis.IMetricDescriptor;
import com.hello2morrow.sonargraph.core.model.analysis.MetricProvider;
import com.hello2morrow.sonargraph.core.model.common.AnalyzerGroup;
import com.hello2morrow.sonargraph.core.model.element.CoreProviderId;
import com.hello2morrow.sonargraph.core.model.element.NamedElement;
import com.hello2morrow.sonargraph.core.model.metrics.CoreMetricId;
import com.hello2morrow.sonargraph.core.model.metrics.CoreMetricLevel;
import com.hello2morrow.sonargraph.core.model.metrics.ValueList;
import com.hello2morrow.sonargraph.core.model.path.IComponent;
import com.hello2morrow.sonargraph.core.model.programming.DependencyEndpointCollector;
import com.hello2morrow.sonargraph.core.model.programming.NodeAdapterSet;
import com.hello2morrow.sonargraph.core.model.programming.ParserDependencyNodeAdapter;
import com.hello2morrow.sonargraph.core.model.programming.ParserDependencyNodeAdapterSet;
import com.hello2morrow.sonargraph.core.model.system.IMetricsProvider;
import com.hello2morrow.sonargraph.core.model.workspace.Module;
import com.hello2morrow.sonargraph.core.model.workspace.Workspace;
import java.util.ArrayList;
import java.util.List;

public final class OutgoingDependencyMetricsSystem
extends AbstractDependencyMetricsSystem {
    public static final IConfigurableAnalyzerId ID = CoreAnalyzerId.OUTGOING_DEPENDENCY_METRICS_SYSTEM;
    private final IMetricDescriptor m_acdMetric;
    private final IMetricDescriptor m_ccdMetric;
    private final IMetricDescriptor m_nccdMetric;
    private final IMetricDescriptor m_dependsUponSystem;
    private final IMetricDescriptor m_fanOutDescriptor;
    private final IMetricDescriptor m_propagationCostDescriptor;

    public OutgoingDependencyMetricsSystem(IAnalyzerController listener) {
        super(listener, ID);
        MetricProvider mp = this.getInstallation().getExtension(IMetricsProvider.class).getMetricProvider(CoreProviderId.INSTANCE);
        this.m_acdMetric = this.addMetricDescriptorIfNotExistent(mp, CoreMetricId.CORE_ACD, CoreMetricLevel.SYSTEM, null);
        this.m_ccdMetric = this.addMetricDescriptorIfNotExistent(mp, CoreMetricId.CORE_CCD, CoreMetricLevel.SYSTEM, null);
        this.m_nccdMetric = this.addMetricDescriptorIfNotExistent(mp, CoreMetricId.CORE_NCCD, CoreMetricLevel.SYSTEM, null);
        this.m_dependsUponSystem = this.addMetricDescriptorIfNotExistent(mp, CoreMetricId.CORE_DEPENDS_UPON_SYSTEM, CoreMetricLevel.COMPONENT, null);
        this.m_propagationCostDescriptor = this.addMetricDescriptorIfNotExistent(mp, CoreMetricId.CORE_PROPAGATION_COST, CoreMetricLevel.SYSTEM, null);
        this.m_fanOutDescriptor = this.addMetricDescriptorIfNotExistent(mp, CoreMetricId.CORE_FAN_OUT_SYSTEM, CoreMetricLevel.COMPONENT, null);
    }

    @Override
    public void runJobs(AnalyzerResult result) {
        OutgoingDependencyMetricsSystemJob job = new OutgoingDependencyMetricsSystemJob(this.getGroup(), result, this.getController());
        job.start();
    }

    private class OutgoingDependencyMetricsSystemJob
    extends AnalyzerJob
    implements IOutgoingDependencyCumulatorAdapter {
        private NodeAdapterSet<ParserDependencyNodeAdapter> m_nodeAdapterSet;
        private final ValueList m_dependsUponValues;
        private final ValueList m_fanOutValues;

        protected OutgoingDependencyMetricsSystemJob(AnalyzerGroup group, AnalyzerResult result, IAnalyzerController controller) {
            super(group, result, controller);
            this.m_dependsUponValues = OutgoingDependencyMetricsSystem.this.createValueList(result, OutgoingDependencyMetricsSystem.this.m_dependsUponSystem, this.getSoftwareSystem());
            this.m_fanOutValues = OutgoingDependencyMetricsSystem.this.createValueList(result, OutgoingDependencyMetricsSystem.this.m_fanOutDescriptor, this.getSoftwareSystem());
        }

        @Override
        public void internalRun() {
            this.getWorkerContext().working("Creating node adapter set", true);
            ArrayList<NamedElement> forNamedElements = new ArrayList<NamedElement>();
            List<Module> modules = this.getSoftwareSystem().getUniqueExistingChild(Workspace.class).getChildren(Module.class);
            if (modules.isEmpty()) {
                return;
            }
            this.getWorkerContext().setNumberOfSteps(3, new int[]{5, 5, 90});
            for (Module nextModule : modules) {
                if (this.getWorkerContext().hasBeenCanceled()) {
                    return;
                }
                List<IComponent> components = nextModule.getChildrenRecursively(IComponent.class, new Class[0]);
                for (IComponent nextComponent : components) {
                    if (this.getWorkerContext().hasBeenCanceled()) {
                        return;
                    }
                    NamedElement nextNamedElement = nextComponent.getNamedElement();
                    if (nextNamedElement.isExcluded() || nextNamedElement.getRefactoringState().hasBeenDeleted()) continue;
                    forNamedElements.add(nextNamedElement);
                }
            }
            this.getWorkerContext().endStep();
            if (!this.getWorkerContext().hasBeenCanceled() && forNamedElements.size() > 0) {
                this.getWorkerContext().beginSubTask("Create node adapter set");
                this.m_nodeAdapterSet = new ParserDependencyNodeAdapterSet(this.getWorkerContext(), forNamedElements, new DependencyEndpointCollector(), PE, PD);
                this.getWorkerContext().endSubTask();
                this.getWorkerContext().beginSubTask("Cumulate dependencies");
                if (!this.m_nodeAdapterSet.getNodes().isEmpty()) {
                    new OutgoingDependencyCumulator(this.m_nodeAdapterSet.getNodes(), this.getWorkerContext(), this);
                }
                this.getWorkerContext().endSubTask();
                this.m_nodeAdapterSet = null;
            }
        }

        @Override
        public void setDependsUpon(INode<?> node, int dependsUpon) {
            assert (node != null) : "Parameter 'node' of method 'setDependsUpon' must not be null";
            this.m_dependsUponValues.addValue(((ParserDependencyNodeAdapter)node).getUnderlyingObject(), dependsUpon);
        }

        @Override
        public void setCumulativeComponentDependency(int ccd) {
            OutgoingDependencyMetricsSystem.this.storeMetricValue(this.getResult(), this.getSoftwareSystem(), ccd, OutgoingDependencyMetricsSystem.this.m_ccdMetric);
        }

        @Override
        public void setAverageComponentDependency(float acd) {
            OutgoingDependencyMetricsSystem.this.storeMetricValue(this.getResult(), this.getSoftwareSystem(), Float.valueOf(acd), OutgoingDependencyMetricsSystem.this.m_acdMetric);
        }

        @Override
        public void setPropagationCost(float propagationCost) {
            OutgoingDependencyMetricsSystem.this.storeMetricValue(this.getResult(), this.getSoftwareSystem(), Float.valueOf(propagationCost), OutgoingDependencyMetricsSystem.this.m_propagationCostDescriptor);
        }

        @Override
        public void setNormalizedCumulativeComponentDependency(float nccd) {
            OutgoingDependencyMetricsSystem.this.storeMetricValue(this.getResult(), this.getSoftwareSystem(), Float.valueOf(nccd), OutgoingDependencyMetricsSystem.this.m_nccdMetric);
        }

        @Override
        public void setFanOut(INode<?> node, float fanOut) {
            this.m_fanOutValues.addValue(((ParserDependencyNodeAdapter)node).getUnderlyingObject(), Float.valueOf(fanOut));
        }

        @Override
        public boolean isNodeIncluded(INode<?> node) {
            assert (node != null) : "Parameter 'node' of method 'isNodeIncluded' must not be null";
            NamedElement namedElement = ((ParserDependencyNodeAdapter)node).getUnderlyingObject();
            return !namedElement.ignoreIssues();
        }
    }
}

