/*
 * Decompiled with CFR 0.152.
 */
package com.hello2morrow.sonargraph.core.controller.system.analysis.architecture;

import com.hello2morrow.sonargraph.core.controller.system.analysis.architecture.AccessResult;
import com.hello2morrow.sonargraph.core.model.architecture.ArchitectureDeprecationIssue;
import com.hello2morrow.sonargraph.core.model.architecture.ArchitectureFile;
import com.hello2morrow.sonargraph.core.model.architecture.ArchitectureProviderId;
import com.hello2morrow.sonargraph.core.model.architecture.ArchitectureViolationIssue;
import com.hello2morrow.sonargraph.core.model.architecture.Artifact;
import com.hello2morrow.sonargraph.core.model.architecture.Connector;
import com.hello2morrow.sonargraph.core.model.architecture.IArchitectureElementContainer;
import com.hello2morrow.sonargraph.core.model.architecture.Interface;
import com.hello2morrow.sonargraph.core.model.architecture.InterfaceConnection;
import com.hello2morrow.sonargraph.core.model.element.IAssignableToArtifact;
import com.hello2morrow.sonargraph.core.model.element.NamedElement;
import com.hello2morrow.sonargraph.core.model.element.ParentMode;
import com.hello2morrow.sonargraph.core.model.programming.CoreParserDependencyType;
import com.hello2morrow.sonargraph.core.model.programming.ParserDependency;
import com.hello2morrow.sonargraph.core.model.programming.ParserDependencyEdgeAdapter;
import com.hello2morrow.sonargraph.core.model.programming.ParserDependencyNodeAdapter;
import com.hello2morrow.sonargraph.core.model.programming.ProgrammingElement;
import com.hello2morrow.sonargraph.core.model.system.VirtualModel;
import com.hello2morrow.sonargraph.foundation.activity.IWorkerContext;
import gnu.trove.set.hash.THashSet;
import java.util.Collection;
import java.util.EnumSet;
import java.util.stream.Collectors;

public final class ArchitectureCheck {
    private ArchitectureCheck() {
    }

    public static AccessResult isAccessPossible(Connector fromConnector, Interface toInterface) {
        assert (fromConnector != null) : "Parameter 'fromConnector' of method 'isAccessPossible' must not be null";
        assert (toInterface != null) : "Parameter 'toInterface' of method 'isAccessPossible' must not be null";
        if (fromConnector.getConnectedInterfaces().contains(toInterface)) {
            if (toInterface.hasDependencyTypeRestrictions()) {
                return new AccessResult(toInterface.getAllowedDependencyTypes());
            }
            return new AccessResult(true);
        }
        if (fromConnector.getShortName().equals("default") && toInterface.getShortName().equals("default")) {
            Artifact from = fromConnector.getParent(Artifact.class, new Class[0]);
            Artifact to = toInterface.getParent(Artifact.class, new Class[0]);
            Artifact artifact = from;
            while (artifact != null) {
                if (artifact.isUnrestricted()) {
                    Artifact sibling;
                    NamedElement parent = artifact.getParent();
                    if (!toInterface.hasAsParent(parent, false) || (sibling = (Artifact)parent.getChildren(Artifact.class).stream().filter(a -> to == a || to.hasAsParent((NamedElement)a, false)).findFirst().orElse(null)) == artifact) break;
                    if (toInterface.hasDependencyTypeRestrictions()) {
                        return new AccessResult(toInterface.getAllowedDependencyTypes());
                    }
                    return new AccessResult(true);
                }
                if (artifact.isLocal()) break;
                artifact = artifact.getParent(Artifact.class, new Class[0]);
            }
        }
        return new AccessResult(false);
    }

    private static void processDeprecatedDependency(ParserDependencyEdgeAdapter<ParserDependencyNodeAdapter> edge, Artifact from, Artifact to, IAssignableToArtifact target, ArchitectureProviderId providerId, ArchitectureFile architectureFile, VirtualModel virtualModel) {
        assert (edge != null) : "Parameter 'edge' of method 'processDeprecatedDependency' must not be null";
        assert (from != null) : "Parameter 'from' of method 'processDeprecatedDependency' must not be null";
        assert (to != null) : "Parameter 'to' of method 'processDeprecatedDependency' must not be null";
        assert (target != null) : "Parameter 'target' of method 'processDeprecatedDependency' must not be null";
        assert (providerId != null) : "Parameter 'providerId' of method 'processDeprecatedDependency' must not be null";
        assert (architectureFile != null) : "Parameter 'architectureFile' of method 'processDeprecatedDependency' must not be null";
        assert (virtualModel != null) : "Parameter 'virtualModel' of method 'processDeprecatedDependency' must not be null";
        for (ParserDependency dep : edge.getDependencies()) {
            String description = "[" + dep.getDependencyInfo() + "] '" + from.getName() + "' should not access '" + target.getNamedElement().getShortName() + "' from '" + to.getName() + "'";
            String restriction = "'" + from.getName() + "' should not access '" + to.getName() + "'";
            ArchitectureDeprecationIssue deprecation = new ArchitectureDeprecationIssue(dep, description, providerId, Artifact.getArtifactPath(architectureFile, from), Artifact.getArtifactPath(architectureFile, to), restriction);
            IArchitectureElementContainer current = from;
            while (current != null && !current.hasDeprecations()) {
                current.setHasDeprecations(true);
                current = current.getContainer().getParent(IArchitectureElementContainer.class, ParentMode.ONLY_DIRECT_PARENT);
            }
            virtualModel.addElementIssue(dep, deprecation);
        }
    }

    private static void processRestrictedDependency(ParserDependencyEdgeAdapter<ParserDependencyNodeAdapter> edge, Artifact from, Artifact to, ArchitectureProviderId providerId, ArchitectureFile architectureFile, VirtualModel virtualModel, IConsumer consumer, EnumSet<CoreParserDependencyType> dependencyRestrictions) {
        assert (edge != null) : "Parameter 'edge' of method 'processRestrictedDependency' must not be null";
        assert (from != null) : "Parameter 'from' of method 'processRestrictedDependency' must not be null";
        assert (to != null) : "Parameter 'to' of method 'processRestrictedDependency' must not be null";
        assert (providerId != null) : "Parameter 'providerId' of method 'processRestrictedDependency' must not be null";
        assert (architectureFile != null) : "Parameter 'architectureFile' of method 'processRestrictedDependency' must not be null";
        assert (virtualModel != null) : "Parameter 'virtualModel' of method 'processRestrictedDependency' must not be null";
        assert (consumer != null) : "Parameter 'consumer' of method 'processRestrictedDependency' must not be null";
        assert (dependencyRestrictions != null) : "Parameter 'dependencyRestrictions' of method 'processRestrictedDependency' must not be null";
        Object superTypes = new THashSet();
        if (dependencyRestrictions.contains((Object)CoreParserDependencyType.EXTENDS) || dependencyRestrictions.contains((Object)CoreParserDependencyType.IMPLEMENTS)) {
            superTypes = edge.getDependencies().stream().filter(d -> d.getGenericDependencyType() == CoreParserDependencyType.EXTENDS || d.getGenericDependencyType() == CoreParserDependencyType.IMPLEMENTS).filter(d -> dependencyRestrictions.contains(d.getGenericDependencyType())).map(d -> d.getTo()).collect(Collectors.toSet());
        }
        for (ParserDependency dep : edge.getDependencies()) {
            ProgrammingElement depTo = dep.getTo();
            if (superTypes.contains(depTo) || superTypes.stream().anyMatch(t -> depTo.hasAsParent((NamedElement)t, false)) || dependencyRestrictions.contains(dep.getGenericDependencyType())) continue;
            String description = "[" + dep.getDependencyInfo() + "] '" + from.getName() + "' cannot use core dependency type '" + dep.getGenericDependencyType().getPresentationName() + "' on '" + to.getName() + "'";
            String restriction = "Cannot use core dependency type '" + dep.getGenericDependencyType().getPresentationName() + "'";
            ArchitectureViolationIssue violation = new ArchitectureViolationIssue(dep, description, providerId, Artifact.getArtifactPath(architectureFile, from), Artifact.getArtifactPath(architectureFile, to), restriction);
            virtualModel.addElementIssue(dep, violation);
            consumer.addViolatingDependency(from, to, dep);
        }
    }

    private static void processArchitectureViolation(ParserDependencyEdgeAdapter<ParserDependencyNodeAdapter> edge, Artifact from, Artifact to, IAssignableToArtifact component, IAssignableToArtifact target, ArchitectureProviderId providerId, ArchitectureFile architectureFile, VirtualModel virtualModel, IConsumer consumer, boolean belongsToAConnector) {
        assert (edge != null) : "Parameter 'edge' of method 'processDeprecatedDependency' must not be null";
        assert (from != null) : "Parameter 'from' of method 'processDeprecatedDependency' must not be null";
        assert (component != null) : "Parameter 'component' of method 'processArchitectureViolation' must not be null";
        assert (to != null) : "Parameter 'to' of method 'processDeprecatedDependency' must not be null";
        assert (target != null) : "Parameter 'target' of method 'processDeprecatedDependency' must not be null";
        assert (providerId != null) : "Parameter 'providerId' of method 'processDeprecatedDependency' must not be null";
        assert (architectureFile != null) : "Parameter 'architectureFile' of method 'processDeprecatedDependency' must not be null";
        assert (virtualModel != null) : "Parameter 'virtualModel' of method 'processDeprecatedDependency' must not be null";
        assert (consumer != null) : "Parameter 'consumer' of method 'processArchitectureViolation' must not be null";
        for (ParserDependency dep : edge.getDependencies()) {
            String restriction;
            String description;
            if (!belongsToAConnector) {
                description = "[" + dep.getDependencyInfo() + "] '" + component.getNamedElement().getShortName() + "' does not belong to any connector in '" + from.getName() + "' and therefore cannot access '" + to.getName() + "'";
                restriction = "Does not belong to any connector in '" + from.getName() + "' and therefore cannot access '" + to.getName() + "'";
            } else {
                description = "[" + dep.getDependencyInfo() + "] '" + from.getName() + "' cannot access '" + target.getNamedElement().getShortName() + "' from '" + to.getName() + "'";
                restriction = "'" + from.getName() + "' cannot access '" + to.getName() + "'";
            }
            ArchitectureViolationIssue violation = new ArchitectureViolationIssue(dep, description, providerId, Artifact.getArtifactPath(architectureFile, from), Artifact.getArtifactPath(architectureFile, to), restriction);
            virtualModel.addElementIssue(dep, violation);
            consumer.addViolatingDependency(from, to, dep);
        }
    }

    static void checkEdge(ParserDependencyEdgeAdapter<ParserDependencyNodeAdapter> edge, Artifact from, Artifact to, IAssignableToArtifact component, IAssignableToArtifact target, ArchitectureProviderId providerId, ArchitectureFile architectureFile, VirtualModel virtualModel, IConsumer consumer, IWorkerContext workerContext) {
        EnumSet<CoreParserDependencyType> localRestrictions;
        assert (edge != null) : "Parameter 'edge' of method 'checkEdge' must not be null";
        assert (from != null) : "Parameter 'from' of method 'checkEdge' must not be null";
        assert (to != null) : "Parameter 'to' of method 'checkEdge' must not be null";
        assert (component != null) : "Parameter 'component' of method 'checkEdge' must not be null";
        assert (target != null) : "Parameter 'target' of method 'checkEdge' must not be null";
        assert (providerId != null) : "Parameter 'providerId' of method 'checkEdge' must not be null";
        assert (architectureFile != null) : "Parameter 'architectureFile' of method 'checkEdge' must not be null";
        assert (virtualModel != null) : "Parameter 'virtualModel' of method 'checkEdge' must not be null";
        assert (consumer != null) : "Parameter 'consumer' of method 'checkEdge' must not be null";
        assert (workerContext != null) : "Parameter 'workerContext' of method 'checkEdge' must not be null";
        boolean belongsToAConnector = false;
        boolean belongsToDefaultConnector = false;
        boolean isAllowedDependency = false;
        boolean isRestrictedDependency = false;
        boolean isDeprecatedDependency = false;
        EnumSet<CoreParserDependencyType> dependencyRestrictions = EnumSet.allOf(CoreParserDependencyType.class);
        int dependencyTypeCount = CoreParserDependencyType.values().length;
        block0: for (Connector connector : from.getConnectors()) {
            if (workerContext.hasBeenCanceled()) {
                return;
            }
            if (!connector.contains(component)) continue;
            belongsToAConnector = true;
            if (!belongsToDefaultConnector) {
                belongsToDefaultConnector = connector.getShortName().equals("default");
            }
            for (InterfaceConnection conn : connector.getConnections()) {
                Interface iface = conn.getTargetInterface();
                if (isRestrictedDependency) {
                    localRestrictions = EnumSet.allOf(CoreParserDependencyType.class);
                    if (!iface.includes(target, res -> {
                        boolean bl = localRestrictions.retainAll((Collection<?>)res);
                    })) continue;
                    if (localRestrictions.size() == dependencyTypeCount) {
                        isAllowedDependency = true;
                        isRestrictedDependency = false;
                        isDeprecatedDependency = conn.isDeprecated();
                        break block0;
                    }
                    dependencyRestrictions.addAll(localRestrictions);
                    continue;
                }
                if (!iface.includes(target, restrictions -> {
                    boolean bl = dependencyRestrictions.retainAll((Collection<?>)restrictions);
                })) continue;
                if (dependencyRestrictions.size() == dependencyTypeCount) {
                    isAllowedDependency = true;
                    isDeprecatedDependency = conn.isDeprecated();
                    break block0;
                }
                isRestrictedDependency = true;
            }
        }
        if (belongsToDefaultConnector && !isAllowedDependency) {
            Artifact element = from;
            while (element != null) {
                NamedElement parent;
                if (element.isUnrestricted() && to.hasAsParent(parent = element.getParent(), false)) {
                    Interface defaultInterface;
                    Connector defaultConnector = from.getUniqueChild(c -> c.getShortName().equals("default"), Connector.class);
                    assert (defaultConnector != null);
                    if (!defaultConnector.getAssignedElements().contains(component)) break;
                    Artifact sibling = parent.getChildren(Artifact.class).stream().filter(a -> to == a || to.hasAsParent((NamedElement)a, false)).findFirst().orElse(null);
                    assert (sibling != null);
                    if (sibling == element || !(defaultInterface = sibling.getUniqueChild(c -> c.getShortName().equals("default"), Interface.class)).includes(target, arg_0 -> ArchitectureCheck.lambda$10(localRestrictions = EnumSet.allOf(CoreParserDependencyType.class), arg_0))) break;
                    if (localRestrictions.size() == dependencyTypeCount) {
                        isAllowedDependency = true;
                        isRestrictedDependency = false;
                        break;
                    }
                    if (isRestrictedDependency) {
                        dependencyRestrictions.addAll(localRestrictions);
                        break;
                    }
                    dependencyRestrictions.retainAll(localRestrictions);
                    isRestrictedDependency = true;
                    break;
                }
                if (element.isLocal()) break;
                element = element.getParent(Artifact.class, new Class[0]);
            }
        }
        if (isRestrictedDependency) {
            ArchitectureCheck.processRestrictedDependency(edge, from, to, providerId, architectureFile, virtualModel, consumer, dependencyRestrictions);
        } else if (!belongsToAConnector || !isAllowedDependency) {
            ArchitectureCheck.processArchitectureViolation(edge, from, to, component, target, providerId, architectureFile, virtualModel, consumer, belongsToAConnector);
        } else if (isDeprecatedDependency) {
            ArchitectureCheck.processDeprecatedDependency(edge, from, to, target, providerId, architectureFile, virtualModel);
        }
    }

    private static /* synthetic */ void lambda$10(EnumSet enumSet, EnumSet res) {
        boolean bl = enumSet.retainAll(res);
    }

    public static interface IConsumer {
        public void addViolatingDependency(Artifact var1, Artifact var2, ParserDependency var3);
    }
}

