/*
 * Decompiled with CFR 0.152.
 */
package com.hello2morrow.sonargraph.core.controller.system;

import com.hello2morrow.sonargraph.api.IPluginCoreAccess;
import com.hello2morrow.sonargraph.api.IPluginMetricId;
import com.hello2morrow.sonargraph.api.PluginDependencyMetaData;
import com.hello2morrow.sonargraph.api.PluginMetaData;
import com.hello2morrow.sonargraph.api.PluginMetricLevel;
import com.hello2morrow.sonargraph.api.PluginProgrammingElementMetaData;
import com.hello2morrow.sonargraph.core.api.model.PluginDependency;
import com.hello2morrow.sonargraph.core.api.model.PluginProgrammingElement;
import com.hello2morrow.sonargraph.core.controller.system.AnalyzerExtension;
import com.hello2morrow.sonargraph.core.controller.system.LanguageProviderAccessor;
import com.hello2morrow.sonargraph.core.controller.system.PluginConfigurationExtension;
import com.hello2morrow.sonargraph.core.controller.system.analysis.base.PluginAnalyzerAdapter;
import com.hello2morrow.sonargraph.core.controller.system.analysis.base.PluginContextAdapter;
import com.hello2morrow.sonargraph.core.controller.system.analysis.base.ResetMode;
import com.hello2morrow.sonargraph.core.controller.system.base.IFinishModelProcessor;
import com.hello2morrow.sonargraph.core.controller.system.base.ISnapshotController;
import com.hello2morrow.sonargraph.core.controller.system.base.ISoftwareSystemLifecycleListener;
import com.hello2morrow.sonargraph.core.controller.system.plugin.PluginAnalyzerId;
import com.hello2morrow.sonargraph.core.controller.system.plugin.PluginCoreAccess;
import com.hello2morrow.sonargraph.core.controllerinterface.system.IPluginExtension;
import com.hello2morrow.sonargraph.core.foundation.common.base.Language;
import com.hello2morrow.sonargraph.core.model.analysis.Analyzers;
import com.hello2morrow.sonargraph.core.model.analysis.IConfigurableAnalyzerId;
import com.hello2morrow.sonargraph.core.model.analysis.PluginAnalyzer;
import com.hello2morrow.sonargraph.core.model.common.IAnalyzerId;
import com.hello2morrow.sonargraph.core.model.common.IIssueId;
import com.hello2morrow.sonargraph.core.model.element.CoreIssueId;
import com.hello2morrow.sonargraph.core.model.element.NamedElement;
import com.hello2morrow.sonargraph.core.model.event.Modification;
import com.hello2morrow.sonargraph.core.model.event.SoftwareSystemEvent;
import com.hello2morrow.sonargraph.core.model.event.SoftwareSystemMessageCause;
import com.hello2morrow.sonargraph.core.model.metrics.CoreMetricLevel;
import com.hello2morrow.sonargraph.core.model.metrics.MetricDescriptor;
import com.hello2morrow.sonargraph.core.model.metrics.PluginMetricId;
import com.hello2morrow.sonargraph.core.model.path.IModifiableFile;
import com.hello2morrow.sonargraph.core.model.plugin.PluginConfigurationFile;
import com.hello2morrow.sonargraph.core.model.plugin.PluginExternal;
import com.hello2morrow.sonargraph.core.model.plugin.PluginIssueId;
import com.hello2morrow.sonargraph.core.model.plugin.PluginMetricProvider;
import com.hello2morrow.sonargraph.core.model.plugin.PluginProviderId;
import com.hello2morrow.sonargraph.core.model.programming.ParserDependency;
import com.hello2morrow.sonargraph.core.model.programming.ProgrammingElement;
import com.hello2morrow.sonargraph.core.model.system.Extension;
import com.hello2morrow.sonargraph.core.model.system.Files;
import com.hello2morrow.sonargraph.core.model.system.ISoftwareSystemProvider;
import com.hello2morrow.sonargraph.core.model.system.Installation;
import com.hello2morrow.sonargraph.core.model.system.MetricProviders;
import com.hello2morrow.sonargraph.core.model.system.PluginMessageCause;
import com.hello2morrow.sonargraph.core.model.system.SoftwareSystem;
import com.hello2morrow.sonargraph.core.model.workspace.ComponentContainer;
import com.hello2morrow.sonargraph.core.model.workspace.Workspace;
import com.hello2morrow.sonargraph.foundation.activity.IWorkerContext;
import com.hello2morrow.sonargraph.foundation.utilities.OperationResult;
import com.hello2morrow.sonargraph.foundation.utilities.StrictPair;
import com.hello2morrow.sonargraph.plugin.IModelPluginContext;
import com.hello2morrow.sonargraph.plugin.IModelPluginInfoConsumer;
import com.hello2morrow.sonargraph.plugin.IPluginAnalyzerContributor;
import com.hello2morrow.sonargraph.plugin.IPluginContext;
import com.hello2morrow.sonargraph.plugin.IPluginModelContributor;
import com.hello2morrow.sonargraph.plugin.SonargraphPlugin;
import com.hello2morrow.sonargraph.plugin.SonargraphPluginConfiguration;
import gnu.trove.map.hash.THashMap;
import gnu.trove.set.hash.THashSet;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.EnumSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class PluginExtension
extends Extension
implements IPluginExtension,
PluginConfigurationExtension.IConfigurationChangeHandler,
ISoftwareSystemLifecycleListener {
    private static final Logger LOGGER = LoggerFactory.getLogger(PluginExtension.class);
    private final Map<String, PluginProviderId> m_pluginIdToProviderId = new THashMap();
    private final Map<SonargraphPlugin, Set<PluginMetaData>> m_pluginIdToMetaData = new THashMap();
    private final ISoftwareSystemProvider m_softwareSystemProvider;
    private final LanguageProviderAccessor m_accessor;
    private final IFinishModelProcessor m_finishModelProcessor;

    public PluginExtension(ISoftwareSystemProvider softwareSystemProvider, LanguageProviderAccessor accessor, IFinishModelProcessor finishModelProcessor) {
        assert (softwareSystemProvider != null) : "Parameter 'softwareSystemProvider' of method 'PluginExtension' must not be null";
        assert (accessor != null) : "Parameter 'accessor' of method 'PluginExtension' must not be null";
        assert (finishModelProcessor != null) : "Parameter 'finishModelProcessor' of method 'PluginExtension' must not be null";
        this.m_softwareSystemProvider = softwareSystemProvider;
        this.m_accessor = accessor;
        this.m_finishModelProcessor = finishModelProcessor;
        this.m_finishModelProcessor.addListener(this);
    }

    @Override
    public SonargraphPlugin getPluginById(String id) {
        assert (id != null && id.length() > 0) : "Parameter 'id' of method 'getPluginById' must not be empty";
        for (PluginProviderId next : this.m_softwareSystemProvider.getInstallation().getProviderIds(PluginProviderId.class)) {
            if (!next.getPlugin().getId().equals(id)) continue;
            return next.getPlugin();
        }
        return null;
    }

    @Override
    public List<SonargraphPlugin> getPlugins() {
        List<PluginProviderId> pluginProviderIds = this.m_softwareSystemProvider.getInstallation().getProviderIds(PluginProviderId.class);
        if (pluginProviderIds.isEmpty()) {
            return Collections.emptyList();
        }
        ArrayList<SonargraphPlugin> plugins = new ArrayList<SonargraphPlugin>(pluginProviderIds.size());
        for (PluginProviderId nextPluginProviderId : pluginProviderIds) {
            plugins.add(nextPluginProviderId.getPlugin());
        }
        return plugins;
    }

    private PluginExternal findPluginExternal(Workspace workspace, final String identifier, final Language language) {
        assert (workspace != null) : "Parameter 'workspace' of method 'findPluginExternal' must not be null";
        assert (identifier != null && identifier.length() > 0) : "Parameter 'identifier' of method 'findPluginExternal' must not be empty";
        assert (language != null) : "Parameter 'language' of method 'findPluginExternal' must not be null";
        return workspace.getFirstChild(new NamedElement.IFilter(){

            @Override
            public boolean accept(NamedElement namedElement) {
                if (!($assertionsDisabled || namedElement != null && namedElement instanceof PluginExternal)) {
                    throw new AssertionError((Object)("Unexpected class in method 'findPluginExternal': " + String.valueOf(namedElement)));
                }
                return language.equals(namedElement.getLanguage()) && identifier.equals(((PluginExternal)namedElement).getIdentifier());
            }
        }, PluginExternal.class);
    }

    private void executeModelContribution(IWorkerContext workerContext, SonargraphPlugin plugin, IPluginModelContributor contributor, ExecutionPhase phase, IModelPluginContext pluginContext, IModelPluginInfoConsumer infoConsumer, SoftwareSystem softwareSystem, OperationResult result) {
        block21: {
            block20: {
                assert (plugin != null) : "Parameter 'plugin' of method 'executeModelContribution' must not be null";
                assert (contributor != null) : "Parameter 'contributor' of method 'executeModelContribution' must not be null";
                assert (phase != null) : "Parameter 'phase' of method 'executeModelContribution' must not be null";
                assert (pluginContext != null) : "Parameter 'pluginContext' of method 'executeModelPlugin' must not be null";
                assert (infoConsumer != null) : "Parameter 'infoConsumer' of method 'executeModelContribution' must not be null";
                assert (softwareSystem != null) : "Parameter 'softwareSystem' of method 'executeModelPlugin' must not be null";
                assert (result != null) : "Parameter 'result' of method 'executeModelPlugin' must not be null";
                PluginProviderId pluginProviderId = this.m_pluginIdToProviderId.get(plugin.getId());
                assert (pluginProviderId != null) : "'pluginProviderId' of method 'executeModelContribution' must not be null for: " + plugin.getId();
                softwareSystem.getIssueManager().removeIssues(pluginProviderId);
                Set supportedLanguages = plugin.getSupportedLanguages();
                if (supportedLanguages == null) break block20;
                if (!softwareSystem.getUsedLanguageStandardNames().stream().anyMatch(supportedLanguages::contains)) break block21;
            }
            LOGGER.debug("Execute model plugin '" + plugin.getId() + "' [" + String.valueOf((Object)phase) + "]");
            switch (phase) {
                case MODEL_ELEMENTS: {
                    try {
                        contributor.createModelElements(pluginContext, infoConsumer);
                    }
                    catch (Throwable throwable) {
                        result.addWarning((OperationResult.IMessageCause)SoftwareSystemMessageCause.PLUGIN_EXCEPTION, throwable, "Plugin '" + plugin.getId() + "' refresh (model elements) failed.", new Object[0]);
                        LOGGER.error(String.format("Plugin '%s' refresh (model elements) failed with an exception", plugin.getId()), throwable);
                    }
                    break;
                }
                case DEPENDENCIES: {
                    try {
                        contributor.createDependencies(pluginContext, infoConsumer);
                    }
                    catch (Throwable throwable) {
                        result.addWarning((OperationResult.IMessageCause)SoftwareSystemMessageCause.PLUGIN_EXCEPTION, throwable, "Plugin '" + plugin.getId() + "' refresh (dependencies) failed.", new Object[0]);
                        LOGGER.error(String.format("Plugin '%s' refresh (dependencies) failed with an exception", plugin.getId()), throwable);
                    }
                    break;
                }
                default: {
                    assert (false) : "Unsupported phase: " + String.valueOf((Object)phase);
                    break;
                }
            }
            LOGGER.debug("Execute model plugin '" + plugin.getId() + "' [" + String.valueOf((Object)phase) + "] - done");
        }
    }

    private List<StrictPair<SonargraphPlugin, IPluginModelContributor>> getEnabledModelContributors() {
        List<SonargraphPlugin> plugins = this.getPlugins();
        if (plugins.isEmpty()) {
            return Collections.emptyList();
        }
        ArrayList<StrictPair<SonargraphPlugin, IPluginModelContributor>> modelContributors = new ArrayList<StrictPair<SonargraphPlugin, IPluginModelContributor>>();
        for (SonargraphPlugin nextPlugin : plugins) {
            IPluginModelContributor nextModelContributor;
            if (!nextPlugin.isEnabled() || (nextModelContributor = nextPlugin.getModelContributor()) == null) continue;
            modelContributors.add((StrictPair<SonargraphPlugin, IPluginModelContributor>)new StrictPair((Object)nextPlugin, (Object)nextModelContributor));
        }
        return modelContributors;
    }

    private void clearModelContributions(SoftwareSystem softwareSystem, List<StrictPair<SonargraphPlugin, IPluginModelContributor>> modelContributors, boolean removePluginExternal) {
        assert (softwareSystem != null) : "Parameter 'softwareSystem' of method 'clearModelContributions' must not be null";
        assert (modelContributors != null && !modelContributors.isEmpty()) : "Parameter 'modelContributors' of method 'clearModelContributions' must not be empty";
        Workspace workspace = softwareSystem.getUniqueExistingChild(Workspace.class);
        THashSet pluginIds = new THashSet(modelContributors.size());
        modelContributors.forEach(arg_0 -> PluginExtension.lambda$1((Set)pluginIds, arg_0));
        PluginRemovalVisitor visitor = new PluginRemovalVisitor((Set<String>)pluginIds);
        for (ComponentContainer componentContainer : workspace.getChildren(ComponentContainer.class)) {
            componentContainer.accept(visitor);
        }
        visitor.finish();
        for (StrictPair strictPair : modelContributors) {
            if (!((IPluginModelContributor)strictPair.getSecond()).createPluginExternal()) continue;
            String nextId = ((SonargraphPlugin)strictPair.getFirst()).getId();
            for (Language nextLanguage : softwareSystem.getUsedLanguages()) {
                PluginExternal pluginExternal = this.findPluginExternal(workspace, nextId, nextLanguage);
                if (pluginExternal == null) continue;
                if (removePluginExternal) {
                    pluginExternal.remove();
                    continue;
                }
                pluginExternal.forgetChildren(true);
            }
        }
    }

    @Override
    public void aboutToModifyParserModel(IWorkerContext workerContext, SoftwareSystem softwareSystem) {
        assert (workerContext != null) : "Parameter 'workerContext' of method 'aboutToModifyParserModel' must not be null";
        assert (softwareSystem != null) : "Parameter 'softwareSystem' of method 'aboutToModifyParserModel' must not be null";
        List<StrictPair<SonargraphPlugin, IPluginModelContributor>> modelContributors = this.getEnabledModelContributors();
        if (!modelContributors.isEmpty()) {
            this.clearModelContributions(softwareSystem, modelContributors, false);
        }
    }

    private IModelPluginInfoConsumer createModelPluginInfoConsumer(final OperationResult result, final SonargraphPlugin plugin) {
        assert (result != null) : "Parameter 'result' of method 'createModelPluginInfoConsumer' must not be null";
        assert (plugin != null) : "Parameter 'plugin' of method 'createModelPluginInfoConsumer' must not be null";
        return new IModelPluginInfoConsumer(){

            public void info(String info) {
                if (!($assertionsDisabled || info != null && info.length() > 0)) {
                    throw new AssertionError((Object)"Parameter 'info' of method 'info' must not be empty");
                }
                result.addInfo((OperationResult.IMessageCause)PluginMessageCause.MODEL_PLUGIN_INFO, "Plugin '" + plugin.getId() + "': " + info);
            }

            public void error(String info, Throwable throwable) {
                if (!($assertionsDisabled || info != null && info.length() > 0)) {
                    throw new AssertionError((Object)"Parameter 'info' of method 'error' must not be empty");
                }
                result.addError((OperationResult.IMessageCause)PluginMessageCause.MODEL_PLUGIN_ERROR, "Plugin '" + plugin.getId() + "': " + info, new Object[]{throwable});
            }
        };
    }

    private IModelPluginContext createModelPluginContext(IWorkerContext workerContext, SonargraphPlugin plugin) {
        assert (workerContext != null) : "Parameter 'workerContext' of method 'createPluginContextAdapter' must not be null";
        assert (plugin != null) : "Parameter 'plugin' of method 'createPluginContextAdapter' must not be null";
        assert (this.m_softwareSystemProvider.hasSoftwareSystem()) : "No system available";
        THashMap access = new THashMap();
        access.put(IPluginCoreAccess.class, new PluginCoreAccess(this.m_softwareSystemProvider.getInstallation(), this.m_softwareSystemProvider.getSoftwareSystem(), true));
        Set supportedLanguages = plugin.getSupportedLanguages();
        if (supportedLanguages != null) {
            for (String nextLanguageName : supportedLanguages) {
                Language nextLanguage = this.m_accessor.getLanguage(nextLanguageName);
                assert (nextLanguage != null) : "'nextLanguage' of method 'internalRun' must not be null";
                this.m_accessor.getLanguageProvider(nextLanguage).addPluginAccess(this.m_softwareSystemProvider.getInstallation(), this.m_softwareSystemProvider.getSoftwareSystem(), (Map<Class<? extends IPluginCoreAccess>, IPluginCoreAccess>)access);
            }
        }
        return new PluginContextAdapter(workerContext, (Map<Class<? extends IPluginCoreAccess>, IPluginCoreAccess>)access);
    }

    private void executeModelContributorPlugins(IWorkerContext workerContext, Collection<StrictPair<SonargraphPlugin, IPluginModelContributor>> modelContributors, SoftwareSystem softwareSystem, OperationResult result) {
        assert (workerContext != null) : "Parameter 'workerContext' of method 'executeModelContributorPlugins' must not be null";
        assert (softwareSystem != null) : "Parameter 'softwareSystem' of method 'executeModelContributorPlugins' must not be null";
        assert (modelContributors != null && !modelContributors.isEmpty()) : "Parameter 'modelContributors' of method 'executeModelContributorPlugins' must not be empty";
        assert (result != null) : "Parameter 'result' of method 'executeModelContributorPlugins' must not be null";
        workerContext.working("Execute model plugings", true);
        for (StrictPair<SonargraphPlugin, IPluginModelContributor> next : modelContributors) {
            this.executeModelContribution(workerContext, (SonargraphPlugin)next.getFirst(), (IPluginModelContributor)next.getSecond(), ExecutionPhase.MODEL_ELEMENTS, this.createModelPluginContext(workerContext, (SonargraphPlugin)next.getFirst()), this.createModelPluginInfoConsumer(result, (SonargraphPlugin)next.getFirst()), softwareSystem, result);
        }
        for (StrictPair<SonargraphPlugin, IPluginModelContributor> next : modelContributors) {
            this.executeModelContribution(workerContext, (SonargraphPlugin)next.getFirst(), (IPluginModelContributor)next.getSecond(), ExecutionPhase.DEPENDENCIES, this.createModelPluginContext(workerContext, (SonargraphPlugin)next.getFirst()), this.createModelPluginInfoConsumer(result, (SonargraphPlugin)next.getFirst()), softwareSystem, result);
        }
    }

    @Override
    public void parserModelRefreshPerformed(IWorkerContext workerContext, SoftwareSystem softwareSystem, OperationResult result) {
        assert (workerContext != null) : "Parameter 'workerContext' of method 'refreshPerformed' must not be null";
        assert (softwareSystem != null) : "Parameter 'softwareSystem' of method 'refreshPerformed' must not be null";
        assert (result != null) : "Parameter 'result' of method 'refreshPerformed' must not be null";
        List<StrictPair<SonargraphPlugin, IPluginModelContributor>> modelContributors = this.getEnabledModelContributors();
        if (!modelContributors.isEmpty()) {
            this.executeModelContributorPlugins(workerContext, modelContributors, softwareSystem, result);
        }
    }

    @Override
    public void aboutToClear(IWorkerContext workerContext, SoftwareSystem softwareSystem, List<SoftwareSystemEvent> eventsToDispatch, OperationResult result) {
        assert (workerContext != null) : "Parameter 'workerContext' of method 'aboutToClear' must not be null";
        assert (softwareSystem != null) : "Parameter 'softwareSystem' of method 'aboutToClear' must not be null";
        assert (eventsToDispatch != null) : "Parameter 'eventsToDispatch' of method 'aboutToClear' must not be null";
        assert (result != null) : "Parameter 'result' of method 'aboutToClear' must not be null";
        for (SonargraphPlugin nextPlugin : this.getPlugins()) {
            if (!nextPlugin.isEnabled()) continue;
            PluginProviderId nextPluginProviderId = this.m_pluginIdToProviderId.get(nextPlugin.getId());
            assert (nextPluginProviderId != null) : "'nextPluginProviderId' of method 'aboutToClear' must not be null for: " + nextPlugin.getId();
            softwareSystem.getIssueManager().removeIssues(nextPluginProviderId);
            Workspace workspace = softwareSystem.getUniqueExistingChild(Workspace.class);
            for (Language next : softwareSystem.getUsedLanguages()) {
                PluginExternal pluginExternal = this.findPluginExternal(workspace, nextPlugin.getId(), next);
                if (pluginExternal == null) continue;
                pluginExternal.removeChildren(new Class[0]);
            }
        }
    }

    @Override
    public void cleared(IWorkerContext workerContext, SoftwareSystem softwareSystem, List<SoftwareSystemEvent> eventsToDispatch, OperationResult result) {
        assert (workerContext != null) : "Parameter 'workerContext' of method 'cleared' must not be null";
        assert (softwareSystem != null) : "Parameter 'softwareSystem' of method 'cleared' must not be null";
        assert (eventsToDispatch != null) : "Parameter 'eventsToDispatch' of method 'cleared' must not be null";
        assert (result != null) : "Parameter 'result' of method 'cleared' must not be null";
        List<SonargraphPlugin> plugins = this.getPlugins();
        if (!plugins.isEmpty()) {
            Set<String> usedLanguageStandardNames = softwareSystem.getUsedLanguageStandardNames();
            for (SonargraphPlugin nextPlugin : plugins) {
                try {
                    Set nextSupportedLanguages = nextPlugin.getSupportedLanguages();
                    if (!nextPlugin.isEnabled()) continue;
                    if (nextSupportedLanguages != null) {
                        if (!usedLanguageStandardNames.stream().anyMatch(nextSupportedLanguages::contains)) continue;
                    }
                    nextPlugin.cleared((IPluginContext)this.createModelPluginContext(workerContext, nextPlugin));
                }
                catch (Throwable e) {
                    result.addWarning((OperationResult.IMessageCause)SoftwareSystemMessageCause.PLUGIN_EXCEPTION, e, "Plugin '" + nextPlugin.getId() + "' clear failed.", new Object[0]);
                    LOGGER.error(String.format("Plugin '%s' clear failed with an exception", nextPlugin.getId()), e);
                }
            }
        }
    }

    @Override
    public void released(SoftwareSystem softwareSystem, List<SoftwareSystemEvent> eventsToDispatch, OperationResult result) {
        List<SonargraphPlugin> plugins = this.getPlugins();
        for (SonargraphPlugin nextPlugin : plugins) {
            SonargraphPluginConfiguration pluginConfiguration = nextPlugin.getConfiguration();
            pluginConfiguration.updateValues(pluginConfiguration.getDefaultValues());
        }
    }

    private PluginAnalyzer findPluginAnalyzer(Analyzers analyzers, final String pluginId) {
        assert (analyzers != null) : "Parameter 'analyzers' of method 'findPluginAnalyzer' must not be null";
        assert (pluginId != null && pluginId.length() > 0) : "Parameter 'pluginId' of method 'findPluginAnalyzer' must not be empty";
        return analyzers.getFirstChild(new NamedElement.IFilter(){

            @Override
            public boolean accept(NamedElement namedElement) {
                if (!($assertionsDisabled || namedElement != null && namedElement instanceof PluginAnalyzer)) {
                    throw new AssertionError((Object)("Unexpected class in method 'accept': " + String.valueOf(namedElement)));
                }
                return pluginId.equals(((PluginAnalyzer)namedElement).getId().getStandardName());
            }
        }, PluginAnalyzer.class);
    }

    private boolean shareAtLeastOneEntry(Set<PluginMetaData> set1, Set<PluginMetaData> set2) {
        assert (set1 != null) : "Parameter 'set1' of method 'shareAtLeastOneEntry' must not be null";
        assert (set2 != null) : "Parameter 'set2' of method 'shareAtLeastOneEntry' must not be null";
        assert (set1 != set2) : "Same instances";
        for (PluginMetaData next : set1) {
            if (!set2.contains(next)) continue;
            return true;
        }
        return false;
    }

    private void resetPlugin(SoftwareSystem softwareSystem, SonargraphPlugin plugin, PluginConfigurationExtension.ConfigurationChangedInfo info, EnumSet<Modification> modifications) {
        assert (softwareSystem != null) : "Parameter 'softwareSystem' of method 'resetPlugin' must not be null";
        assert (plugin != null) : "Parameter 'plugin' of method 'resetPlugin' must not be null";
        assert (info != null) : "Parameter 'info' of method 'resetPlugin' must not be null";
        assert (modifications != null) : "Parameter 'modifications' of method 'resetPlugin' must not be null";
        LOGGER.debug("Reset plugin '" + plugin.getId() + "'");
        PluginConfigurationExtension configurationExtension = softwareSystem.getExtension(PluginConfigurationExtension.class);
        PluginConfigurationFile pluginConfigurationFile = configurationExtension.getPluginConfigurationFile(plugin.getId());
        assert (pluginConfigurationFile != null) : "'pluginConfigurationFile' of method 'resetPlugin' must not be null";
        pluginConfigurationFile.removeIssues(CoreIssueId.PLUGIN_EXCEPTION);
        IPluginModelContributor modelContributor = plugin.getModelContributor();
        IPluginAnalyzerContributor analyzerContributor = plugin.getAnalyzerContributor();
        if (modelContributor != null || analyzerContributor != null) {
            if (modelContributor != null) {
                info.setRequiresSaveSnapshot(true);
                LOGGER.debug("Clear model contribution of model plugin '" + plugin.getId() + "'");
                this.clearModelContributions(softwareSystem, Collections.singletonList(new StrictPair((Object)plugin, (Object)modelContributor)), true);
                modifications.add(Modification.PARSER_MODEL_MODIFIED);
                Set<PluginMetaData> metaData = this.m_pluginIdToMetaData.get(plugin);
                assert (metaData != null) : "'metaData' of method 'resetPlugin' must not be null";
                for (Map.Entry<SonargraphPlugin, Set<PluginMetaData>> nextEntry : this.m_pluginIdToMetaData.entrySet()) {
                    if (nextEntry.getKey().equals((Object)plugin) || !this.shareAtLeastOneEntry(metaData, nextEntry.getValue())) continue;
                    SonargraphPlugin nextOtherPlugin = nextEntry.getKey();
                    IPluginModelContributor nextOtherModelContributor = nextOtherPlugin.getModelContributor();
                    assert (nextOtherModelContributor != null) : " 'nextOtherModelContributor' of method 'resetPlugin' must not be null";
                    if (!nextOtherPlugin.isEnabled()) continue;
                    PluginConfigurationFile nextOtherPluginConfigurationFile = configurationExtension.getPluginConfigurationFile(nextOtherPlugin.getId());
                    assert (nextOtherPluginConfigurationFile != null) : "'nextOtherPluginConfigurationFile' of method 'resetPlugin' must not be null";
                    nextOtherPluginConfigurationFile.removeIssues(CoreIssueId.PLUGIN_EXCEPTION);
                    StrictPair nextOtherPair = new StrictPair((Object)nextOtherPlugin, (Object)nextOtherModelContributor);
                    LOGGER.debug("Model plugin '" + nextOtherPlugin.getId() + "' shares meta data (clear contribution and add to affected plugins)");
                    this.clearModelContributions(softwareSystem, Collections.singletonList(nextOtherPair), false);
                    info.addAffectedModelContributorPlugin((StrictPair<SonargraphPlugin, IPluginModelContributor>)new StrictPair((Object)nextOtherPlugin, (Object)nextOtherModelContributor));
                }
            }
            if (analyzerContributor != null) {
                PluginAnalyzerId pluginAnalyzerId = new PluginAnalyzerId(plugin);
                PluginProviderId pluginProviderId = this.m_pluginIdToProviderId.get(plugin.getId());
                if (softwareSystem.getExtension(AnalyzerExtension.class).removePluginAnalyzerAdapter(pluginAnalyzerId)) {
                    LOGGER.debug("Removed plugin analyzer adapter '" + String.valueOf(pluginAnalyzerId) + "'");
                    assert (pluginProviderId != null) : "'pluginProviderId' of method 'executeModelContribution' must not be null for: " + plugin.getId();
                    softwareSystem.getIssueManager().removeIssues(pluginProviderId);
                    modifications.add(Modification.AVAILABLE_ANALYZER_PLUGINS_MODIFIED);
                }
            }
        }
        LOGGER.debug("Reset plugin '" + plugin.getId() + "' - done");
    }

    private PluginConfigurationExtension.AnalyzerRestartInfo cancelAndResetAffectedAnalyzers(SoftwareSystem softwareSystem, SonargraphPlugin plugin, boolean hasEnabledStateChanged, boolean isEnabled) {
        assert (softwareSystem != null) : "Parameter 'softwareSystem' of method 'cancelAndResetAffectedAnalyzers' must not be null";
        assert (plugin != null) : "Parameter 'plugin' of method 'cancelAndResetAffectedAnalyzers' must not be null";
        LOGGER.debug("Cancel and reset analyzers for modification of '" + plugin.getId() + "'");
        PluginConfigurationExtension.AnalyzerRestartInfo restartInfo = null;
        if (softwareSystem.isClearable() && (isEnabled || hasEnabledStateChanged)) {
            IPluginModelContributor modelContributor = plugin.getModelContributor();
            IPluginAnalyzerContributor analyzerContributor = plugin.getAnalyzerContributor();
            if (modelContributor != null || analyzerContributor != null) {
                AnalyzerExtension analyzerExtension = softwareSystem.getExtension(AnalyzerExtension.class);
                if (modelContributor != null) {
                    restartInfo = new PluginConfigurationExtension.AnalyzerRestartInfo();
                    analyzerExtension.cancelAndResetAllAnalyzers(ResetMode.ALL);
                } else if (analyzerContributor != null) {
                    THashSet affected = new THashSet(analyzerExtension.getAffectedAnalyzersOfPluginAnalyzers());
                    PluginAnalyzerId pluginAnalyzerId = new PluginAnalyzerId(plugin);
                    if (isEnabled) {
                        affected.add(pluginAnalyzerId);
                    }
                    restartInfo = new PluginConfigurationExtension.AnalyzerRestartInfo(analyzerExtension.cancelAndResetAnalyzers((Set<IAnalyzerId>)affected));
                    if (!isEnabled) {
                        restartInfo.removeAnalyzerId(pluginAnalyzerId);
                    }
                }
            }
        }
        LOGGER.debug("Cancel and reset analyzers for modification of '" + plugin.getId() + "' - done [Affected analyzers: " + (restartInfo == null ? "none" : restartInfo.toString()) + "]");
        return restartInfo;
    }

    IConfigurableAnalyzerId getPluginAnalyzerId(SoftwareSystem softwareSystem, SonargraphPlugin plugin) {
        assert (softwareSystem != null) : "Parameter 'softwareSystem' of method 'getPluginAnalyzerId' must not be null";
        assert (plugin != null) : "Parameter 'plugin' of method 'getPluginAnalyzerId' must not be null";
        Analyzers analyzers = softwareSystem.getUniqueExistingChild(Files.class).getAnalyzers();
        PluginAnalyzer analyzer = this.findPluginAnalyzer(analyzers, plugin.getId());
        return analyzer == null ? null : analyzer.getId();
    }

    private IPluginModelContributor setupModelContribution(SoftwareSystem softwareSystem, SonargraphPlugin plugin) {
        assert (softwareSystem != null) : "Parameter 'softwareSystem' of method 'setupModelContribution' must not be null";
        assert (plugin != null) : "Parameter 'plugin' of method 'setupModelContribution' must not be null";
        IPluginModelContributor modelContributor = plugin.getModelContributor();
        if (modelContributor != null) {
            if (modelContributor.createPluginExternal()) {
                Workspace workspace = softwareSystem.getUniqueExistingChild(Workspace.class);
                for (Language next : softwareSystem.getUsedLanguages()) {
                    PluginExternal pluginExternal = this.findPluginExternal(workspace, plugin.getId(), next);
                    assert (pluginExternal == null) : "'found' of method 'setupModelContribution' must be null";
                    pluginExternal = new PluginExternal(workspace, plugin.getId(), next);
                    workspace.addChild(pluginExternal);
                }
            }
            return modelContributor;
        }
        return null;
    }

    private IPluginAnalyzerContributor setupAnalyzerContribution(SoftwareSystem softwareSystem, SonargraphPlugin plugin) {
        assert (softwareSystem != null) : "Parameter 'softwareSystem' of method 'setupAnalyzerContribution' must not be null";
        assert (plugin != null) : "Parameter 'plugin' of method 'setupAnalyzerContribution' must not be null";
        IPluginAnalyzerContributor analyzerContributor = plugin.getAnalyzerContributor();
        if (analyzerContributor != null) {
            Analyzers analyzers = softwareSystem.getUniqueExistingChild(Files.class).getAnalyzers();
            assert (this.findPluginAnalyzer(analyzers, plugin.getId()) == null) : "Analyzer plugin already created for: " + plugin.getId();
            PluginAnalyzerId pluginAnalyzerId = new PluginAnalyzerId(plugin);
            AnalyzerExtension analyzerExtension = softwareSystem.getExtension(AnalyzerExtension.class);
            PluginAnalyzer pluginAnalyzer = new PluginAnalyzer(analyzers, pluginAnalyzerId);
            analyzers.addChild(pluginAnalyzer);
            PluginProviderId pluginProviderId = this.m_pluginIdToProviderId.get(plugin.getId());
            assert (pluginProviderId != null) : "'pluginProviderId' of method 'setupAnalyzerContribution' must not be null";
            PluginMetricProvider pmp = this.m_softwareSystemProvider.getInstallation().getMetricProviders().getChildren(PluginMetricProvider.class).stream().filter(c -> c.getProvider() == pluginProviderId).findFirst().orElse(null);
            List<MetricDescriptor> metricDescriptors = pmp == null ? Collections.emptyList() : pmp.getChildren(MetricDescriptor.class);
            PluginAnalyzerAdapter pluginAnalyzerAdapter = new PluginAnalyzerAdapter(pluginProviderId, plugin, analyzerContributor, analyzerExtension, pluginAnalyzerId, metricDescriptors);
            boolean isLicensed = analyzerExtension.addPluginAnalyzerAdapter(pluginAnalyzerAdapter);
            LOGGER.debug("Added plugin analyzer adapter '" + String.valueOf(pluginAnalyzerId) + "'");
            assert (isLicensed) : "If an analyzer plugin is added it must be licensed. Not licensed: " + String.valueOf(pluginAnalyzerId);
            return analyzerContributor;
        }
        return null;
    }

    public void softwareSystemOpened(SoftwareSystem softwareSystem, boolean snapshotApplied, OperationResult result) {
        assert (softwareSystem != null) : "Parameter 'softwareSystem' of method 'softwareSystemOpened' must not be null";
        assert (result != null) : "Parameter 'result' of method 'softwareSystemOpened' must not be null";
        List<PluginProviderId> pluginProviderIds = this.m_softwareSystemProvider.getInstallation().getProviderIds(PluginProviderId.class);
        if (!pluginProviderIds.isEmpty()) {
            LOGGER.debug("Setup " + pluginProviderIds.size() + " plugins in software system");
            PluginConfigurationExtension pluginConfigurationExtension = softwareSystem.getExtension(PluginConfigurationExtension.class);
            pluginProviderIds.forEach(i -> pluginConfigurationExtension.setupPlugin(i.getPlugin(), result));
            for (SonargraphPlugin nextPlugin : this.getPlugins()) {
                if (!nextPlugin.isEnabled()) continue;
                this.setupModelContribution(softwareSystem, nextPlugin);
                this.setupAnalyzerContribution(softwareSystem, nextPlugin);
            }
            LOGGER.debug("Setup " + pluginProviderIds.size() + " plugins in software system - done");
        }
    }

    @Override
    public void initializePlugin(PluginProviderId pluginProviderId, Set<PluginIssueId> pluginIssueIds, Set<PluginProgrammingElementMetaData> programmingElementMetaData, Set<PluginDependencyMetaData> dependencyMetaData, Set<PluginMetricId> metricIds) {
        assert (pluginProviderId != null) : "Parameter 'pluginIssueProviderId' of method 'initializePlugin' must not be null";
        assert (pluginIssueIds != null) : "Parameter 'pluginIssueIds' of method 'initializePlugin' must not be null";
        assert (programmingElementMetaData != null) : "Parameter 'programmingElementMetaData' of method 'initializePlugin' must not be null";
        assert (dependencyMetaData != null) : "Parameter 'dependencyMetaData' of method 'initializePlugin' must not be null";
        assert (metricIds != null) : "Parameter 'metricIds' of method 'initializePlugin' must not be null";
        assert (!this.m_softwareSystemProvider.hasSoftwareSystem()) : "Software system already created";
        SonargraphPlugin plugin = pluginProviderId.getPlugin();
        LOGGER.debug("Initialize plugin '" + plugin.getId() + "'");
        PluginProviderId previousPluginProviderId = this.m_pluginIdToProviderId.put(plugin.getId(), pluginProviderId);
        assert (previousPluginProviderId == null) : "'previousPluginProviderId' of method 'initializePlugin' must be null for: " + plugin.getId();
        Installation installation = this.m_softwareSystemProvider.getInstallation();
        installation.addProviderIds(Collections.singleton(pluginProviderId));
        installation.addIssueIds(pluginIssueIds);
        installation.addPluginProgrammingElementMetaData(pluginProviderId, programmingElementMetaData);
        installation.addPluginDependencyMetaData(pluginProviderId, dependencyMetaData);
        THashSet metaData = new THashSet(3);
        Set<PluginMetaData> previousMetaData = this.m_pluginIdToMetaData.put(plugin, (Set<PluginMetaData>)metaData);
        assert (previousMetaData == null) : "'previousMetaData' of method 'initializePlugin' must be null";
        programmingElementMetaData.forEach(arg_0 -> PluginExtension.lambda$5((Set)metaData, arg_0));
        dependencyMetaData.forEach(arg_0 -> PluginExtension.lambda$6((Set)metaData, arg_0));
        if (!metricIds.isEmpty()) {
            MetricProviders mp = installation.getMetricProviders();
            PluginMetricProvider pluginMetricProvider = new PluginMetricProvider((NamedElement)mp, pluginProviderId);
            mp.addChild(pluginMetricProvider);
            PluginAnalyzerId analyzerId = new PluginAnalyzerId(pluginProviderId.getPlugin());
            for (IPluginMetricId iPluginMetricId : metricIds) {
                for (PluginMetricLevel nextPluginMetricLevel : iPluginMetricId.getAvailableLevels()) {
                    CoreMetricLevel level = null;
                    switch (nextPluginMetricLevel) {
                        case SYSTEM: {
                            level = CoreMetricLevel.SYSTEM;
                            break;
                        }
                        case MODULE: {
                            level = CoreMetricLevel.MODULE;
                            break;
                        }
                        case SOURCE: {
                            level = CoreMetricLevel.SOURCE_FILE;
                        }
                    }
                    pluginMetricProvider.addChild(new MetricDescriptor(pluginMetricProvider, (PluginMetricId)iPluginMetricId, level, analyzerId, null, null));
                }
            }
        }
        LOGGER.debug("Initialize plugin '" + plugin.getId() + "' - done");
    }

    @Override
    public IIssueId getIssueId(String pluginId, String name) {
        assert (pluginId != null && pluginId.length() > 0) : "Parameter 'pluginId' of method 'getIssueid' must not be empty";
        assert (name != null && name.length() > 0) : "Parameter 'issueIdName' of method 'getIssueid' must not be empty";
        Installation installation = this.m_softwareSystemProvider.getInstallation();
        return installation.getFirstIssueId(id -> {
            if (id instanceof PluginIssueId) {
                PluginIssueId pid = (PluginIssueId)id;
                return pid.getPluginId().equals(pluginId) && pid.getId().equals(name);
            }
            return false;
        });
    }

    @Override
    public void configurationChanged(SoftwareSystem softwareSystem, String pluginId, EnumSet<Modification> modifications, PluginConfigurationExtension.ConfigurationChangedInfo info, boolean hasEnabledStateChanged, boolean isEnabled) {
        assert (softwareSystem != null) : "Parameter 'softwareSystem' of method 'configurationChanged' must not be null";
        assert (pluginId != null) : "Parameter 'pluginId' of method 'changed' must not be null";
        assert (modifications != null) : "Parameter 'modifications' of method 'configurationChanged' must not be null";
        assert (info != null) : "Parameter 'info' of method 'configurationChanged' must not be null";
        LOGGER.debug("Configuration changed '" + pluginId + "' [" + (isEnabled ? "Enabled" : "Disabled") + "]");
        SonargraphPlugin plugin = this.getPluginById(pluginId);
        assert (plugin != null) : "'plugin' of method 'configurationChanged' must not be null";
        PluginConfigurationExtension.AnalyzerRestartInfo restartInfo = this.cancelAndResetAffectedAnalyzers(softwareSystem, plugin, hasEnabledStateChanged, isEnabled);
        info.setAnalyzerRestartInfo(restartInfo);
        this.resetPlugin(softwareSystem, plugin, info, modifications);
        if (isEnabled) {
            LOGGER.debug("Setup plugin '" + plugin.getId() + "'");
            IPluginModelContributor pluginModelContributor = this.setupModelContribution(softwareSystem, plugin);
            if (pluginModelContributor != null) {
                modifications.add(Modification.PARSER_MODEL_MODIFIED);
                info.addAffectedModelContributorPlugin((StrictPair<SonargraphPlugin, IPluginModelContributor>)new StrictPair((Object)plugin, (Object)pluginModelContributor));
            }
            if (this.setupAnalyzerContribution(softwareSystem, plugin) != null) {
                modifications.add(Modification.AVAILABLE_ANALYZER_PLUGINS_MODIFIED);
            }
            LOGGER.debug("Setup plugin '" + plugin.getId() + "' - done");
        }
        LOGGER.debug("Configuration changed '" + pluginId + "' [" + (isEnabled ? "Enabled" : "Disabled") + "] - done");
    }

    @Override
    public void configurationChangeFinished(IWorkerContext workerContext, SoftwareSystem softwareSystem, EnumSet<Modification> modifications, PluginConfigurationExtension.ConfigurationChangedInfo info, OperationResult result) {
        Set<StrictPair<SonargraphPlugin, IPluginModelContributor>> modelContributors;
        assert (workerContext != null) : "Parameter 'workerContext' of method 'configurationChangeFinished' must not be null";
        assert (softwareSystem != null) : "Parameter 'softwareSystem' of method 'configurationChangeFinished' must not be null";
        assert (info != null) : "Parameter 'info' of method 'configurationChangeFinished' must not be null";
        assert (result != null) : "Parameter 'result' of method 'configurationChangeFinished' must not be null";
        if (modifications != null) {
            PluginConfigurationExtension.AnalyzerRestartInfo restartInfo;
            if (info.requiresSaveSnapshot()) {
                softwareSystem.getExtension(ISnapshotController.class).cancelSaveSnapshot();
            }
            if ((restartInfo = info.getAnalyzerRestartInfo()) != null && info.requiresAnalyzersRestart()) {
                if (restartInfo.all()) {
                    softwareSystem.getExtension(AnalyzerExtension.class).cancelAndResetAllAnalyzers(ResetMode.ALL);
                } else {
                    softwareSystem.getExtension(AnalyzerExtension.class).cancelAndResetAnalyzers(restartInfo.getAnalyzersToRestart());
                }
            }
        }
        if (!(modelContributors = info.getAffectedModelContributorPlugins()).isEmpty()) {
            this.executeModelContributorPlugins(workerContext, modelContributors, softwareSystem, result);
        }
        if (modifications != null) {
            if (info.requiresSaveSnapshot()) {
                LOGGER.debug("Save snapshot due to model plugin configuration change");
                softwareSystem.getExtension(ISnapshotController.class).saveSnapshot();
                softwareSystem.getExtension(ISnapshotController.class).waitForSaveToComplete();
            }
            this.m_finishModelProcessor.finishModification(workerContext, softwareSystem, modifications, result);
            PluginConfigurationExtension.AnalyzerRestartInfo restartInfo = info.getAnalyzerRestartInfo();
            if (restartInfo != null && info.requiresAnalyzersRestart()) {
                LOGGER.debug("Analyzers being restarted due to plugin change: " + restartInfo.toString());
                if (restartInfo.all()) {
                    softwareSystem.getExtension(AnalyzerExtension.class).runAutomatedAnalyzers(workerContext);
                } else {
                    softwareSystem.getExtension(AnalyzerExtension.class).runAnalyzers(restartInfo.getAnalyzersToRestart());
                }
            }
        }
    }

    @Override
    public void pluginConfigurationDeleted(IWorkerContext workerContext, SoftwareSystem softwareSystem, SonargraphPlugin plugin, EnumSet<Modification> modifications, PluginConfigurationExtension.ConfigurationChangedInfo info) {
        assert (workerContext != null) : "Parameter 'workerContext' of method 'pluginConfigurationDeleted' must not be null";
        assert (plugin != null) : "Parameter 'plugin' of method 'pluginConfigurationDeleted' must not be null";
        assert (info != null) : "Parameter 'info' of method 'pluginConfigurationDeleted' must not be null";
        LOGGER.debug("Plugin configuration deleted '" + plugin.getId() + "'");
        if (plugin.isEnabled() && modifications != null) {
            SonargraphPluginConfiguration pluginConfiguration = plugin.getConfiguration();
            pluginConfiguration.updateValues(pluginConfiguration.getDefaultValues());
            this.resetPlugin(softwareSystem, plugin, info, modifications);
        }
        LOGGER.debug("Plugin configuration deleted '" + plugin.getId() + "' - done");
    }

    public String discardPersistedSnapshot(SoftwareSystem softwareSystem) {
        assert (softwareSystem != null) : "Parameter 'softwareSystem' of method 'discardPersistedSnapshot' must not be null";
        List<IModifiableFile> modifiableFilesNeedingSave = softwareSystem.getUniqueExistingChild(Files.class).getModifiableFilesNeedingSave();
        if (!modifiableFilesNeedingSave.isEmpty()) {
            TreeSet<SonargraphPlugin> plugins = new TreeSet<SonargraphPlugin>(new Comparator<SonargraphPlugin>(){

                @Override
                public int compare(SonargraphPlugin p1, SonargraphPlugin p2) {
                    if (!$assertionsDisabled && p1 == null) {
                        throw new AssertionError((Object)"Parameter 'p1' of method 'compare' must not be null");
                    }
                    if (!$assertionsDisabled && p2 == null) {
                        throw new AssertionError((Object)"Parameter 'p2' of method 'compare' must not be null");
                    }
                    return p1.getId().compareToIgnoreCase(p2.getId());
                }
            });
            for (IModifiableFile next : modifiableFilesNeedingSave) {
                if (!(next instanceof PluginConfigurationFile)) continue;
                PluginConfigurationFile nextPluginConfigurationFile = (PluginConfigurationFile)next;
                for (SonargraphPlugin nextPlugin : this.getPlugins()) {
                    boolean enabledInFile;
                    if (nextPlugin.getModelContributor() == null || !nextPlugin.getId().equals(nextPluginConfigurationFile.getPluginId()) || (enabledInFile = softwareSystem.getExtension(PluginConfigurationExtension.class).isEnabledOnDisk(nextPlugin.getId())) == nextPlugin.isEnabled()) continue;
                    LOGGER.debug("Discard persistent snapshot - model contributor plugin " + nextPlugin.getId() + " not saved with enabled state mismatch.");
                    plugins.add(nextPlugin);
                }
            }
            if (!plugins.isEmpty()) {
                StringBuilder builder = new StringBuilder("");
                builder.append("Because " + plugins.size()).append(" model plugin configuration file(s) modified but not saved:");
                for (SonargraphPlugin next : plugins) {
                    builder.append("\n - ").append(next.getId());
                }
                return builder.toString();
            }
        }
        return null;
    }

    private static /* synthetic */ void lambda$1(Set set, StrictPair e) {
        boolean bl = set.add(((SonargraphPlugin)e.getFirst()).getId());
    }

    private static /* synthetic */ void lambda$5(Set set, PluginProgrammingElementMetaData m) {
        boolean bl = set.add(m);
    }

    private static /* synthetic */ void lambda$6(Set set, PluginDependencyMetaData m) {
        boolean bl = set.add(m);
    }

    private static enum ExecutionPhase {
        MODEL_ELEMENTS,
        DEPENDENCIES;

    }

    private static final class PluginRemovalVisitor
    implements ProgrammingElement.IVisitor,
    PluginProgrammingElement.IVisitor {
        private final Set<String> m_pluginIds;
        private final Set<PluginProgrammingElement> m_toBeRemoved = new THashSet();

        PluginRemovalVisitor(Set<String> pluginIds) {
            assert (pluginIds != null && !pluginIds.isEmpty()) : "Parameter 'pluginIds' of method 'PluginRemovalVisitor' must not be empty";
            this.m_pluginIds = pluginIds;
        }

        @Override
        public void visitChildrenOf(NamedElement namedElement) {
            assert (namedElement != null) : "Parameter 'namedElement' of method 'visitChildrenOf' must not be null";
            namedElement.getChildren().forEach(c -> c.accept(this));
        }

        @Override
        public void visitNamedElement(NamedElement namedElement) {
            assert (namedElement != null) : "Parameter 'namedElement' of method 'visitNamedElement' must not be null";
            this.visitChildrenOf(namedElement);
        }

        @Override
        public void visitPluginProgrammingElement(PluginProgrammingElement element) {
            assert (element != null) : "Parameter 'element' of method 'visitGenericProgrammingElement' must not be null";
            if (this.m_pluginIds.contains(element.getPluginId())) {
                this.m_toBeRemoved.add(element);
            }
        }

        @Override
        public void visitProgrammingElement(ProgrammingElement element) {
            assert (element != null) : "Parameter 'element' of method 'visitProgrammingElement' must not be null";
            Iterator<ParserDependency> iter = element.getDependencyIterator();
            while (iter.hasNext()) {
                ParserDependency next = iter.next();
                if (!(next instanceof PluginDependency) || !this.m_pluginIds.contains(((PluginDependency)next).getPluginId())) continue;
                iter.remove();
            }
            this.visitChildrenOf(element);
        }

        void finish() {
            this.m_toBeRemoved.forEach(r -> r.remove());
        }
    }
}

