/*
 * Decompiled with CFR 0.152.
 */
package com.hello2morrow.sonargraph.core.controller.system;

import com.hello2morrow.sonargraph.core.foundation.common.base.ITextValidator;
import com.hello2morrow.sonargraph.core.foundation.common.base.ValidationResult;
import com.hello2morrow.sonargraph.core.model.filter.Filter;
import com.hello2morrow.sonargraph.core.model.filter.WildcardPattern;
import com.hello2morrow.sonargraph.core.model.filter.WildcardPatternInclude;
import com.hello2morrow.sonargraph.foundation.utilities.StringUtility;

final class PatternValidator
implements ITextValidator {
    private final Filter m_filter;

    PatternValidator(Filter filter) {
        assert (filter != null) : "Parameter 'filter' of method 'PatternValidator' must not be null";
        this.m_filter = filter;
    }

    @Override
    public ValidationResult isValid(String currentInput, String newInput) {
        ValidationResult result = new ValidationResult(!StringUtility.areEqual((String)currentInput, (String)newInput));
        String string = newInput = newInput != null ? newInput.trim() : null;
        if (newInput == null || newInput.isEmpty()) {
            result.addError("Must not be empty");
        } else {
            String notValid;
            boolean checkValidity = true;
            for (WildcardPattern next : this.m_filter.getChildren(WildcardPattern.class)) {
                if (!next.getName().equals(newInput)) continue;
                result.addError("Already defined as '" + (next instanceof WildcardPatternInclude ? "include" : "exclude") + "'");
                checkValidity = false;
                break;
            }
            if (checkValidity && (notValid = WildcardPattern.isValid(newInput)) != null) {
                result.addError("Not valid: " + notValid);
            }
        }
        return result;
    }
}

