/*
 * Decompiled with CFR 0.152.
 */
package com.hello2morrow.sonargraph.core.controller.system;

import com.hello2morrow.sonargraph.core.controller.system.IDeltaDetector;
import com.hello2morrow.sonargraph.core.model.event.SoftwareSystemMessageCause;
import com.hello2morrow.sonargraph.core.model.system.ModuleDelta;
import com.hello2morrow.sonargraph.core.model.workspace.Module;
import com.hello2morrow.sonargraph.foundation.activity.IWorkerContext;
import com.hello2morrow.sonargraph.foundation.utilities.OperationResult;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Map;

public final class DeltaDetection {
    private DeltaDetection() {
    }

    private static void addModuleToOrderedList(List<Module> modules, Module module) {
        assert (modules != null) : "Parameter 'modules' of method 'addModuleToOrderedList' must not be null";
        assert (module != null) : "Parameter 'module' of method 'addModuleToOrderedList' must not be null";
        boolean addedReferencedModule = false;
        modules.add(module);
        for (Module referencedModule : module.getReferencedToModules(false)) {
            if (modules.contains(referencedModule)) continue;
            DeltaDetection.addModuleToOrderedList(modules, referencedModule);
            addedReferencedModule = true;
        }
        if (addedReferencedModule) {
            modules.remove(module);
            modules.add(module);
        }
    }

    private static void sort(List<IDeltaDetector> deltaDetectors) {
        assert (deltaDetectors != null && !deltaDetectors.isEmpty()) : "Parameter 'deltaDetectors' of method 'orderDeltaDetectors' must not be empty";
        final ArrayList<Module> orderedModuleList = new ArrayList<Module>(deltaDetectors.size());
        for (IDeltaDetector next : deltaDetectors) {
            Module nextModule = next.getModule();
            if (orderedModuleList.contains(nextModule)) continue;
            DeltaDetection.addModuleToOrderedList(orderedModuleList, nextModule);
        }
        Collections.sort(deltaDetectors, new Comparator<IDeltaDetector>(){

            @Override
            public int compare(IDeltaDetector d1, IDeltaDetector d2) {
                if (!$assertionsDisabled && d1 == null) {
                    throw new AssertionError((Object)"Parameter 'd1' of method 'compare' must not be null");
                }
                if (!$assertionsDisabled && d2 == null) {
                    throw new AssertionError((Object)"Parameter 'd2' of method 'compare' must not be null");
                }
                Module m1 = d1.getModule();
                Module m2 = d2.getModule();
                return orderedModuleList.indexOf(m1) - orderedModuleList.indexOf(m2);
            }
        });
    }

    public static List<ModuleDelta> detectDelta(IWorkerContext workerContext, Map<Module, IDeltaDetector> moduleToDeltaDetector, OperationResult result) {
        assert (workerContext != null) : "Parameter 'workerContext' of method 'performDeltaDetection' must not be null";
        assert (moduleToDeltaDetector != null && !moduleToDeltaDetector.isEmpty()) : "Parameter 'moduleToDeltaDetector' of method 'detectDelta' must not be empty";
        assert (result != null) : "Parameter 'result' of method 'performDeltaDetection' must not be null";
        ArrayList<ModuleDelta> moduleDeltas = new ArrayList<ModuleDelta>(moduleToDeltaDetector.size());
        ArrayList<IDeltaDetector> detectorList = new ArrayList<IDeltaDetector>();
        workerContext.setNumberOfSteps(2 * moduleToDeltaDetector.size());
        for (Map.Entry<Module, IDeltaDetector> nextEntry : moduleToDeltaDetector.entrySet()) {
            Module nextModule = nextEntry.getKey();
            IDeltaDetector nextDetector = nextEntry.getValue();
            workerContext.beginSubTask(String.format("Synchronizing of module '%s'", nextModule.getShortName()));
            workerContext.setNumberOfSteps(1);
            try {
                try {
                    nextDetector.synchronize(result);
                    detectorList.add(nextDetector);
                }
                catch (Throwable t) {
                    result.addError((OperationResult.IMessageCause)SoftwareSystemMessageCause.FAILED_TO_DETECT_DELTA, t);
                    workerContext.endStep();
                    workerContext.endSubTask();
                    continue;
                }
            }
            catch (Throwable throwable) {
                workerContext.endStep();
                workerContext.endSubTask();
                throw throwable;
            }
            workerContext.endStep();
            workerContext.endSubTask();
        }
        if (result.isFailure()) {
            return moduleDeltas;
        }
        DeltaDetection.sort(detectorList);
        boolean changesDetected = false;
        for (IDeltaDetector detector : detectorList) {
            ModuleDelta delta = null;
            workerContext.beginSubTask(String.format("Detecting delta of module '%s'", detector.getModule().getShortName()));
            try {
                try {
                    delta = detector.detectDelta(workerContext, result, changesDetected);
                    if (delta != null && !delta.isEmpty()) {
                        moduleDeltas.add(delta);
                        changesDetected = true;
                    }
                }
                catch (Throwable t) {
                    result.addError((OperationResult.IMessageCause)SoftwareSystemMessageCause.FAILED_TO_DETECT_DELTA, t);
                    workerContext.endSubTask();
                    continue;
                }
            }
            catch (Throwable throwable) {
                workerContext.endSubTask();
                throw throwable;
            }
            workerContext.endSubTask();
        }
        return moduleDeltas;
    }
}

