/*
 * Decompiled with CFR 0.152.
 */
package com.hello2morrow.sonargraph.core.controller.system;

import com.hello2morrow.sonargraph.api.IParserDependencyType;
import com.hello2morrow.sonargraph.core.controller.system.analysis.base.DirectoryDependencyEndpointCollector;
import com.hello2morrow.sonargraph.core.controller.system.analysis.cycles.CyclesAnalyzerAdapter;
import com.hello2morrow.sonargraph.core.controller.system.analysis.cycles.LogicalNamespaceDependencyEndpointCollector;
import com.hello2morrow.sonargraph.core.controllerinterface.system.ICycleElementMetricsExtension;
import com.hello2morrow.sonargraph.core.model.analysis.AnalyzerCycleGroup;
import com.hello2morrow.sonargraph.core.model.analysis.CycleElementMetrics;
import com.hello2morrow.sonargraph.core.model.element.NamedElement;
import com.hello2morrow.sonargraph.core.model.programming.CoreParserDependencyType;
import com.hello2morrow.sonargraph.core.model.programming.DependencyEndpointCollector;
import com.hello2morrow.sonargraph.core.model.programming.IMethod;
import com.hello2morrow.sonargraph.core.model.programming.IType;
import com.hello2morrow.sonargraph.core.model.programming.ParserDependency;
import com.hello2morrow.sonargraph.core.model.programming.ParserDependencyEdgeAdapter;
import com.hello2morrow.sonargraph.core.model.programming.ParserDependencyNodeAdapter;
import com.hello2morrow.sonargraph.core.model.programming.ParserDependencyNodeAdapterSet;
import com.hello2morrow.sonargraph.core.model.programming.ProgrammingElement;
import com.hello2morrow.sonargraph.core.model.programming.TopLevelLogicalProgrammingElementCollector;
import com.hello2morrow.sonargraph.core.model.system.Extension;
import com.hello2morrow.sonargraph.foundation.activity.IWorkerContext;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Set;

final class CycleMetricsExtension
extends Extension
implements ICycleElementMetricsExtension {
    CycleMetricsExtension() {
    }

    @Override
    public List<CycleElementMetrics> calculateElementMetrics(IWorkerContext workerContext, AnalyzerCycleGroup cycleGroup) {
        assert (workerContext != null) : "Parameter 'workerContext' of method 'calculateElementMetrics' must not be null";
        assert (cycleGroup != null) : "Parameter 'cycleGroup' of method 'calculateElementMetrics' must not be null";
        ArrayList result = new ArrayList(cycleGroup.getNumberOfChildren());
        Set<NamedElement> cyclicElements = cycleGroup.getCyclicNamedElements();
        DependencyEndpointCollector collector = null;
        boolean calculateInterfaceable = false;
        switch (cycleGroup.getKind()) {
            case COMPONENT_CYCLES: {
                collector = new DependencyEndpointCollector();
                calculateInterfaceable = true;
                break;
            }
            case DIRECTORY_CYCLES: {
                collector = new DirectoryDependencyEndpointCollector();
                break;
            }
            case LOGICAL_TOPLEVEL_ELEMENT_CYCLES: {
                collector = new TopLevelLogicalProgrammingElementCollector();
                calculateInterfaceable = true;
                break;
            }
            case PACKAGE_OR_NAMESPACE_CYCLES: {
                collector = new LogicalNamespaceDependencyEndpointCollector();
                break;
            }
            case MODULE_CYCLES: {
                return Collections.emptyList();
            }
        }
        ParserDependencyNodeAdapterSet nodeAdapterSet = new ParserDependencyNodeAdapterSet(workerContext, cyclicElements, collector, CyclesAnalyzerAdapter.PE, CyclesAnalyzerAdapter.PD);
        for (ParserDependencyNodeAdapter node : nodeAdapterSet.getNodes()) {
            if (workerContext.hasBeenCanceled()) {
                return Collections.emptyList();
            }
            NamedElement element = node.getUnderlyingObject();
            int incomingCount = node.getIncomingEdges().size();
            int outgoingCount = node.getOutgoingEdges().size();
            int interfaceableIncomingCount = 0;
            if (calculateInterfaceable) {
                for (ParserDependencyEdgeAdapter<ParserDependencyNodeAdapter> edge : node.getIncomingEdges()) {
                    if (workerContext.hasBeenCanceled()) {
                        return Collections.emptyList();
                    }
                    boolean qualifies = true;
                    IType targetType = null;
                    for (ParserDependency pd : edge.getDependencies()) {
                        if (workerContext.hasBeenCanceled()) {
                            return Collections.emptyList();
                        }
                        IParserDependencyType depType = pd.getDependencyType().getGenericDependencyType();
                        if (depType != CoreParserDependencyType.USES && depType != CoreParserDependencyType.CALL) {
                            qualifies = false;
                            break;
                        }
                        ProgrammingElement target = pd.getTo();
                        if (target instanceof IType) {
                            IType type = (IType)((Object)target);
                            if (!type.isClass()) {
                                qualifies = false;
                                break;
                            }
                            if (targetType == null) {
                                targetType = type;
                                continue;
                            }
                            if (targetType == type) continue;
                            qualifies = false;
                            break;
                        }
                        if (target instanceof IMethod) {
                            IMethod method = (IMethod)((Object)target);
                            IType type = target.getParent(IType.class, new Class[0]);
                            if (type == null || !type.isClass() || method.isStatic()) {
                                qualifies = false;
                                break;
                            }
                            if (targetType == null) {
                                targetType = type;
                                continue;
                            }
                            if (targetType == type) continue;
                            qualifies = false;
                            break;
                        }
                        qualifies = false;
                        break;
                    }
                    if (!qualifies) continue;
                    ++interfaceableIncomingCount;
                }
            }
            result.add(new CycleElementMetrics(element, incomingCount, outgoingCount, interfaceableIncomingCount));
        }
        return workerContext.hasBeenCanceled() ? Collections.emptyList() : result;
    }
}

