/*
 * Decompiled with CFR 0.152.
 */
package com.hello2morrow.sonargraph.core.controller.generic;

import com.hello2morrow.sonargraph.core.controller.generic.GenericLanguageProviderRefactoringAdapter;
import com.hello2morrow.sonargraph.core.controller.system.LanguageProvider;
import com.hello2morrow.sonargraph.core.controller.system.LanguageProviderRefactoringAdapter;
import com.hello2morrow.sonargraph.core.foundation.common.base.Language;
import com.hello2morrow.sonargraph.core.model.architecture.IAssignableAttributeRetriever;
import com.hello2morrow.sonargraph.core.model.element.NamedElement;
import com.hello2morrow.sonargraph.core.model.generic.programming.GenericExternalLogicalNamespaceRoot;
import com.hello2morrow.sonargraph.core.model.generic.programming.GenericInternalLogicalNamespaceRoot;
import com.hello2morrow.sonargraph.core.model.generic.programming.GenericLogicalModuleNamespace;
import com.hello2morrow.sonargraph.core.model.generic.programming.GenericLogicalSystemNamespace;
import com.hello2morrow.sonargraph.core.model.generic.programming.GenericWorkspaceDependency;
import com.hello2morrow.sonargraph.core.model.programming.ExternalLogicalNamespaceRoot;
import com.hello2morrow.sonargraph.core.model.programming.IWorkspaceDependencyElement;
import com.hello2morrow.sonargraph.core.model.programming.LogicalModuleNamespace;
import com.hello2morrow.sonargraph.core.model.programming.LogicalNamespaceRoot;
import com.hello2morrow.sonargraph.core.model.programming.LogicalNamespaceScope;
import com.hello2morrow.sonargraph.core.model.programming.LogicalSystemNamespace;
import com.hello2morrow.sonargraph.core.model.programming.UnresolvedWorkspaceDependencyElement;
import com.hello2morrow.sonargraph.core.model.programming.WorkspaceDependency;
import com.hello2morrow.sonargraph.core.model.system.SoftwareSystem;
import com.hello2morrow.sonargraph.core.model.workspace.External;
import com.hello2morrow.sonargraph.core.model.workspace.Module;
import com.hello2morrow.sonargraph.core.model.workspace.Workspace;
import com.hello2morrow.sonargraph.foundation.utilities.CategoryProvider;
import java.util.Collections;
import java.util.List;

public abstract class GenericLanguageProvider
extends LanguageProvider {
    private final LanguageProviderRefactoringAdapter m_refactoringAdapter;
    private final Class<? extends Module> m_moduleClass;

    public GenericLanguageProvider(Language language, Class<? extends Module> moduleClass, LanguageProviderRefactoringAdapter refactoringAdapter) {
        super(language);
        assert (moduleClass != null) : "Parameter 'moduleClass' of method 'GenericLanguageProvider' must not be null";
        assert (refactoringAdapter != null) : "Parameter 'refactoringAdapter' of method 'GenericLanguageProvider' must not be null";
        this.m_refactoringAdapter = refactoringAdapter;
        this.m_moduleClass = moduleClass;
    }

    public GenericLanguageProvider(Language language, Class<? extends Module> moduleClass) {
        this(language, moduleClass, new GenericLanguageProviderRefactoringAdapter(language, moduleClass));
    }

    @Override
    public final LanguageProviderRefactoringAdapter getRefactoringAdapter() {
        return this.m_refactoringAdapter;
    }

    @Override
    protected final Class<? extends Module> getModuleClass() {
        return this.m_moduleClass;
    }

    @Override
    public CategoryProvider getLogicalCategoryProvider() {
        CategoryProvider cp = this.getPhysicalCategoryProvider();
        cp.setCategory(GenericExternalLogicalNamespaceRoot.class, 1000);
        return cp;
    }

    @Override
    public WorkspaceDependency createWorkspaceDependency(SoftwareSystem softwareSystem, IWorkspaceDependencyElement from, String toId, String toName, String type, WorkspaceDependency.AdditionalDependencyData dependencyData) {
        assert (softwareSystem != null) : "Parameter 'softwareSystem' of method 'createWorkspaceDependency' must not be null";
        assert (from != null) : "Parameter 'from' of method 'createWorkspaceDependency' must not be null";
        assert (toId != null && toId.length() > 0) : "Parameter 'to' of method 'createWorkspaceDependency' must not be empty";
        assert (toName != null && toName.length() > 0) : "Parameter 'toName' of method 'createWorkspaceDependency' must not be empty";
        assert (type != null && type.length() > 0) : "Parameter 'type' of method 'createWorkspaceDependency' must not be empty";
        assert (dependencyData != null) : "Parameter 'dependencyData' of method 'createWorkspaceDependency' must not be null";
        WorkspaceDependency.IWorkspaceDependencyType dependencyType = this.getWorkspaceDependencyType(type);
        if (dependencyType == null) {
            return null;
        }
        IWorkspaceDependencyElement endpoint = this.findWorkspaceDependencyElement(softwareSystem.getUniqueExistingChild(Workspace.class), from, dependencyType, toId, toName, dependencyData, false);
        GenericWorkspaceDependency dependency = null;
        if (endpoint == null) {
            NamedElement parent = ((NamedElement)from.getUnderlyingObject()).getParent();
            UnresolvedWorkspaceDependencyElement unresolved = Module.addUnresolvedWorkspaceDependencyElement(parent, toName, toId);
            endpoint = unresolved;
        }
        dependency = new GenericWorkspaceDependency(from, endpoint);
        dependency.setAdditionalDependencyData(dependencyData);
        return dependency;
    }

    private WorkspaceDependency.IWorkspaceDependencyType getWorkspaceDependencyType(String workspaceDependencyStandardName) {
        if (GenericWorkspaceDependency.DEFAULT_TYPE.getStandardName().equals(workspaceDependencyStandardName)) {
            return GenericWorkspaceDependency.DEFAULT_TYPE;
        }
        return null;
    }

    @Override
    public final LogicalNamespaceRoot createLogicalNamespaceRoot(NamedElement parent) {
        return new GenericInternalLogicalNamespaceRoot(parent, this.getLanguage());
    }

    @Override
    public final ExternalLogicalNamespaceRoot createExternalLogicalNamespaceRoot(NamedElement parent, NamedElement external, LogicalNamespaceScope scope) {
        assert (parent != null) : "Parameter 'parent' of method 'createExternalLogicalNamespaceRoot' must not be null";
        assert (external != null) : "Parameter 'external' of method 'createExternalLogicalNamespaceRoot' must not be null";
        return new GenericExternalLogicalNamespaceRoot(parent, external, scope);
    }

    @Override
    public final LogicalSystemNamespace createLogicalSystemNamespace(NamedElement parent, String name) {
        return new GenericLogicalSystemNamespace(parent, name, this.getLanguage(), this.getNamespaceMetricLevel());
    }

    @Override
    public final LogicalModuleNamespace createLogicalModuleNamespace(NamedElement parent, String name) {
        return new GenericLogicalModuleNamespace(parent, name, this.getLanguage(), this.getNamespaceMetricLevel());
    }

    @Override
    public void lastModuleDeleted(SoftwareSystem softwareSystem) {
        super.lastModuleDeleted(softwareSystem);
        External external = softwareSystem.getUniqueExistingChild(Workspace.class).getUniqueChild(this.getExternalClass());
        assert (external != null) : "'external' of method 'deinitialize' must not be null";
        external.remove();
    }

    @Override
    public List<IAssignableAttributeRetriever> createAssignableAttributeRetrievers() {
        return Collections.emptyList();
    }
}

