/*
 * Decompiled with CFR 0.152.
 */
package com.hello2morrow.sonargraph.core.command.system.script;

import com.hello2morrow.sonargraph.core.command.common.ICommandId;
import com.hello2morrow.sonargraph.core.command.common.ICommandInteraction;
import com.hello2morrow.sonargraph.core.command.system.base.CoreCommandId;
import com.hello2morrow.sonargraph.core.command.system.base.SoftwareSystemBasedCommand;
import com.hello2morrow.sonargraph.core.controllerinterface.system.IGroovyExtension;
import com.hello2morrow.sonargraph.core.controllerinterface.system.IUndoRedoExtension;
import com.hello2morrow.sonargraph.core.model.element.Element;
import com.hello2morrow.sonargraph.core.model.path.IModifiableFile;
import com.hello2morrow.sonargraph.core.model.system.ISoftwareSystemProvider;
import com.hello2morrow.sonargraph.core.model.system.SoftwareSystem;
import com.hello2morrow.sonargraph.foundation.activity.IWorkerContext;
import com.hello2morrow.sonargraph.foundation.utilities.OperationResult;
import java.util.Collection;
import java.util.List;

public final class DeleteGroovyScriptElementsCommand
extends SoftwareSystemBasedCommand<IInteraction> {
    public static boolean areDeletableScriptElements(ISoftwareSystemProvider provider, List<Element> elements) {
        assert (provider != null) : "Parameter 'provider' of method 'areDeletableScriptElements' must not be null";
        assert (elements != null && !elements.isEmpty()) : "Parameter 'elements' of method 'areDeletableScriptElements' must not be empty";
        return provider.hasSoftwareSystem() && provider.getSoftwareSystem().getExtension(IGroovyExtension.class).areDeletableScriptElements(elements);
    }

    public DeleteGroovyScriptElementsCommand(ISoftwareSystemProvider provider, IInteraction interaction) {
        super(provider, interaction);
    }

    @Override
    public final ICommandId getId() {
        return CoreCommandId.DELETE_GROOVY_SCRIPT_ELEMENTS;
    }

    @Override
    public boolean isUndoable() {
        return false;
    }

    @Override
    protected void internalRun(IWorkerContext workerContext) {
        IModifiableFile scriptRunnerFile;
        List<? extends Element> elements = ((IInteraction)this.getInteraction()).getElements();
        if (elements == null || elements.isEmpty()) {
            return;
        }
        SoftwareSystem softwareSystem = this.getController().getSoftwareSystem();
        IGroovyExtension groovyExtension = softwareSystem.getExtension(IGroovyExtension.class);
        IUndoRedoExtension undoRedoExtension = softwareSystem.getExtension(IUndoRedoExtension.class);
        boolean hasHistoryEntries = false;
        if (undoRedoExtension != null && (scriptRunnerFile = groovyExtension.getScriptRunnerConfigurationFile()) != null && undoRedoExtension.getHistorySize(scriptRunnerFile) > 0) {
            hasHistoryEntries = true;
        }
        if (!((IInteraction)this.getInteraction()).confirmDeletion(groovyExtension.scriptElementsDeletionAffectsScriptRunner(elements), hasHistoryEntries)) {
            return;
        }
        ((IInteraction)this.getInteraction()).processDeletionResult(groovyExtension.delete(workerContext, elements));
    }

    public static interface IInteraction
    extends ICommandInteraction {
        public List<? extends Element> getElements();

        public void processDeletionResult(OperationResult var1);

        public boolean confirmDeletion(Collection<String> var1, boolean var2);
    }
}

