/*
 * Decompiled with CFR 0.152.
 */
package com.hello2morrow.sonargraph.core.command.system.remoting;

import com.hello2morrow.sonargraph.core.command.common.ICommandId;
import com.hello2morrow.sonargraph.core.command.common.ICommandInteractionData;
import com.hello2morrow.sonargraph.core.command.common.ICommandInteractionWithResult;
import com.hello2morrow.sonargraph.core.command.system.base.CoreCommandId;
import com.hello2morrow.sonargraph.core.command.system.base.InstallationBasedCommand;
import com.hello2morrow.sonargraph.core.controllerinterface.system.IRemoteSelectionExtension;
import com.hello2morrow.sonargraph.core.model.remoting.RemoteConfiguration;
import com.hello2morrow.sonargraph.core.model.system.ISoftwareSystemProvider;
import com.hello2morrow.sonargraph.foundation.activity.ActivityMode;
import com.hello2morrow.sonargraph.foundation.activity.IWorkerContext;
import com.hello2morrow.sonargraph.foundation.utilities.OperationResult;

public final class ConfigureRemoteSelectionCommand
extends InstallationBasedCommand<IInteraction> {
    public ConfigureRemoteSelectionCommand(ISoftwareSystemProvider provider, IInteraction interaction) {
        super(provider, interaction);
    }

    @Override
    public ActivityMode getActivityMode() {
        return ActivityMode.MODAL;
    }

    @Override
    public ICommandId getId() {
        return CoreCommandId.CONFIGURE_REMOTE_SELECTION;
    }

    @Override
    protected void internalRun(IWorkerContext workerContext) {
        RemoteSelectionConfigurationData data = new RemoteSelectionConfigurationData();
        if (((IInteraction)this.getInteraction()).collect(data)) {
            OperationResult result = this.getController().getInstallation().getExtension(IRemoteSelectionExtension.class).updateConfiguration(data.getModifiedConfiguration());
            ((IInteraction)this.getInteraction()).processResult(result);
        }
    }

    public static interface IInteraction
    extends ICommandInteractionWithResult {
        public boolean collect(RemoteSelectionConfigurationData var1);
    }

    public final class RemoteSelectionConfigurationData
    implements ICommandInteractionData {
        private RemoteConfiguration m_modifiedConfiguration;

        private RemoteSelectionConfigurationData() {
        }

        public RemoteConfiguration getModifiedConfiguration() {
            return this.m_modifiedConfiguration;
        }

        public void setModifiedConfiguration(RemoteConfiguration modifiedConfiguration) {
            this.m_modifiedConfiguration = modifiedConfiguration;
        }
    }
}

