/*
 * Decompiled with CFR 0.152.
 */
package com.hello2morrow.sonargraph.core.command.system.graphview;

import com.hello2morrow.sonargraph.core.command.common.ICommandId;
import com.hello2morrow.sonargraph.core.command.common.ICommandInteraction;
import com.hello2morrow.sonargraph.core.command.common.ICommandInteractionData;
import com.hello2morrow.sonargraph.core.command.system.base.CoreCommandId;
import com.hello2morrow.sonargraph.core.command.system.base.SoftwareSystemBasedCommand;
import com.hello2morrow.sonargraph.core.controllerinterface.system.IGraphViewExtension;
import com.hello2morrow.sonargraph.core.model.analysis.AnalyzerCycleGroup;
import com.hello2morrow.sonargraph.core.model.element.NamedElement;
import com.hello2morrow.sonargraph.core.model.graphview.GraphViewOnDemand;
import com.hello2morrow.sonargraph.core.model.system.ISoftwareSystemProvider;
import com.hello2morrow.sonargraph.foundation.activity.ActivityMode;
import com.hello2morrow.sonargraph.foundation.activity.IWorkerContext;
import com.hello2morrow.sonargraph.foundation.utilities.OperationResult;
import gnu.trove.set.hash.THashSet;
import java.util.Collections;
import java.util.Set;

public final class LoadGraphViewCommand
extends SoftwareSystemBasedCommand<IInteraction> {
    public LoadGraphViewCommand(ISoftwareSystemProvider provider, IInteraction interaction) {
        super(provider, interaction);
    }

    @Override
    public ICommandId getId() {
        return CoreCommandId.LOAD_GRAPH_VIEW;
    }

    @Override
    public ActivityMode getActivityMode() {
        return ActivityMode.MODAL_CANCELABLE;
    }

    @Override
    public boolean providesProgress() {
        return true;
    }

    @Override
    protected boolean isUndoable() {
        return false;
    }

    @Override
    protected void internalRun(IWorkerContext workerContext) {
        assert (workerContext != null) : "Parameter 'workerContext' of method 'internalRun' must not be null";
        Data data = new Data();
        IInteraction interaction = (IInteraction)this.getInteraction();
        if (interaction.collect(data)) {
            OperationResult result = this.getSoftwareSystem().getExtension(IGraphViewExtension.class).loadOnDemand(workerContext, data.getOnDemand(), data.getElements(), data.getBasedOnCycleGroups(), data.expandCycles());
            if (workerContext.hasBeenCanceled()) {
                interaction.processCancelled();
            } else {
                interaction.processLoadOnDemandResult(result);
            }
        }
    }

    public static final class Data
    implements ICommandInteractionData {
        private GraphViewOnDemand m_onDemand;
        private Set<NamedElement> m_elements;
        private Set<AnalyzerCycleGroup> m_basedOnCycleGroups;
        private boolean m_expandCycles;

        Data() {
        }

        public void setData(GraphViewOnDemand onDemand, Set<NamedElement> elements, Set<AnalyzerCycleGroup> basedOnCycleGroups, boolean expandCycles) {
            assert (onDemand != null) : "Parameter 'onDemand' of method 'setData' must not be null";
            assert (elements != null && !elements.isEmpty()) : "Parameter 'elements' of method 'setData' must not be empty";
            assert (basedOnCycleGroups != null && !basedOnCycleGroups.isEmpty()) : "Parameter 'basedOnCycleGroups' of method 'setData' must not be empty";
            this.m_onDemand = onDemand;
            this.m_elements = new THashSet(elements);
            this.m_basedOnCycleGroups = new THashSet(basedOnCycleGroups);
            this.m_expandCycles = expandCycles;
        }

        GraphViewOnDemand getOnDemand() {
            return this.m_onDemand;
        }

        Set<NamedElement> getElements() {
            assert (this.m_elements != null && !this.m_elements.isEmpty()) : "'m_elements' of method 'getElements' must not be empty";
            return Collections.unmodifiableSet(this.m_elements);
        }

        Set<AnalyzerCycleGroup> getBasedOnCycleGroups() {
            assert (this.m_basedOnCycleGroups != null && !this.m_basedOnCycleGroups.isEmpty()) : "'m_basedOnCycleGroups' of method 'getBasedOnCycleGroups' must not be empty";
            return Collections.unmodifiableSet(this.m_basedOnCycleGroups);
        }

        boolean expandCycles() {
            return this.m_expandCycles;
        }
    }

    public static interface IInteraction
    extends ICommandInteraction {
        public boolean collect(Data var1);

        public void processLoadOnDemandResult(OperationResult var1);

        public void processCancelled();
    }
}

