/*
 * Decompiled with CFR 0.152.
 */
package com.hello2morrow.sonargraph.core.command.system.export;

import com.hello2morrow.sonargraph.core.command.common.ICommandId;
import com.hello2morrow.sonargraph.core.command.common.ICommandInteraction;
import com.hello2morrow.sonargraph.core.command.common.ICommandInteractionData;
import com.hello2morrow.sonargraph.core.command.system.base.CoreCommandId;
import com.hello2morrow.sonargraph.core.command.system.base.SoftwareSystemBasedCommand;
import com.hello2morrow.sonargraph.core.controllerinterface.system.export.IExportExtension;
import com.hello2morrow.sonargraph.core.model.system.ISoftwareSystemProvider;
import com.hello2morrow.sonargraph.foundation.activity.ActivityMode;
import com.hello2morrow.sonargraph.foundation.activity.IWorkerContext;
import com.hello2morrow.sonargraph.foundation.export.ExportData;
import de.schlichtherle.truezip.file.TFile;
import java.util.List;

public final class ExcelExportCommand
extends SoftwareSystemBasedCommand<IExcelExportInteraction> {
    public ExcelExportCommand(ISoftwareSystemProvider provider, IExcelExportInteraction interaction) {
        super(provider, interaction);
    }

    @Override
    public ICommandId getId() {
        return CoreCommandId.EXCEL_EXPORT;
    }

    @Override
    protected void internalRun(IWorkerContext workerContext) {
        ExcelExportInteractionData data = new ExcelExportInteractionData();
        ((IExcelExportInteraction)this.getInteraction()).collect(data, workerContext);
        IExportExtension exportExtension = this.getController().getInstallation().getExtension(IExportExtension.class);
        exportExtension.export(data.getExcelFile(), data.getExcelExportData());
    }

    @Override
    public ActivityMode getActivityMode() {
        return ActivityMode.MODAL;
    }

    @Override
    public boolean providesProgress() {
        return true;
    }

    @Override
    public boolean isUndoable() {
        return false;
    }

    public static final class ExcelExportInteractionData
    implements ICommandInteractionData {
        private List<ExportData> m_excelExportData;
        private TFile m_excelFile;

        public List<ExportData> getExcelExportData() {
            return this.m_excelExportData;
        }

        public void setExcelExportData(List<ExportData> excelExportData) {
            assert (excelExportData != null) : "Parameter 'excelExportData' of method 'setExcelExportData' must not be null";
            this.m_excelExportData = excelExportData;
        }

        public TFile getExcelFile() {
            return this.m_excelFile;
        }

        public void setExcelFile(TFile excelFile) {
            assert (excelFile != null) : "Parameter 'excelFile' of method 'setExcelFile' must not be null";
            this.m_excelFile = excelFile;
        }
    }

    public static interface IExcelExportInteraction
    extends ICommandInteraction {
        public boolean collect(ExcelExportInteractionData var1, IWorkerContext var2);
    }
}

