/*
 * Decompiled with CFR 0.152.
 */
package com.hello2morrow.sonargraph.core.command.system.architecturalview;

import com.hello2morrow.sonargraph.core.command.common.ICommandId;
import com.hello2morrow.sonargraph.core.command.system.architecturalview.ArchitecturalViewCommand;
import com.hello2morrow.sonargraph.core.command.system.architecturalview.ArchitecturalViewRepresentationData;
import com.hello2morrow.sonargraph.core.command.system.architecturalview.IArchitecturalViewCommandInteraction;
import com.hello2morrow.sonargraph.core.command.system.base.CoreCommandId;
import com.hello2morrow.sonargraph.core.model.explorationview.ArchitecturalViewNode;
import com.hello2morrow.sonargraph.core.model.explorationview.IArchitecturalViewProvider;
import com.hello2morrow.sonargraph.core.model.programming.SearchCriteria;
import com.hello2morrow.sonargraph.core.model.system.ISoftwareSystemProvider;
import com.hello2morrow.sonargraph.foundation.activity.ActivityMode;
import com.hello2morrow.sonargraph.foundation.activity.IWorkerContext;
import java.util.ArrayList;
import java.util.Collections;
import java.util.EnumSet;
import java.util.List;
import java.util.function.Predicate;

public final class SearchCommand
extends ArchitecturalViewCommand<ISearchInteraction> {
    private List<ArchitecturalViewNode> m_matching;

    public SearchCommand(ISoftwareSystemProvider provider, ISearchInteraction interaction) {
        super(provider, interaction);
    }

    @Override
    public final ICommandId getId() {
        return CoreCommandId.SEARCH_IN_EXPLORATION_VIEW;
    }

    @Override
    public boolean isUndoable() {
        return false;
    }

    @Override
    public ActivityMode getActivityMode() {
        return ActivityMode.NONE;
    }

    @Override
    protected void internalRun(IWorkerContext workerContext) {
        assert (workerContext != null) : "Parameter 'workerContext' of method 'internalRun' must not be null";
        SearchData data = new SearchData();
        if (((ISearchInteraction)this.getInteraction()).collect(data)) {
            this.m_matching = this.getSoftwareSystem().getExtension(IArchitecturalViewProvider.class).search(workerContext, data.getPattern(), data.getSearchCritera(), data.getInclude(), data.getNodes(), data.getRepresentation());
        }
    }

    public List<ArchitecturalViewNode> getMatching() {
        return this.m_matching == null ? Collections.emptyList() : this.m_matching;
    }

    @Override
    public boolean equals(Object obj) {
        return this == obj;
    }

    public static interface ISearchInteraction
    extends IArchitecturalViewCommandInteraction {
        public boolean collect(SearchData var1);
    }

    public static final class SearchData
    extends ArchitecturalViewRepresentationData {
        private final EnumSet<SearchCriteria> m_searchCriteria = EnumSet.noneOf(SearchCriteria.class);
        private List<ArchitecturalViewNode> m_nodes = Collections.emptyList();
        private Predicate<ArchitecturalViewNode> m_include;
        private String m_pattern;

        SearchData() {
        }

        public void setInclude(Predicate<ArchitecturalViewNode> include) {
            this.m_include = include;
        }

        Predicate<ArchitecturalViewNode> getInclude() {
            return this.m_include;
        }

        public void setPattern(String pattern) {
            assert (pattern != null && pattern.length() > 0) : "Parameter 'pattern' of method 'setPattern' must not be empty";
            this.m_pattern = pattern;
        }

        String getPattern() {
            assert (this.m_pattern != null && this.m_pattern.length() > 0) : "'m_pattern' of method 'getPattern' must not be empty";
            return this.m_pattern;
        }

        public void setSearchCriteria(EnumSet<SearchCriteria> searchCriteria) {
            assert (searchCriteria != null) : "Parameter 'searchCriteria' of method 'setSearchCriteria' must not be null";
            this.m_searchCriteria.addAll(searchCriteria);
        }

        EnumSet<SearchCriteria> getSearchCritera() {
            return EnumSet.copyOf(this.m_searchCriteria);
        }

        public void setSearchInNodes(List<ArchitecturalViewNode> nodes) {
            assert (nodes != null) : "Parameter 'nodes' of method 'setSearchInNodes' must not be null";
            this.m_nodes = new ArrayList<ArchitecturalViewNode>(nodes);
        }

        List<ArchitecturalViewNode> getNodes() {
            return Collections.unmodifiableList(this.m_nodes);
        }
    }
}

