/*
 * Decompiled with CFR 0.152.
 */
package com.hello2morrow.sonargraph.core.command.system.architecturalview;

import com.hello2morrow.sonargraph.core.command.common.ICommandId;
import com.hello2morrow.sonargraph.core.command.system.architecturalview.ArchitecturalViewCommand;
import com.hello2morrow.sonargraph.core.command.system.architecturalview.IArchitecturalViewCommandInteraction;
import com.hello2morrow.sonargraph.core.command.system.architecturalview.IArchitecturalViewCommandInteractionData;
import com.hello2morrow.sonargraph.core.command.system.base.CoreCommandId;
import com.hello2morrow.sonargraph.core.controllerinterface.system.IArchitecturalViewExtension;
import com.hello2morrow.sonargraph.core.model.common.PresentationMode;
import com.hello2morrow.sonargraph.core.model.explorationview.ArchitecturalViewFile;
import com.hello2morrow.sonargraph.core.model.system.ISoftwareSystemProvider;
import com.hello2morrow.sonargraph.foundation.activity.ActivityMode;
import com.hello2morrow.sonargraph.foundation.activity.IWorkerContext;
import com.hello2morrow.sonargraph.foundation.utilities.OperationResult;

public final class LoadArchitecturalViewCommand
extends ArchitecturalViewCommand<ILoadArchitecturalViewInteraction> {
    public LoadArchitecturalViewCommand(ISoftwareSystemProvider provider, ILoadArchitecturalViewInteraction interaction) {
        super(provider, interaction);
    }

    @Override
    public ICommandId getId() {
        return CoreCommandId.LOAD_ARCHITECTURAL_VIEW;
    }

    @Override
    public boolean isUndoable() {
        return false;
    }

    @Override
    public ActivityMode getActivityMode() {
        return ActivityMode.MODAL_CANCELABLE;
    }

    @Override
    public boolean providesProgress() {
        return true;
    }

    @Override
    protected void internalRun(IWorkerContext workerContext) {
        assert (workerContext != null) : "Parameter 'workerContext' of method 'internalRun' must not be null";
        assert (this.getController().hasSoftwareSystem()) : "No system available";
        LoadArchitecturalViewData data = new LoadArchitecturalViewData();
        if (!((ILoadArchitecturalViewInteraction)this.getInteraction()).collect(data)) {
            return;
        }
        OperationResult result = this.getController().getSoftwareSystem().getExtension(IArchitecturalViewExtension.class).load(workerContext, data.getFile(), data.getPresentationMode());
        if (workerContext.hasBeenCanceled()) {
            ((ILoadArchitecturalViewInteraction)this.getInteraction()).processCancelled();
        } else {
            ((ILoadArchitecturalViewInteraction)this.getInteraction()).processLoadResult(result);
        }
    }

    public static interface ILoadArchitecturalViewInteraction
    extends IArchitecturalViewCommandInteraction {
        public boolean collect(LoadArchitecturalViewData var1);

        public void processLoadResult(OperationResult var1);

        public void processCancelled();
    }

    public static final class LoadArchitecturalViewData
    implements IArchitecturalViewCommandInteractionData {
        private ArchitecturalViewFile m_file;
        private PresentationMode m_presentationMode = PresentationMode.MIXED;

        LoadArchitecturalViewData() {
        }

        public final void setFile(ArchitecturalViewFile file) {
            this.m_file = file;
        }

        final ArchitecturalViewFile getFile() {
            assert (this.m_file != null) : "'m_file' of method 'getFile' must not be null";
            return this.m_file;
        }

        public void setPresentationMode(PresentationMode presentationMode) {
            assert (presentationMode != null) : "Parameter 'presentationMode' of method 'setPresentationMode' must not be null";
            this.m_presentationMode = presentationMode;
        }

        PresentationMode getPresentationMode() {
            return this.m_presentationMode;
        }
    }
}

