/*
 * Decompiled with CFR 0.152.
 */
package com.hello2morrow.sonargraph.core.command.system;

import com.hello2morrow.sonargraph.core.command.common.ICommandId;
import com.hello2morrow.sonargraph.core.command.common.ICommandInteraction;
import com.hello2morrow.sonargraph.core.command.common.ICommandInteractionData;
import com.hello2morrow.sonargraph.core.command.system.base.CoreCommandId;
import com.hello2morrow.sonargraph.core.command.system.base.SoftwareSystemBasedCommand;
import com.hello2morrow.sonargraph.core.controllerinterface.system.IWorkspaceExtension;
import com.hello2morrow.sonargraph.core.model.system.ISoftwareSystemProvider;
import com.hello2morrow.sonargraph.core.model.workspace.Module;
import com.hello2morrow.sonargraph.foundation.activity.IWorkerContext;
import com.hello2morrow.sonargraph.foundation.utilities.OperationResult;
import java.util.ArrayList;
import java.util.List;

public final class MoveModulesCommand
extends SoftwareSystemBasedCommand<IMoveModulesInteraction> {
    public MoveModulesCommand(ISoftwareSystemProvider provider, IMoveModulesInteraction interaction) {
        super(provider, interaction);
    }

    @Override
    public final ICommandId getId() {
        return CoreCommandId.MOVE_MODULES;
    }

    @Override
    protected void internalRun(IWorkerContext workerContext) {
        assert (workerContext != null) : "Parameter 'workerContext' of method 'internalRun' must not be null";
        MoveModulesData data = new MoveModulesData();
        if (((IMoveModulesInteraction)this.getInteraction()).collectMoveModulesData(data)) {
            OperationResult result = this.getSoftwareSystem().getExtension(IWorkspaceExtension.class).moveModulesTo(workerContext, data.getModules(), data.getPos());
            ((IMoveModulesInteraction)this.getInteraction()).processMoveModulesResult(result);
        }
    }

    public static interface IMoveModulesInteraction
    extends ICommandInteraction {
        public boolean collectMoveModulesData(MoveModulesData var1);

        public void processMoveModulesResult(OperationResult var1);
    }

    public static final class MoveModulesData
    implements ICommandInteractionData {
        private List<Module> m_modules;
        private int m_pos = -1;

        MoveModulesData() {
        }

        public final void set(List<Module> modules, int pos) {
            assert (modules != null && !modules.isEmpty()) : "Parameter 'modules' of method 'set' must not be empty";
            assert (pos >= 0) : "'pos' must not be negative";
            this.m_modules = new ArrayList<Module>(modules);
            this.m_pos = pos;
        }

        List<Module> getModules() {
            assert (this.m_modules != null && !this.m_modules.isEmpty()) : "'m_modules' of method 'getModules' must not be empty";
            return this.m_modules;
        }

        int getPos() {
            assert (this.m_pos >= 0) : "'m_pos' must not be negative";
            return this.m_pos;
        }
    }
}

