/*
 * Decompiled with CFR 0.152.
 */
package com.hello2morrow.sonargraph.core.command.system;

import com.hello2morrow.sonargraph.core.command.common.CommandRegistry;
import com.hello2morrow.sonargraph.core.command.common.ICommandProvider;
import com.hello2morrow.sonargraph.core.command.common.MockUserInterfaceAdapterDevelopment;
import com.hello2morrow.sonargraph.core.command.system.AbstractCreateSoftwareSystemCommand;
import com.hello2morrow.sonargraph.core.command.system.AbstractOpenCommand;
import com.hello2morrow.sonargraph.core.command.system.ClearSoftwareSystemCommand;
import com.hello2morrow.sonargraph.core.command.system.CloseSoftwareSystemCommand;
import com.hello2morrow.sonargraph.core.command.system.CreateSoftwareSystemCommand;
import com.hello2morrow.sonargraph.core.command.system.LoadSnapshotCommand;
import com.hello2morrow.sonargraph.core.command.system.OpenSoftwareSystemCommand;
import com.hello2morrow.sonargraph.core.command.system.RefreshCommand;
import com.hello2morrow.sonargraph.core.command.system.RefreshSoftwareSystemCommand;
import com.hello2morrow.sonargraph.core.command.system.SaveSoftwareSystemCommand;
import com.hello2morrow.sonargraph.core.controller.system.LanguageProvider;
import com.hello2morrow.sonargraph.core.controller.system.SoftwareSystemController;
import com.hello2morrow.sonargraph.core.controllerinterface.system.IUndoRedoExtension;
import com.hello2morrow.sonargraph.core.foundation.common.base.CoreResourceProviderAdapter;
import com.hello2morrow.sonargraph.core.foundation.common.base.Language;
import com.hello2morrow.sonargraph.core.model.architecture.IArchitectureAssignmentElement;
import com.hello2morrow.sonargraph.core.model.common.AnalyzerExecutionLevel;
import com.hello2morrow.sonargraph.core.model.common.SonargraphFeature;
import com.hello2morrow.sonargraph.core.model.common.SonargraphProduct;
import com.hello2morrow.sonargraph.core.model.element.NamedElement;
import com.hello2morrow.sonargraph.core.model.event.ExceptionEvent;
import com.hello2morrow.sonargraph.core.model.path.IModifiableFile;
import com.hello2morrow.sonargraph.core.model.path.IModificationOnSave;
import com.hello2morrow.sonargraph.core.model.programming.LogicalProgrammingElement;
import com.hello2morrow.sonargraph.core.model.script.ScriptOutputStreamProvider;
import com.hello2morrow.sonargraph.core.model.system.ISoftwareSystemProvider;
import com.hello2morrow.sonargraph.core.model.system.ModuleDelta;
import com.hello2morrow.sonargraph.core.model.system.PrepareRefreshResult;
import com.hello2morrow.sonargraph.core.model.system.SoftwareSystem;
import com.hello2morrow.sonargraph.core.model.system.SoftwareSystemState;
import com.hello2morrow.sonargraph.core.model.system.dynamic.DynamicSystemInfo;
import com.hello2morrow.sonargraph.foundation.event.EventHandler;
import com.hello2morrow.sonargraph.foundation.event.EventManager;
import com.hello2morrow.sonargraph.foundation.file.FileUtility;
import com.hello2morrow.sonargraph.foundation.file.TrueZipFacade;
import com.hello2morrow.sonargraph.foundation.utilities.Joiner;
import com.hello2morrow.sonargraph.foundation.utilities.OperationResult;
import com.hello2morrow.sonargraph.foundation.utilities.StringUtility;
import de.schlichtherle.truezip.file.TFile;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.EnumSet;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.junit.After;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.Before;
import org.junit.BeforeClass;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractCoreCommandTest {
    private static final Logger LOGGER = LoggerFactory.getLogger(AbstractCoreCommandTest.class);
    private static final String TEMPORARY_USER_HOME_PATH = "./src/test/_temporary_user_home";
    private static final String PROJECT_BACKUP_DIR = "./src/test/_project_backup";
    private final List<StringBuilder> m_backgroundTaskExceptions = new ArrayList<StringBuilder>();
    private final String m_projectPath;
    private String m_workspaceProfileName;
    private DynamicSystemInfo m_systemInfo;
    private MockUserInterfaceAdapterDevelopment m_mock;
    private SoftwareSystemController m_controller;
    private final Set<SonargraphFeature> m_disabledFeatures;

    public static Set<SonargraphFeature> getDisabledFeaturesForExplorer() {
        ArrayList<SonargraphFeature> features = new ArrayList<SonargraphFeature>(Arrays.asList(SonargraphFeature.values()));
        features.remove((Object)SonargraphFeature.REPORTING);
        features.remove((Object)SonargraphFeature.PLATFORM);
        features.remove((Object)SonargraphFeature.SYSTEMS);
        return new HashSet<SonargraphFeature>(features);
    }

    public AbstractCoreCommandTest() {
        this(null, Collections.emptySet());
    }

    public AbstractCoreCommandTest(String projectPath, Set<SonargraphFeature> disabledFeatures) {
        String[] files;
        TFile settingsDir;
        this.m_projectPath = projectPath;
        this.m_disabledFeatures = disabledFeatures;
        if (this.m_projectPath != null && (settingsDir = new TFile(projectPath, "Settings")).exists() && (files = settingsDir.list()) != null && files.length == 0) {
            try {
                settingsDir.rm();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }

    public AbstractCoreCommandTest(String projectPath, Set<SonargraphFeature> disabledFeatures, String workspaceProfileName) {
        this(projectPath, disabledFeatures);
        this.m_workspaceProfileName = workspaceProfileName;
    }

    public AbstractCoreCommandTest(String projectPath, Set<SonargraphFeature> disabledFeatures, DynamicSystemInfo systemInfo) {
        this(projectPath, disabledFeatures);
        this.m_systemInfo = systemInfo;
    }

    public static final void sleep(long ms) {
        try {
            Thread.sleep(ms);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }

    protected final String getProjectPath() {
        return this.m_projectPath;
    }

    protected final void setSystemInfo(DynamicSystemInfo systemInfo) {
        this.m_systemInfo = systemInfo;
    }

    protected abstract Set<Language> getLanguages();

    protected abstract List<ICommandProvider> getCommandProviders();

    protected abstract Set<LanguageProvider> getLanguageProviders();

    protected EnumSet<SoftwareSystemController.OptionalExtensionId> getDisabledOptionalExtensions() {
        return EnumSet.allOf(SoftwareSystemController.OptionalExtensionId.class);
    }

    @Before
    public final void before() throws IOException {
        TrueZipFacade.clear();
        this.m_mock = MockUserInterfaceAdapterDevelopment.createInstance(SonargraphProduct.SONARGRAPH, this.getLanguages(), this.getCommandProviders(), this.m_disabledFeatures);
        this.m_controller = new SoftwareSystemController(CommandRegistry.getInstance().getLicenseHandler(), this.getLanguageProviders(), new ScriptOutputStreamProvider(), ISoftwareSystemProvider.BackgroundTaskExecutionMode.WAIT_FOR_COMPLETION, AnalyzerExecutionLevel.FULL, this.getDisabledOptionalExtensions());
        ModuleDelta.setSortOrder(ModuleDelta.SortOrder.ASCENDING);
        if (this.m_projectPath != null) {
            AbstractCoreCommandTest.copyDirectory(new TFile(this.m_projectPath), new TFile(PROJECT_BACKUP_DIR));
        }
        EventManager.getInstance().attach((EventHandler)new EventHandler<ExceptionEvent>(ExceptionEvent.class, (Object)this){

            public void handleEvent(ExceptionEvent event) {
                if (!$assertionsDisabled && event == null) {
                    throw new AssertionError((Object)"Parameter 'event' of method 'handleEvent' must not be null");
                }
                StringBuilder builder = new StringBuilder(event.getException().toString());
                builder.append(StringUtility.LINE_SEPARATOR);
                builder.append(CommandRegistry.getInstance().getExecutionContextInfo());
                AbstractCoreCommandTest.this.m_backgroundTaskExceptions.add(builder);
            }
        });
    }

    public void assertHasLoadedSoftwareSystem() {
        assert (this.m_controller != null) : "Parameter 'm_controller' of method 'assertHasLoadedSoftwareSystem' must not be null";
        assert (this.m_controller.hasSoftwareSystem()) : "No system available";
        assert (this.m_controller.getSoftwareSystem().getState().equals((Object)SoftwareSystemState.MODEL_LOADED)) : "No model available";
    }

    @After
    public final void after() throws IOException {
        Throwable throwable;
        block8: {
            TrueZipFacade.clear();
            throwable = null;
            try {
                try {
                    this.closeSoftwareSystem();
                }
                catch (Throwable t) {
                    throwable = t;
                    this.m_mock.delete();
                    this.m_controller = null;
                    this.m_mock = null;
                    break block8;
                }
            }
            catch (Throwable throwable2) {
                this.m_mock.delete();
                this.m_controller = null;
                this.m_mock = null;
                throw throwable2;
            }
            this.m_mock.delete();
            this.m_controller = null;
            this.m_mock = null;
        }
        if (this.m_projectPath != null) {
            TFile backupDir = new TFile(PROJECT_BACKUP_DIR);
            AbstractCoreCommandTest.copyDirectory(backupDir, new TFile(this.m_projectPath));
            backupDir.rm_r();
        }
        Assert.assertNull((String)(throwable != null ? throwable.getMessage() : ""), (Object)throwable);
        EventManager.getInstance().detach(ExceptionEvent.class, (Object)this);
        if (!this.m_backgroundTaskExceptions.isEmpty()) {
            StringBuilder builder = new StringBuilder();
            for (StringBuilder next : this.m_backgroundTaskExceptions) {
                String nextExceptionToString = next.toString();
                LOGGER.error(nextExceptionToString);
                builder.append(nextExceptionToString).append("\n");
            }
            Assert.fail((String)(this.m_backgroundTaskExceptions.size() + " background task exception(s) received.\n" + builder.toString()));
        }
    }

    @BeforeClass
    public static void beforeClass() throws IOException {
        TFile userHome = AbstractCoreCommandTest.initUserHome();
        CoreResourceProviderAdapter.getInstance().setSonargraphUserHomeDir(userHome.getAbsolutePath());
    }

    @AfterClass
    public static void afterClass() throws IOException {
        AbstractCoreCommandTest.removeUserHome();
    }

    protected final MockUserInterfaceAdapterDevelopment getUserInterfaceAdapter() {
        return this.m_mock;
    }

    public final SoftwareSystemController getController() {
        return this.m_controller;
    }

    protected final SoftwareSystem openSnapshot(final TFile snapshotFile) {
        LoadSnapshotCommand cmd = new LoadSnapshotCommand(this.getController(), new AbstractOpenCommand.IOpenInteraction(){

            @Override
            public boolean closeSoftwareSystem() {
                return false;
            }

            @Override
            public boolean collectSaveData(SaveSoftwareSystemCommand.ModifiableFilesToBeSavedData data) {
                return false;
            }

            @Override
            public Map<IModifiableFile, IModificationOnSave> aboutToSave(SoftwareSystem system, List<IModifiableFile> toBeSaved) {
                return null;
            }

            @Override
            public boolean collectOpenData(AbstractOpenCommand.OpenData data) {
                data.setFlags(EnumSet.allOf(ISoftwareSystemProvider.OpenOption.class));
                data.setLocation(snapshotFile);
                return true;
            }

            @Override
            public boolean confirmSystemSaveDueToExternalFileChangesOnOpen(boolean undoHistoryWillBeCleared) {
                return false;
            }

            @Override
            public void processOpenResult(OperationResult result) {
                if (result.isFailure()) {
                    Assert.fail((String)Joiner.join((Collection)result.getMessagesAsStringList()));
                }
            }
        });
        cmd.runSynchronously();
        return this.getController().getSoftwareSystem();
    }

    protected final void openSoftwareSystem(final TFile projectDir, final EnumSet<ISoftwareSystemProvider.OpenOption> flags, final IOperationResultCallback resultCallback) {
        assert (projectDir != null) : "Parameter 'projectDir' of method 'openSoftwareSystem' must not be null";
        assert (flags != null) : "Parameter 'flags' of method 'openSoftwareSystem' must not be null";
        OpenSoftwareSystemCommand openCommand = new OpenSoftwareSystemCommand(this.getController(), new AbstractOpenCommand.IOpenInteraction(){

            @Override
            public Map<IModifiableFile, IModificationOnSave> aboutToSave(SoftwareSystem system, List<IModifiableFile> toBeSaved) {
                if (!$assertionsDisabled && system == null) {
                    throw new AssertionError((Object)"Parameter 'system' of method 'aboutToSave' must not be null");
                }
                if (!$assertionsDisabled && toBeSaved == null) {
                    throw new AssertionError((Object)"Parameter 'toBeSaved' of method 'aboutToSave' must not be null");
                }
                return Collections.emptyMap();
            }

            @Override
            public boolean processSaveResult(OperationResult result) {
                return false;
            }

            @Override
            public boolean collectSaveData(SaveSoftwareSystemCommand.ModifiableFilesToBeSavedData data) {
                return false;
            }

            @Override
            public boolean closeSoftwareSystem() {
                return false;
            }

            @Override
            public void processOpenResult(OperationResult openResult) {
                if (resultCallback == null) {
                    Assert.assertTrue((String)openResult.toString(), (boolean)openResult.isSuccess());
                } else {
                    resultCallback.handle(openResult);
                }
            }

            @Override
            public boolean collectOpenData(AbstractOpenCommand.OpenData data) {
                data.setLocation(projectDir);
                if (AbstractCoreCommandTest.this.m_systemInfo != null) {
                    data.setDynamicSystemInfo(AbstractCoreCommandTest.this.m_systemInfo);
                } else if (AbstractCoreCommandTest.this.m_workspaceProfileName != null) {
                    data.setWorkspaceProfileName(AbstractCoreCommandTest.this.m_workspaceProfileName);
                }
                data.setFlags(flags);
                return true;
            }

            @Override
            public boolean confirmSystemSaveDueToExternalFileChangesOnOpen(boolean hasUndoHistory) {
                Assert.fail((String)"Not expected to be called");
                return false;
            }

            @Override
            public void processSaveResultDueToExternalFileChangesOnOpen(OperationResult saveResult) {
                AbstractCoreCommandTest.this.getUserInterfaceAdapter().process(saveResult);
            }
        }, false);
        openCommand.runSynchronously();
    }

    protected void saveSoftwareSystem(final IModifiableFile ... filesToBeSaved) {
        assert (filesToBeSaved != null) : "Parameter 'filesToBeSaved' of method 'saveSoftwareSystem' must not be null";
        SaveSoftwareSystemCommand saveCommand = new SaveSoftwareSystemCommand((ISoftwareSystemProvider)this.getController(), new SaveSoftwareSystemCommand.ISaveInteraction(){

            @Override
            public Map<IModifiableFile, IModificationOnSave> aboutToSave(SoftwareSystem system, List<IModifiableFile> toBeSaved) {
                if (!$assertionsDisabled && system == null) {
                    throw new AssertionError((Object)"Parameter 'system' of method 'aboutToSave' must not be null");
                }
                if (!$assertionsDisabled && toBeSaved == null) {
                    throw new AssertionError((Object)"Parameter 'toBeSaved' of method 'aboutToSave' must not be null");
                }
                return Collections.emptyMap();
            }

            @Override
            public boolean processSaveResult(OperationResult result) {
                return true;
            }

            @Override
            public boolean collectSaveData(SaveSoftwareSystemCommand.ModifiableFilesToBeSavedData data) {
                ArrayList<IModifiableFile> files = new ArrayList<IModifiableFile>(Arrays.asList(filesToBeSaved));
                data.setToBeSaved(files);
                return true;
            }
        });
        saveCommand.runSynchronously();
        IModifiableFile[] iModifiableFileArray = filesToBeSaved;
        int n = filesToBeSaved.length;
        int n2 = 0;
        while (n2 < n) {
            IModifiableFile next = iModifiableFileArray[n2];
            Assert.assertFalse((boolean)next.needsSave());
            ++n2;
        }
    }

    protected SoftwareSystem openAndClearAndRefreshSystem(TFile file) {
        return this.openAndClearAndRefreshSystem(file, EnumSet.noneOf(ISoftwareSystemProvider.OpenOption.class));
    }

    protected SoftwareSystem openAndClearAndRefreshSystem(TFile file, EnumSet<ISoftwareSystemProvider.OpenOption> flags) {
        return this.openAndClearAndRefreshSystem(file, flags, EnumSet.noneOf(SoftwareSystemController.OptionalExtensionId.class));
    }

    protected SoftwareSystem openAndClearAndRefreshSystem(TFile file, EnumSet<ISoftwareSystemProvider.OpenOption> flags, EnumSet<SoftwareSystemController.OptionalExtensionId> disabledExtensions) {
        this.openSoftwareSystem(file, flags, null);
        Assert.assertTrue((String)"Missing system", (boolean)this.getController().hasSoftwareSystem());
        this.clear();
        this.refresh();
        IUndoRedoExtension undoRedoExtension = this.getController().getSoftwareSystem().getExtension(IUndoRedoExtension.class);
        Assert.assertEquals((long)0L, (long)undoRedoExtension.getNumberOfRestorableTransactions());
        return this.getController().getSoftwareSystem();
    }

    protected void refreshWithInteraction(RefreshCommand.IRefreshInteraction interaction) {
        RefreshSoftwareSystemCommand refreshCommand = new RefreshSoftwareSystemCommand((ISoftwareSystemProvider)this.getController(), interaction);
        refreshCommand.runSynchronously();
    }

    protected void refresh() {
        this.refresh(null);
    }

    protected void refresh(IOperationResultCallback callback) {
        this.refresh(callback, EnumSet.of(ISoftwareSystemProvider.RefreshOption.REFRESH_PARSER_MODEL));
    }

    protected final void refresh(final IOperationResultCallback callback, final EnumSet<ISoftwareSystemProvider.RefreshOption> refreshOptions) {
        RefreshSoftwareSystemCommand refreshCommand = new RefreshSoftwareSystemCommand((ISoftwareSystemProvider)this.getController(), new RefreshCommand.IRefreshInteraction(){

            @Override
            public Map<IModifiableFile, IModificationOnSave> aboutToSave(SoftwareSystem system, List<IModifiableFile> toBeSaved) {
                if (!$assertionsDisabled && system == null) {
                    throw new AssertionError((Object)"Parameter 'system' of method 'aboutToSave' must not be null");
                }
                if (!$assertionsDisabled && toBeSaved == null) {
                    throw new AssertionError((Object)"Parameter 'toBeSaved' of method 'aboutToSave' must not be null");
                }
                return Collections.emptyMap();
            }

            @Override
            public void processRefreshResult(OperationResult refreshResult) {
                if (callback != null) {
                    callback.handle(refreshResult);
                } else {
                    Assert.assertTrue((String)refreshResult.toString(), (boolean)refreshResult.isSuccess());
                }
            }

            @Override
            public void collectRefreshData(RefreshCommand.RefreshData data) {
                if (!$assertionsDisabled && data == null) {
                    throw new AssertionError((Object)"Parameter 'data' of method 'collect' must not be null");
                }
                data.addOptions(ISoftwareSystemProvider.RefreshOption.REFRESH_PARSER_MODEL);
                if (refreshOptions != null) {
                    data.addOptions(refreshOptions.toArray(new ISoftwareSystemProvider.RefreshOption[0]));
                }
            }

            @Override
            public boolean confirmPreRefreshActions(PrepareRefreshResult result) {
                return true;
            }

            @Override
            public boolean answerPreRefreshQuestion(PrepareRefreshResult.Question question) {
                if (!$assertionsDisabled && question == null) {
                    throw new AssertionError((Object)"Parameter 'question' of method 'answerPreRefreshQuestion' must not be null");
                }
                return false;
            }

            @Override
            public void processPrepareRefreshResult(PrepareRefreshResult result) {
                Assert.assertTrue((String)result.toString(), (boolean)result.isSuccess());
            }

            @Override
            public RefreshCommand.IRefreshInteraction.PreRefreshSoftwareSystemFileModificationResponse confirmPreRefreshSoftwareSystemFileModification(PrepareRefreshResult.SoftwareSystemFileModification modification) {
                return RefreshCommand.IRefreshInteraction.PreRefreshSoftwareSystemFileModificationResponse.CONTINUE;
            }

            @Override
            public boolean collectOpenData(AbstractOpenCommand.OpenData data) {
                Assert.fail((String)"Not expected to be called");
                return true;
            }

            @Override
            public void processOpenResult(OperationResult result) {
                Assert.fail((String)"Not expected to be called");
            }

            @Override
            public boolean closeSoftwareSystem() {
                Assert.fail((String)"Not expected to be called");
                return true;
            }

            @Override
            public boolean collectSaveData(SaveSoftwareSystemCommand.ModifiableFilesToBeSavedData data) {
                Assert.fail((String)"Not expected to be called");
                return true;
            }

            @Override
            public boolean processSaveResult(OperationResult result) {
                Assert.fail((String)"Not expected to be called");
                return true;
            }

            @Override
            public boolean confirmSystemSaveDueToExternalFileChangesOnOpen(boolean hasUndoHistory) {
                Assert.fail((String)"Not expected to be called");
                return false;
            }

            @Override
            public void processSaveResultDueToExternalFileChangesOnOpen(OperationResult saveResult) {
                AbstractCoreCommandTest.this.getUserInterfaceAdapter().process(saveResult);
            }
        });
        refreshCommand.runSynchronously();
    }

    protected void createSoftwareSystem(final TFile baseDir, final String name, final String description) {
        CreateSoftwareSystemCommand createSoftwareSystem = new CreateSoftwareSystemCommand(this.getController(), new AbstractCreateSoftwareSystemCommand.IInteraction(){

            @Override
            public Map<IModifiableFile, IModificationOnSave> aboutToSave(SoftwareSystem system, List<IModifiableFile> toBeSaved) {
                if (!$assertionsDisabled && system == null) {
                    throw new AssertionError((Object)"Parameter 'system' of method 'aboutToSave' must not be null");
                }
                if (!$assertionsDisabled && toBeSaved == null) {
                    throw new AssertionError((Object)"Parameter 'toBeSaved' of method 'aboutToSave' must not be null");
                }
                return Collections.emptyMap();
            }

            @Override
            public boolean processSaveResult(OperationResult result) {
                return true;
            }

            @Override
            public boolean collectSaveData(SaveSoftwareSystemCommand.ModifiableFilesToBeSavedData data) {
                return true;
            }

            @Override
            public boolean closeSoftwareSystem() {
                return true;
            }

            @Override
            public void processCreateSoftwareSystemResult(OperationResult result) {
                Assert.assertTrue((String)result.toString(), (boolean)result.isSuccess());
            }

            @Override
            public boolean confirmOverwrite(String overwriteInfo) {
                return true;
            }

            @Override
            public boolean collect(AbstractCreateSoftwareSystemCommand.SoftwareSystemData data) {
                data.setBaseDirectory(baseDir);
                data.setName(name);
                data.setDescription(description);
                return true;
            }
        });
        createSoftwareSystem.runSynchronously();
    }

    protected void clear() {
        ClearSoftwareSystemCommand clear = new ClearSoftwareSystemCommand((ISoftwareSystemProvider)this.getController(), new ClearSoftwareSystemCommand.IClearSoftwareSystemInteraction(){

            @Override
            public void processClearSoftwareSystemResult(OperationResult result) {
                if (!$assertionsDisabled && result == null) {
                    throw new AssertionError((Object)"Parameter 'result' of method 'processClearSoftwareSystemResult' must not be null");
                }
                MockUserInterfaceAdapterDevelopment.getInstance().process(result);
            }
        });
        if (clear.isEnabled().isSuccess()) {
            clear.runSynchronously();
        }
    }

    protected void closeSoftwareSystem() {
        if (!this.m_controller.hasSoftwareSystem()) {
            return;
        }
        CloseSoftwareSystemCommand command = new CloseSoftwareSystemCommand((ISoftwareSystemProvider)this.m_controller, new CloseSoftwareSystemCommand.ICloseInteraction(){

            @Override
            public Map<IModifiableFile, IModificationOnSave> aboutToSave(SoftwareSystem system, List<IModifiableFile> toBeSaved) {
                if (!$assertionsDisabled && system == null) {
                    throw new AssertionError((Object)"Parameter 'system' of method 'aboutToSave' must not be null");
                }
                if (!$assertionsDisabled && toBeSaved == null) {
                    throw new AssertionError((Object)"Parameter 'toBeSaved' of method 'aboutToSave' must not be null");
                }
                return Collections.emptyMap();
            }

            @Override
            public boolean processSaveResult(OperationResult result) {
                return true;
            }

            @Override
            public boolean collectSaveData(SaveSoftwareSystemCommand.ModifiableFilesToBeSavedData data) {
                data.setToBeSaved(new ArrayList<IModifiableFile>());
                return true;
            }

            @Override
            public boolean closeSoftwareSystem() {
                return true;
            }
        });
        command.runSynchronously();
        Assert.assertFalse((String)"No software system expected", (boolean)this.getController().hasSoftwareSystem());
        TrueZipFacade.clear();
    }

    public static TFile initUserHome() throws IOException {
        TFile userHomeDir = AbstractCoreCommandTest.removeUserHome();
        userHomeDir = AbstractCoreCommandTest.createDirectory(userHomeDir);
        Assert.assertNotNull((String)"Failed to create temporary user home", (Object)userHomeDir);
        return userHomeDir;
    }

    private static TFile createDirectory(TFile userHomeDir) {
        int count = 0;
        while (count < 10) {
            try {
                userHomeDir.mkdir(true);
                return userHomeDir.getNormalizedAbsoluteFile();
            }
            catch (IOException iOException) {
                try {
                    Thread.sleep(50L);
                }
                catch (InterruptedException ex) {
                    System.err.println("Interrupted!");
                }
                ++count;
            }
        }
        return null;
    }

    public static TFile removeUserHome() throws IOException {
        TrueZipFacade.clear();
        TFile userHomeDir = new TFile(TEMPORARY_USER_HOME_PATH).getNormalizedAbsoluteFile();
        TrueZipFacade.clear((TFile)userHomeDir);
        FileUtility.removeRecursivelyDontFollowSymlinks((TFile)userHomeDir);
        return userHomeDir;
    }

    public static void copyDirectory(TFile src, TFile dest) throws IOException {
        TFile destination = dest;
        if (dest.exists()) {
            dest.rm_r();
        }
        if (!dest.isDirectory()) {
            destination = AbstractCoreCommandTest.createDirectory(dest);
        }
        src.cp_r((File)destination);
    }

    protected final <T extends NamedElement> T findNamedElementByName(String name, boolean shortName, Class<T> clazz, Class<?> ... stopClasses) {
        return this.findNamedElementByName(this.getController().getSoftwareSystem(), name, shortName, clazz, stopClasses);
    }

    protected final <T extends NamedElement> T findNamedElementByFQName(NamedElement parent, String name, Class<T> clazz, Class<?> ... stopClasses) {
        assert (parent != null) : "Parameter 'parent' of method 'findNamedElementByName' must not be null";
        assert (clazz != null) : "Parameter 'clazz' of method 'findNamedElementByName' must not be null";
        assert (name != null) : "Parameter 'name' of method 'findNamedElementByName' must not be null";
        NamedElement found = null;
        List<NamedElement> elementsForLookUp = new ArrayList<NamedElement>();
        if (clazz == LogicalProgrammingElement.class || IArchitectureAssignmentElement.class.isAssignableFrom(clazz)) {
            this.getLogicalProgrammingElementChildrenRecursively(parent, elementsForLookUp, clazz);
        } else {
            elementsForLookUp = parent.getChildrenRecursively(clazz, stopClasses);
        }
        for (NamedElement element : elementsForLookUp) {
            if (!element.getFullyQualifiedName().equals(name)) continue;
            found = element;
            break;
        }
        return (T)found;
    }

    protected final <T extends NamedElement> T findNamedElementByName(NamedElement parent, String name, boolean shortName, Class<T> clazz, Class<?> ... stopClasses) {
        assert (parent != null) : "Parameter 'parent' of method 'findNamedElementByName' must not be null";
        assert (clazz != null) : "Parameter 'clazz' of method 'findNamedElementByName' must not be null";
        assert (name != null) : "Parameter 'name' of method 'findNamedElementByName' must not be null";
        NamedElement found = null;
        List<NamedElement> elementsForLookUp = new ArrayList<NamedElement>();
        if (clazz == LogicalProgrammingElement.class || IArchitectureAssignmentElement.class.isAssignableFrom(clazz)) {
            this.getLogicalProgrammingElementChildrenRecursively(parent, elementsForLookUp, clazz);
        } else {
            elementsForLookUp = parent.getChildrenRecursively(clazz, stopClasses);
        }
        for (NamedElement element : elementsForLookUp) {
            if (!element.getPresentationName(shortName).equals(name)) continue;
            found = element;
            break;
        }
        return (T)found;
    }

    private void getLogicalProgrammingElementChildrenRecursively(NamedElement namedElement, Collection<NamedElement> collector, Class<?> clazz) {
        assert (namedElement != null) : "Parameter 'namedElement' of method 'getLogicalProgrammingElementChildrenRecursively' must not be null";
        assert (collector != null) : "Parameter 'collector' of method 'enclosing_method' must not be null";
        assert (clazz != null) : "Parameter 'clazz' of method 'getLogicalProgrammingElementChildrenRecursively' must not be null";
        for (NamedElement namedElement2 : namedElement.getAllChildren()) {
            if (clazz.isAssignableFrom(namedElement2.getClass())) {
                collector.add(namedElement2);
            }
            this.getLogicalProgrammingElementChildrenRecursively(namedElement2, collector, clazz);
        }
    }

    public static interface IOperationResultCallback {
        public void handle(OperationResult var1);
    }
}

