/*
 * Decompiled with CFR 0.152.
 */
package com.hello2morrow.sonargraph.languageprovider.java.controller.system;

import com.hello2morrow.sonargraph.languageprovider.java.controller.system.parser.base.JavaTypeInfo;
import com.hello2morrow.sonargraph.languageprovider.java.model.system.JavaModule;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

final class AmbiguousTargetTypeInfo {
    private final String m_fqTargetTypeName;
    private final List<JavaTypeInfo> m_availableTargets;
    private final JavaModule m_resolvedWith;
    private final int m_line;

    AmbiguousTargetTypeInfo(String fqTargetTypeName, List<JavaTypeInfo> availableTargets, int line, JavaModule resolvedWith) {
        assert (fqTargetTypeName != null && fqTargetTypeName.length() > 0) : "Parameter 'fqTargetTypeName' of method 'AmbiguousTargetTypeInfo' must not be empty";
        assert (availableTargets != null && !availableTargets.isEmpty()) : "Parameter 'availableTargets' of method 'AmbiguousTargetTypeInfo' must not be empty";
        this.m_fqTargetTypeName = fqTargetTypeName.intern();
        this.m_availableTargets = availableTargets;
        this.m_line = line;
        this.m_resolvedWith = resolvedWith;
    }

    int getLineNumber() {
        return this.m_line;
    }

    boolean hasBeenResolved() {
        return this.m_resolvedWith != null;
    }

    String createDescription() {
        ArrayList<String> modules = new ArrayList<String>();
        for (JavaTypeInfo nextPossibleTarget : this.m_availableTargets) {
            JavaModule nextModule = nextPossibleTarget.getModule();
            assert (nextModule != null) : "'nextModule' of method 'createDescription' must not be null";
            modules.add(nextModule.getName());
        }
        Collections.sort(modules);
        StringBuilder builder = new StringBuilder("Type '");
        builder.append(this.m_fqTargetTypeName).append("' found in");
        for (String nextModule : modules) {
            builder.append(" '").append(nextModule).append("'");
        }
        if (this.m_resolvedWith != null) {
            builder.append(" - resolved with '").append(this.m_resolvedWith.getName()).append("'");
        }
        return builder.toString();
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + this.m_fqTargetTypeName.hashCode();
        result = 31 * result + this.m_availableTargets.hashCode();
        result = 31 * result + this.m_line;
        result = 31 * result + (this.m_resolvedWith == null ? 0 : ((Object)((Object)this.m_resolvedWith)).hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        AmbiguousTargetTypeInfo other = (AmbiguousTargetTypeInfo)obj;
        if (!this.m_fqTargetTypeName.equals(other.m_fqTargetTypeName)) {
            return false;
        }
        if (!this.m_availableTargets.equals(other.m_availableTargets)) {
            return false;
        }
        if (this.m_line != other.m_line) {
            return false;
        }
        return !(this.m_resolvedWith == null ? other.m_resolvedWith != null : !((Object)((Object)this.m_resolvedWith)).equals((Object)other.m_resolvedWith));
    }
}

