/*
 * Decompiled with CFR 0.152.
 */
package com.hello2morrow.sonargraph.languageprovider.java.command.system;

import com.hello2morrow.sonargraph.core.command.common.Command;
import com.hello2morrow.sonargraph.core.command.common.ICommandId;
import com.hello2morrow.sonargraph.core.command.common.ICommandInteractionData;
import com.hello2morrow.sonargraph.core.command.system.AbstractCreateSoftwareSystemCommand;
import com.hello2morrow.sonargraph.core.command.system.CreateSoftwareSystemCommand;
import com.hello2morrow.sonargraph.core.model.system.ISoftwareSystemProvider;
import com.hello2morrow.sonargraph.core.model.workspaceimport.ImportModuleCandidate;
import com.hello2morrow.sonargraph.foundation.activity.IWorkerContext;
import com.hello2morrow.sonargraph.foundation.utilities.OperationResult;
import com.hello2morrow.sonargraph.languageprovider.java.command.system.JavaCommandId;
import com.hello2morrow.sonargraph.languageprovider.java.controller.system.IJavaWorkspaceExtension;
import java.util.Set;

public final class CreateNewEclipseWorkspaceBasedSystemCommand
extends AbstractCreateSoftwareSystemCommand {
    public static final ICommandId ID = JavaCommandId.CREATE_SOFTWARE_SYSTEM_FROM_ECLIPSE_WORKSPACE;
    private final IInteraction m_interaction;
    private boolean m_finishedSuccessFully;
    private boolean m_canceled;

    public CreateNewEclipseWorkspaceBasedSystemCommand(ISoftwareSystemProvider provider, IInteraction interaction) {
        super(provider);
        assert (interaction != null) : "Parameter 'interaction' of method 'CreateNewEclipseWorkspaceBasedSystemCommand' must not be null";
        this.m_interaction = interaction;
    }

    public ICommandId getId() {
        return ID;
    }

    protected void internalRun(IWorkerContext workerContext) {
        assert (workerContext != null) : "Parameter 'workerContext' of method 'internalRun' must not be null";
        CreateSoftwareSystemCommand createSoftwareSystemCommand = new CreateSoftwareSystemCommand((ISoftwareSystemProvider)this.getController(), (AbstractCreateSoftwareSystemCommand.IInteraction)this.m_interaction);
        if (!createSoftwareSystemCommand.isEnabled().isSuccess()) {
            return;
        }
        this.runPrerequisiteCommand((Command)createSoftwareSystemCommand, workerContext);
        if (createSoftwareSystemCommand.canceled() || !this.getController().hasSoftwareSystem()) {
            this.m_canceled = true;
            return;
        }
        ImportDataEclipse importDataEclipse = new ImportDataEclipse();
        if (!this.m_interaction.collect(importDataEclipse)) {
            this.m_canceled = true;
            return;
        }
        IJavaWorkspaceExtension javaWorkspaceExtension = (IJavaWorkspaceExtension)this.getController().getSoftwareSystem().getExtension(IJavaWorkspaceExtension.class);
        OperationResult createModulesResult = javaWorkspaceExtension.createModulesFromEclipseWorkspace(workerContext, importDataEclipse.getCandidates(), IJavaWorkspaceExtension.ModuleImportMode.SYSTEM_CREATION);
        this.m_interaction.processModuleCreationResult(createModulesResult);
        this.m_finishedSuccessFully = createModulesResult.isSuccess();
    }

    public boolean hasBeenFinishedSuccessfully() {
        return this.m_finishedSuccessFully;
    }

    public boolean canceled() {
        return this.m_canceled;
    }

    public static interface IInteraction
    extends AbstractCreateSoftwareSystemCommand.IInteraction {
        public boolean collect(ImportDataEclipse var1);

        public void processModuleCreationResult(OperationResult var1);
    }

    public static final class ImportDataEclipse
    implements ICommandInteractionData {
        private Set<ImportModuleCandidate> m_moduleCandidates;

        public void setCandidates(Set<ImportModuleCandidate> candidates) {
            assert (candidates != null) : "Parameter 'candidates' of method 'setCandidates' must not be null";
            this.m_moduleCandidates = candidates;
        }

        public Set<ImportModuleCandidate> getCandidates() {
            assert (this.m_moduleCandidates != null) : "'m_moduleCandidates' of method 'getCandidates' must not be null";
            return this.m_moduleCandidates;
        }
    }
}

