/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.jxpath.ri;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.NoSuchElementException;
import org.apache.commons.jxpath.BasicNodeSet;
import org.apache.commons.jxpath.ExpressionContext;
import org.apache.commons.jxpath.JXPathContext;
import org.apache.commons.jxpath.JXPathException;
import org.apache.commons.jxpath.NodeSet;
import org.apache.commons.jxpath.Pointer;
import org.apache.commons.jxpath.ri.axes.RootContext;
import org.apache.commons.jxpath.ri.model.NodePointer;
import org.apache.commons.jxpath.util.ReverseComparator;

public abstract class EvalContext
implements ExpressionContext,
Iterator {
    protected EvalContext parentContext;
    protected RootContext rootContext;
    protected int position = 0;
    private boolean startedSetIteration = false;
    private boolean done = false;
    private boolean hasPerformedIteratorStep = false;
    private Iterator pointerIterator;

    public EvalContext(EvalContext parentContext) {
        this.parentContext = parentContext;
    }

    public Pointer getContextNodePointer() {
        return this.getCurrentNodePointer();
    }

    public JXPathContext getJXPathContext() {
        return this.getRootContext().getJXPathContext();
    }

    public int getPosition() {
        return this.position;
    }

    public int getDocumentOrder() {
        return this.parentContext != null && this.parentContext.isChildOrderingRequired() ? 1 : 0;
    }

    public boolean isChildOrderingRequired() {
        return this.getDocumentOrder() != 0;
    }

    public boolean hasNext() {
        if (this.pointerIterator != null) {
            return this.pointerIterator.hasNext();
        }
        if (this.getDocumentOrder() != 0) {
            return this.constructIterator();
        }
        if (!this.done && !this.hasPerformedIteratorStep) {
            this.performIteratorStep();
        }
        return !this.done;
    }

    public Object next() {
        if (this.pointerIterator != null) {
            return this.pointerIterator.next();
        }
        if (this.getDocumentOrder() != 0) {
            if (!this.constructIterator()) {
                throw new NoSuchElementException();
            }
            return this.pointerIterator.next();
        }
        if (!this.done && !this.hasPerformedIteratorStep) {
            this.performIteratorStep();
        }
        if (this.done) {
            throw new NoSuchElementException();
        }
        this.hasPerformedIteratorStep = false;
        return this.getCurrentNodePointer();
    }

    private void performIteratorStep() {
        this.done = true;
        if (this.position != 0 && this.nextNode()) {
            this.done = false;
        } else {
            while (this.nextSet()) {
                if (!this.nextNode()) continue;
                this.done = false;
                break;
            }
        }
        this.hasPerformedIteratorStep = true;
    }

    public void remove() {
        throw new UnsupportedOperationException("JXPath iterators cannot remove nodes");
    }

    private boolean constructIterator() {
        HashSet<NodePointer> set = new HashSet<NodePointer>();
        ArrayList<NodePointer> list = new ArrayList<NodePointer>();
        while (this.nextSet()) {
            while (this.nextNode()) {
                NodePointer pointer = this.getCurrentNodePointer();
                if (set.contains(pointer)) continue;
                set.add(pointer);
                list.add(pointer);
            }
        }
        if (list.isEmpty()) {
            return false;
        }
        this.sortPointers(list);
        this.pointerIterator = list.iterator();
        return true;
    }

    protected void sortPointers(List l) {
        switch (this.getDocumentOrder()) {
            case 1: {
                Collections.sort(l);
                break;
            }
            case -1: {
                Collections.sort(l, ReverseComparator.INSTANCE);
                break;
            }
        }
    }

    public List getContextNodeList() {
        int pos = this.position;
        if (pos != 0) {
            this.reset();
        }
        ArrayList<NodePointer> list = new ArrayList<NodePointer>();
        while (this.nextNode()) {
            list.add(this.getCurrentNodePointer());
        }
        if (pos != 0) {
            this.setPosition(pos);
        } else {
            this.reset();
        }
        return list;
    }

    public NodeSet getNodeSet() {
        if (this.position != 0) {
            throw new JXPathException("Simultaneous operations: should not request pointer list while iterating over an EvalContext");
        }
        BasicNodeSet set = new BasicNodeSet();
        while (this.nextSet()) {
            while (this.nextNode()) {
                set.add((Pointer)this.getCurrentNodePointer().clone());
            }
        }
        return set;
    }

    public Object getValue() {
        return this.getNodeSet();
    }

    public String toString() {
        Pointer ptr = this.getContextNodePointer();
        return ptr == null ? "Empty expression context" : "Expression context [" + this.getPosition() + "] " + ptr.asPath();
    }

    public RootContext getRootContext() {
        if (this.rootContext == null) {
            this.rootContext = this.parentContext.getRootContext();
        }
        return this.rootContext;
    }

    public void reset() {
        this.position = 0;
    }

    public int getCurrentPosition() {
        return this.position;
    }

    public Pointer getSingleNodePointer() {
        this.reset();
        while (this.nextSet()) {
            if (!this.nextNode()) continue;
            return this.getCurrentNodePointer();
        }
        return null;
    }

    public abstract NodePointer getCurrentNodePointer();

    public boolean nextSet() {
        this.reset();
        if (!this.startedSetIteration) {
            this.startedSetIteration = true;
            while (this.parentContext.nextSet()) {
                if (!this.parentContext.nextNode()) continue;
                return true;
            }
            return false;
        }
        if (this.parentContext.nextNode()) {
            return true;
        }
        while (this.parentContext.nextSet()) {
            if (!this.parentContext.nextNode()) continue;
            return true;
        }
        return false;
    }

    public abstract boolean nextNode();

    public boolean setPosition(int position) {
        this.position = position;
        return true;
    }
}

