/*
 * Decompiled with CFR 0.152.
 */
package com.hello2morrow.sonargraph.build.service.impl;

import com.hello2morrow.sonargraph.build.api.ProgressInfo;
import com.hello2morrow.sonargraph.build.foundation.common.DetailedProgressConsoleWorkerContext;
import com.hello2morrow.sonargraph.build.foundation.common.DotProgressConsoleWorkerContext;
import com.hello2morrow.sonargraph.foundation.activity.DefaultWorkerContext;
import com.hello2morrow.sonargraph.foundation.activity.IWorkerContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SonargraphBuildReporter {
    private static final Logger LOGGER = LoggerFactory.getLogger(SonargraphBuildReporter.class);

    static IWorkerContext createProgressWorkerContext(ProgressInfo progressInfo) {
        assert (progressInfo != null) : "Parameter 'progressInfo' of method 'createProgressWorkerContext' must not be null";
        Object result = null;
        switch (progressInfo) {
            case NONE: {
                result = DefaultWorkerContext.INSTANCE;
                break;
            }
            case BASIC: 
            case BASIC_FLUSH_EVERY_10_PERCENT: {
                result = new DotProgressConsoleWorkerContext(progressInfo);
                break;
            }
            case DETAILED: {
                result = new DetailedProgressConsoleWorkerContext();
                break;
            }
            default: {
                assert (false) : "Unexpected value: " + String.valueOf(progressInfo);
                break;
            }
        }
        return result;
    }

    static void reportProgress(ProgressInfo progressInfo, String message) {
        assert (progressInfo != null) : "Parameter 'progressInfo' of method 'reportProgress' must not be null";
        assert (message != null && message.length() > 0) : "Parameter 'message' of method 'reportProgress' must not be empty";
        if (progressInfo == ProgressInfo.NONE) {
            LOGGER.info(message);
            return;
        }
        System.out.println(message);
        System.out.flush();
    }

    static void reportError(ProgressInfo progressInfo, String message) {
        assert (progressInfo != null) : "Parameter 'progressInfo' of method 'reportError' must not be null";
        assert (message != null && message.length() > 0) : "Parameter 'message' of method 'reportError' must not be empty";
        if (progressInfo == ProgressInfo.NONE) {
            LOGGER.error(message);
            return;
        }
        System.err.println(message);
        System.err.flush();
    }
}

