/*
 * Decompiled with CFR 0.152.
 */
package com.hello2morrow.sonargraph.build.service.impl;

import com.hello2morrow.sonargraph.build.api.AbstractIssueFilter;
import com.hello2morrow.sonargraph.build.api.FailSet;
import com.hello2morrow.sonargraph.core.model.element.IIssueFilter;
import com.hello2morrow.sonargraph.core.model.element.Issue;
import com.hello2morrow.sonargraph.core.model.resolution.IgnoreDefinition;
import com.hello2morrow.sonargraph.core.model.resolution.IssueFilter;
import com.hello2morrow.sonargraph.core.model.resolution.ResolutionMode;
import com.hello2morrow.sonargraph.core.model.resolution.TaskDefinition;
import com.hello2morrow.sonargraph.core.model.system.SoftwareSystem;
import com.hello2morrow.sonargraph.foundation.utilities.IStandardEnumeration;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

final class IssueFinder {
    private static final Logger LOGGER = LoggerFactory.getLogger(IssueFinder.class);
    private final SoftwareSystem m_softwareSystem;

    public IssueFinder(SoftwareSystem softwareSystem) {
        assert (softwareSystem != null) : "Parameter 'softwareSystem' of method 'FailSetController' must not be null";
        this.m_softwareSystem = softwareSystem;
    }

    public List<Issue> issuesExist(FailSet failSet, StringBuilder log) {
        String message;
        assert (failSet != null) : "Parameter 'failSet' of method 'match' must not be null";
        assert (log != null) : "Parameter 'log' of method 'issuesExist' must not be null";
        IssueFilter issueFilter = new IssueFilter(new IStandardEnumeration[0]);
        List issueList = this.m_softwareSystem.getCurrentModel().getIssueList((IIssueFilter)issueFilter).getIssues();
        ArrayList<Issue> included = new ArrayList<Issue>();
        for (com.hello2morrow.sonargraph.build.api.IssueFilter next : failSet.getIncludeIssueFilters()) {
            List<Issue> filtered = this.filterIssues(issueList, (AbstractIssueFilter)next);
            message = String.format("Include filter %s matches %d issue(s).", next.toString(), filtered.size());
            LOGGER.debug(message);
            log.append(message).append("\n");
            included.addAll(filtered);
        }
        if (!included.isEmpty()) {
            for (com.hello2morrow.sonargraph.build.api.IssueFilter next : failSet.getExcludeIssueFilters()) {
                List<Issue> excluded = this.filterIssues(included, (AbstractIssueFilter)next);
                message = String.format("Exclude filter %s removes %d previously matched issue(s).", next.toString(), excluded.size());
                LOGGER.debug(message);
                log.append(message).append("\n");
                included.removeAll(excluded);
            }
        }
        return Collections.unmodifiableList(included);
    }

    private List<Issue> filterIssues(List<Issue> issues, AbstractIssueFilter filter) {
        assert (issues != null) : "Parameter 'issues' of method 'filterIssues' must not be null";
        assert (filter != null) : "Parameter 'filter' of method 'filterIssues' must not be null";
        return issues.stream().filter(i -> IssueFinder.acceptIssue(filter, i)).collect(Collectors.toList());
    }

    static boolean acceptIssue(AbstractIssueFilter filter, Issue issue) {
        Predicate<Issue> anyIssueTypePredicate = i -> {
            boolean containsProvider;
            String type = filter.getIssueType();
            if (type.equals("any")) {
                return true;
            }
            int colonPos = type.indexOf(":");
            boolean bl = containsProvider = colonPos > 0 && colonPos < type.length() - 1;
            if (containsProvider) {
                return i.getType().equalsIgnoreCase(type);
            }
            return i.getId().getStandardName().equalsIgnoreCase(type);
        };
        Predicate<Issue> anySeverity = i -> {
            if (filter.getSeverity().equals("any")) {
                return true;
            }
            return i.getSeverity().getStandardName().equalsIgnoreCase(filter.getSeverity());
        };
        Predicate<Issue> resolutionPredicate = i -> {
            if (filter.getResolution().equals("any")) {
                return true;
            }
            if (filter.getResolution().equalsIgnoreCase(ResolutionMode.NONE.getStandardName()) && i.getResolution() == null) {
                return true;
            }
            if (filter.getResolution().equalsIgnoreCase(ResolutionMode.IGNORE.getStandardName()) && i.getResolution(IgnoreDefinition.class) != null) {
                return true;
            }
            return filter.getResolution().equalsIgnoreCase(ResolutionMode.TASK.getStandardName()) && i.getResolution(TaskDefinition.class) != null;
        };
        if (!anyIssueTypePredicate.test(issue)) {
            return false;
        }
        if (!anySeverity.test(issue)) {
            return false;
        }
        return resolutionPredicate.test(issue);
    }
}

