/*
 * Decompiled with CFR 0.152.
 */
package com.hello2morrow.sonargraph.build.service.impl;

import com.hello2morrow.sonargraph.build.api.ReportRequest;
import com.hello2morrow.sonargraph.core.command.system.CreateReportCommand;
import com.hello2morrow.sonargraph.core.model.report.CreateReportResult;
import com.hello2morrow.sonargraph.core.model.report.IReport;
import com.hello2morrow.sonargraph.foundation.utilities.OperationResult;
import com.hello2morrow.sonargraph.foundation.utilities.OperationResultWithOutcome;
import de.schlichtherle.truezip.file.TFile;
import java.io.File;
import java.util.Set;

final class CreateReportInteraction
implements CreateReportCommand.IReportInteraction {
    private final ReportRequest m_reportRequest;
    private final Set<IReport.Format> m_convertedFormats;
    private final OperationResult m_reportResult;
    private final File m_baselineXmlReportFile;
    private CreateReportResult m_createReportResult;
    private final boolean m_isSystemDiffLicensed;

    CreateReportInteraction(Set<IReport.Format> convertedFormats, ReportRequest reportRequest, File baselineXmlReportFile, boolean isSystemDiffLicensed, OperationResult reportResult) {
        this.m_reportRequest = reportRequest;
        this.m_convertedFormats = convertedFormats;
        this.m_baselineXmlReportFile = baselineXmlReportFile;
        this.m_isSystemDiffLicensed = isSystemDiffLicensed;
        this.m_reportResult = reportResult;
    }

    public void handleResult(OperationResultWithOutcome<CreateReportResult> result) {
        assert (result != null) : "Parameter 'result' of method 'handleResult' must not be null";
        this.m_reportResult.addMessagesFrom(result);
        if (result.isSuccess()) {
            this.m_createReportResult = (CreateReportResult)result.getOutcome();
            this.m_reportResult.setIsSuccess(true);
        }
    }

    public CreateReportResult getCreateReportResult() {
        return this.m_createReportResult;
    }

    public boolean collect(CreateReportCommand.ReportInteractionData data) {
        assert (data != null) : "Parameter 'data' of method 'collect' must not be null";
        if (this.m_reportRequest.getActualReportType() == ReportRequest.ReportType.STANDARD) {
            data.setMetricLevels(data.getStandardLevels());
        } else if (this.m_reportRequest.getActualReportType() == ReportRequest.ReportType.FULL) {
            data.setMetricLevels(data.getAvailableLevels());
        } else assert (false) : "Unsupported type: " + this.m_reportRequest.getActualReportType().name();
        data.setReportFormats(this.m_convertedFormats);
        data.setReportDirectory(new TFile(this.m_reportRequest.getActualReportDirectory()));
        data.setReportFileName(this.m_reportRequest.getReportFileName());
        data.setElementCountToSplitHtmlReport(this.m_reportRequest.getElementCountToSplitHtmlReport());
        data.setMaxElementCountForHtmlDetailsPage(this.m_reportRequest.getMaxElementCountForHtmlDetailsPage());
        data.setSplitByModule(this.m_reportRequest.isSplitByModule());
        if (this.m_baselineXmlReportFile != null) {
            data.setBaselineXmlReportFile(new TFile(this.m_baselineXmlReportFile));
            data.setSystemDiffLicensed(this.m_isSystemDiffLicensed);
        }
        data.setTimestamp(this.m_reportRequest.getActualTimestamp());
        data.setReportDescription(this.m_reportRequest.getContextInfo());
        return true;
    }
}

