/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.core.runtime.preferences;

import java.util.Objects;
import java.util.Set;
import org.eclipse.core.internal.preferences.PrefsMessages;
import org.eclipse.core.runtime.preferences.IEclipsePreferences;
import org.eclipse.core.runtime.preferences.IPreferenceMetadataStore;
import org.eclipse.core.runtime.preferences.PreferenceMetadata;
import org.eclipse.osgi.util.NLS;

public final class OsgiPreferenceMetadataStore
implements IPreferenceMetadataStore {
    private static final Set<Class<?>> CLASSES = Set.of(Boolean.class, byte[].class, Double.class, Float.class, Integer.class, Long.class, String.class);
    private final IEclipsePreferences preferences;

    public OsgiPreferenceMetadataStore(IEclipsePreferences preferences) {
        Objects.requireNonNull(preferences, PrefsMessages.OsgiPreferenceMetadataStore_e_null_preference_node);
        this.preferences = preferences;
    }

    @Override
    public <V> boolean handles(Class<V> valueType) {
        return CLASSES.contains(valueType);
    }

    @Override
    public <V> V load(PreferenceMetadata<V> preference) {
        Class<V> valueClass = preference.valueClass();
        String identifer = preference.identifer();
        V defaultValue = preference.defaultValue();
        if (String.class.equals(valueClass)) {
            return valueClass.cast(this.preferences.get(identifer, (String)defaultValue));
        }
        if (Boolean.class.equals(valueClass)) {
            return valueClass.cast(this.preferences.getBoolean(identifer, (Boolean)defaultValue));
        }
        if (byte[].class.equals(valueClass)) {
            return valueClass.cast(this.preferences.getByteArray(identifer, (byte[])defaultValue));
        }
        if (Double.class.equals(valueClass)) {
            return valueClass.cast(this.preferences.getDouble(identifer, (Double)defaultValue));
        }
        if (Float.class.equals(valueClass)) {
            return valueClass.cast(Float.valueOf(this.preferences.getFloat(identifer, ((Float)defaultValue).floatValue())));
        }
        if (Integer.class.equals(valueClass)) {
            return valueClass.cast(this.preferences.getInt(identifer, (Integer)defaultValue));
        }
        if (Long.class.equals(valueClass)) {
            return valueClass.cast(this.preferences.getLong(identifer, (Long)defaultValue));
        }
        String message = PrefsMessages.PreferenceStorage_e_load_unsupported;
        throw new UnsupportedOperationException(NLS.bind((String)message, preference, valueClass));
    }

    @Override
    public <V> void save(V value, PreferenceMetadata<V> preference) {
        Class<V> valueClass = preference.valueClass();
        String identifer = preference.identifer();
        if (String.class.equals(valueClass)) {
            this.preferences.put(identifer, (String)value);
        } else if (Boolean.class.equals(valueClass)) {
            this.preferences.putBoolean(identifer, (Boolean)value);
        } else if (byte[].class.equals(valueClass)) {
            this.preferences.putByteArray(identifer, (byte[])value);
        } else if (Double.class.equals(valueClass)) {
            this.preferences.putDouble(identifer, (Double)value);
        } else if (Float.class.equals(valueClass)) {
            this.preferences.putFloat(identifer, ((Float)value).floatValue());
        } else if (Integer.class.equals(valueClass)) {
            this.preferences.putInt(identifer, (Integer)value);
        } else if (Long.class.equals(valueClass)) {
            this.preferences.putLong(identifer, (Long)value);
        } else {
            String message = PrefsMessages.PreferenceStorage_e_save_unsupported;
            throw new UnsupportedOperationException(NLS.bind((String)message, preference, valueClass));
        }
    }
}

