/*
 * Decompiled with CFR 0.152.
 */
package com.hello2morrow.sonargraph.plugin.spring.microservices.model;

import java.util.ArrayList;
import java.util.Map;

public final class SpringBootConfigurationProperties {
    public static final String CONFIG_SERVER_SEARCH_LOCATIONS = "spring.cloud.config.server.native.search-locations";
    public static final String APPLICATION_CONFIG_FILE_NAME = "application";
    public static final String SPRING_APPLICATION_NAME = "spring.application.name";

    public static String resolveProperties(String input, Map<String, Object> configuration) {
        assert (input != null) : "Parameter 'input' of method 'resolveProperties' must not be null";
        assert (configuration != null) : "Parameter 'configuration' of method 'resolveProperties' must not be null";
        if (configuration.isEmpty()) {
            return input;
        }
        ArrayList<String> properties = new ArrayList<String>();
        StringBuilder currentProp = new StringBuilder();
        boolean dollarDetected = false;
        boolean startDetected = false;
        char[] cArray = input.toCharArray();
        int n = cArray.length;
        int n2 = 0;
        while (n2 < n) {
            char c = cArray[n2];
            if (c == '$') {
                dollarDetected = true;
            } else if (dollarDetected && c == '{') {
                startDetected = true;
            } else if (c == '}') {
                if (startDetected) {
                    properties.add(currentProp.toString());
                    currentProp.delete(0, currentProp.length());
                    dollarDetected = false;
                    startDetected = false;
                }
            } else if (startDetected) {
                currentProp.append(c);
            }
            ++n2;
        }
        String result = input;
        for (String next : properties) {
            Object propertyValue = configuration.get(next);
            if (propertyValue == null) continue;
            result = result.replaceFirst("\\$\\{" + next + "\\}", propertyValue.toString());
        }
        return result;
    }
}

