/*
 * Decompiled with CFR 0.152.
 */
package com.hello2morrow.sonargraph.plugin.spring.microservices.model;

import java.util.Collections;
import java.util.HashMap;
import java.util.Map;

public class ConfigServerConfigurations {
    private final Map<String, Map<String, Object>> m_moduleConfigurations = new HashMap<String, Map<String, Object>>();
    private Map<String, Object> m_commonConfig;

    public void setCommonConfiguration(Map<String, Object> config) {
        assert (config != null) : "Parameter 'config' of method 'setCommonConfiguration' must not be null";
        this.m_commonConfig = config;
    }

    public Map<String, Object> getCommonConfig() {
        return this.m_commonConfig != null ? Collections.unmodifiableMap(this.m_commonConfig) : Collections.emptyMap();
    }

    public void addModuleConfiguration(String moduleName, Map<String, Object> configuration) {
        assert (moduleName != null && moduleName.length() > 0) : "Parameter 'moduleName' of method 'addModuleConfiguration' must not be empty";
        assert (configuration != null) : "Parameter 'configuration' of method 'addModuleConfiguration' must not be null";
        assert (!this.m_moduleConfigurations.containsKey(moduleName)) : "Configuration for module " + moduleName + " has already been added";
        this.m_moduleConfigurations.put(moduleName, configuration);
    }

    public Map<String, Object> getMergedModuleConfiguration(String moduleName) {
        Map<String, Object> moduleConfiguration;
        assert (moduleName != null && moduleName.length() > 0) : "Parameter 'moduleName' of method 'getMergedModuleConfiguration' must not be empty";
        HashMap<String, Object> result = new HashMap<String, Object>();
        if (this.m_commonConfig != null) {
            result.putAll(this.m_commonConfig);
        }
        if ((moduleConfiguration = this.m_moduleConfigurations.get(moduleName)) != null) {
            result.putAll(moduleConfiguration);
        }
        return result;
    }
}

