/*
 * Decompiled with CFR 0.152.
 */
package com.hello2morrow.sonargraph.languageprovider.csharp.controller.system;

import com.hello2morrow.sonargraph.core.controller.system.DeltaDetector;
import com.hello2morrow.sonargraph.core.model.common.IIssueId;
import com.hello2morrow.sonargraph.core.model.filter.IWorkspaceFilter;
import com.hello2morrow.sonargraph.core.model.path.FilePath;
import com.hello2morrow.sonargraph.core.model.path.RootDirectoryPath;
import com.hello2morrow.sonargraph.core.model.programming.ParserDependency;
import com.hello2morrow.sonargraph.core.model.programming.ProgrammingElement;
import com.hello2morrow.sonargraph.core.model.system.ILanguageProvider;
import com.hello2morrow.sonargraph.core.model.system.ModuleDelta;
import com.hello2morrow.sonargraph.core.model.workspace.Module;
import com.hello2morrow.sonargraph.foundation.activity.IWorkerContext;
import com.hello2morrow.sonargraph.foundation.file.IFileType;
import com.hello2morrow.sonargraph.foundation.utilities.OperationResult;
import com.hello2morrow.sonargraph.languageprovider.csharp.controller.system.RelevantSourceFilesFilter;
import com.hello2morrow.sonargraph.languageprovider.csharp.model.element.CSharpIssueId;
import com.hello2morrow.sonargraph.languageprovider.csharp.model.path.CSharpFileType;
import com.hello2morrow.sonargraph.languageprovider.csharp.model.path.CSharpSourceFile;
import com.hello2morrow.sonargraph.languageprovider.csharp.model.system.CSharpModule;
import de.schlichtherle.truezip.file.TFile;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

final class CSharpDeltaDetector
extends DeltaDetector {
    private static final Logger LOGGER = LoggerFactory.getLogger(CSharpDeltaDetector.class);
    private final Set<TFile> m_sourceFiles = new HashSet<TFile>();
    private final Set<FilePath> m_affectedModuleFiles = new LinkedHashSet<FilePath>();
    private final Set<FilePath> m_affectedFiles = new HashSet<FilePath>();
    private boolean m_changesDetectedInPreceedingModules = false;
    private final Set<TFile> m_linkedSourceFiles = new HashSet<TFile>();
    private static final RelevantSourceFilesFilter SOURCE_FILE_FILTER = new RelevantSourceFilesFilter();

    public CSharpDeltaDetector(IWorkerContext workerContext, ILanguageProvider languageProvider, IWorkspaceFilter filter, Module module, List<String> ignoreDirectories) {
        super(workerContext, languageProvider, filter, module, ignoreDirectories);
    }

    protected void changesDetectedInPreceedingModules() {
        this.m_changesDetectedInPreceedingModules = true;
    }

    protected void scanDirectories(OperationResult result) {
        Visitor visitor = new Visitor();
        super.scanDirectories(result);
        if (this.m_delta == null) {
            return;
        }
        if (!this.m_delta.isEmpty() || this.m_changesDetectedInPreceedingModules) {
            Module module = this.getModule();
            for (FilePath source : module.getChildrenRecursively(CSharpSourceFile.class, new Class[]{CSharpSourceFile.class})) {
                if (this.m_delta.isDeleted(source) || !source.hasIssues(new IIssueId[]{CSharpIssueId.CS_PARSER_WARNING, CSharpIssueId.CS_PARSER_ERROR})) continue;
                this.m_delta.modified(source);
            }
        }
        this.m_delta.visitModified((ModuleDelta.IVisitor)visitor);
        this.m_delta.visitDeleted((ModuleDelta.IVisitor)visitor);
        for (FilePath source : this.m_affectedModuleFiles) {
            this.m_delta.modified(source);
        }
    }

    protected void aboutToScanRoot(RootDirectoryPath root) {
        assert (root != null) : "Parameter 'root' of method 'aboutToScanRoot' must not be null";
        TFile rootDir = root.getFile();
        for (TFile next : this.m_linkedSourceFiles) {
            if (next.exists()) {
                IFileType fileType = this.accepts(next);
                if (fileType != null) {
                    this.consume(rootDir, next, fileType);
                    continue;
                }
                LOGGER.warn("Omitting linked file {} from delta", (Object)next);
                continue;
            }
            LOGGER.warn("Linked file {} does not exist!", (Object)next);
        }
    }

    private void markAffectedFilesAsModified(ModuleDelta moduleDelta, FilePath sourceFile) {
        LinkedHashSet<CSharpSourceFile> affected;
        LinkedHashSet<FilePath> delta = new LinkedHashSet<FilePath>();
        delta.add(sourceFile);
        do {
            affected = new LinkedHashSet<CSharpSourceFile>();
            for (FilePath source : delta) {
                if (this.m_affectedFiles.contains(source)) continue;
                this.m_affectedFiles.add(source);
                List elements = source.getChildrenRecursively(ProgrammingElement.class, new Class[0]);
                for (ProgrammingElement pe : elements) {
                    Iterator iterator = pe.getIncomingDependencyIterator();
                    while (iterator.hasNext()) {
                        Module fromModule;
                        ParserDependency dep = (ParserDependency)iterator.next();
                        ProgrammingElement from = dep.getFrom();
                        CSharpSourceFile fromSource = (CSharpSourceFile)from.getParent(CSharpSourceFile.class, new Class[0]);
                        assert (fromSource != null);
                        if (moduleDelta.isModified((FilePath)fromSource) || moduleDelta.isDeleted((FilePath)fromSource) || !affected.add(fromSource) || (fromModule = (Module)fromSource.getParent(CSharpModule.class, new Class[0])) != this.m_module) continue;
                        this.m_affectedModuleFiles.add((FilePath)fromSource);
                    }
                }
                source.setTimestamp(1L);
            }
        } while ((delta = affected).size() > 0);
    }

    public IFileType accepts(TFile file) {
        assert (file != null) : "'file' must not be null";
        if (this.m_sourceFiles.isEmpty() && SOURCE_FILE_FILTER.accept(file)) {
            return CSharpFileType.SOURCE_FILE;
        }
        if (this.m_linkedSourceFiles.contains(file) || this.m_sourceFiles.contains(file)) {
            return CSharpFileType.SOURCE_FILE;
        }
        return null;
    }

    public void synchronize(OperationResult result) {
    }

    private class Visitor
    implements ModuleDelta.IVisitor {
        private Visitor() {
        }

        public void deleted(ModuleDelta delta, FilePath filePath) {
            CSharpDeltaDetector.this.markAffectedFilesAsModified(delta, filePath);
        }

        public void modified(ModuleDelta delta, FilePath filePath) {
            CSharpDeltaDetector.this.markAffectedFilesAsModified(delta, filePath);
        }

        public void added(RootDirectoryPath root, IFileType fileType, TFile file) {
        }
    }
}

