/*
 * Decompiled with CFR 0.152.
 */
package com.hello2morrow.sonargraph.integration.access.apitest;

import com.hello2morrow.sonargraph.integration.access.controller.ControllerFactory;
import com.hello2morrow.sonargraph.integration.access.controller.IModuleInfoProcessor;
import com.hello2morrow.sonargraph.integration.access.controller.ISonargraphSystemController;
import com.hello2morrow.sonargraph.integration.access.foundation.Result;
import com.hello2morrow.sonargraph.integration.access.model.IIssue;
import com.hello2morrow.sonargraph.integration.access.model.IModule;
import com.hello2morrow.sonargraph.integration.access.model.ISourceFile;
import java.io.File;
import java.util.List;
import java.util.Map;
import org.junit.Assert;
import org.junit.Test;

public final class ModuleInfoProcessorClassFileIssueTest {
    ISonargraphSystemController m_controller;

    @Test
    public void validateIssues() {
        this.m_controller = ControllerFactory.createController();
        Result result = this.m_controller.loadSystemReport(new File("./src/test/resources/ClassFileIssues.xml"));
        Assert.assertTrue((String)("Failed to read report: " + result.toString()), (boolean)result.isSuccess());
        Map<String, IModule> moduleMap = this.m_controller.getSoftwareSystem().getModules();
        IModule m1 = moduleMap.get("m1");
        Assert.assertNotNull((String)"Module 'm1' not found", (Object)m1);
        IModuleInfoProcessor processor = this.m_controller.createModuleInfoProcessor(m1);
        Map<ISourceFile, List<IIssue>> issueMap = processor.getIssuesForSourceFiles(null);
        Assert.assertEquals((String)"Wrong number of issues", (long)1L, (long)issueMap.size());
        Assert.assertEquals((String)"Wrong file name", (Object)"Simple.java", (Object)issueMap.keySet().iterator().next().getName());
    }
}

