/*
 * Decompiled with CFR 0.152.
 */
package com.hello2morrow.sonargraph.build.client.ant;

import com.hello2morrow.sonargraph.build.api.ISonargraphBuild;
import com.hello2morrow.sonargraph.build.api.ProgressInfo;
import com.hello2morrow.sonargraph.build.api.ServiceResponse;
import com.hello2morrow.sonargraph.build.api.StartupRequest;
import com.hello2morrow.sonargraph.build.client.ISonargraphBuildClient;
import com.hello2morrow.sonargraph.build.client.ISonargraphBuildInteraction;
import com.hello2morrow.sonargraph.build.client.SonargraphBuildClientVersionManager;
import com.hello2morrow.sonargraph.build.client.SonargraphBuildTransaction;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.util.List;
import java.util.Properties;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.Task;

abstract class AbstractSonargraphTask
extends Task
implements ISonargraphBuildClient {
    private String m_installationDir;
    private String m_activationCode;
    private String m_licenseFile;
    private String m_logLevel;
    private String m_logFile;
    private String m_progressInfo;
    private String m_waitForLicense;
    private String m_proxyHost;
    private String m_proxyPort;
    private String m_proxyUsername;
    private String m_proxyPassword;
    private String m_licenseServerUrl;
    private String m_licenseServerHost;
    private String m_licenseServerPort;
    private String m_uploadHostUrl;
    private String m_createAndUploadSnapshot;
    private String m_clientKey;
    private String m_failedUploadDirectory;
    private String m_analyzerExecutionLevel;
    private final SonargraphBuildClientVersionManager m_versionManager = new SonargraphBuildClientVersionManager();

    @Override
    public String getClientName() {
        return "Ant";
    }

    private final StartupRequest createStartupRequest() {
        StartupRequest request = new StartupRequest();
        request.setInstallationDirectory(this.m_installationDir);
        request.setActivationCode(this.m_activationCode);
        request.setLicenseFile(this.m_licenseFile);
        request.setAnalyzerExecutionLevel(this.m_analyzerExecutionLevel);
        request.setLogFile(this.m_logFile);
        request.setLogLevel(this.m_logLevel);
        if (this.m_progressInfo != null && ProgressInfo.fromString(this.m_progressInfo) == ProgressInfo.BASIC) {
            request.setProgressInfoAsString(ProgressInfo.BASIC_FLUSH_EVERY_10_PERCENT.name());
        } else {
            request.setProgressInfoAsString(this.m_progressInfo);
        }
        request.setProxyHost(this.m_proxyHost);
        request.setProxyPort(this.m_proxyPort);
        request.setProxyUsername(this.m_proxyUsername);
        request.setProxyPassword(this.m_proxyPassword);
        request.setLicenseServerHost(this.m_licenseServerHost);
        request.setLicenseServerPort(this.m_licenseServerPort);
        request.setLicenseServerUrl(this.m_licenseServerUrl);
        request.setWaitForLicenseString(this.m_waitForLicense);
        return request;
    }

    @Override
    public void info(String msg) {
        this.log(msg);
    }

    @Override
    public void error(String msg) {
        this.handleErrorFlush(msg);
    }

    public void setLicenseFile(String licenseFile) {
        assert (licenseFile != null && licenseFile.length() > 0) : "Parameter 'licenseFile' of method 'setLicenseFile' must not be empty";
        this.m_licenseFile = licenseFile;
    }

    public void setActivationCode(String activationCode) {
        assert (activationCode != null && activationCode.length() > 0) : "Parameter 'activationCode' of method 'setActivationCode' must not be empty";
        this.m_activationCode = activationCode;
    }

    public void setLogFile(String path) {
        assert (path != null && path.length() > 0) : "Parameter 'path' of method 'setLogFile' must not be empty";
        this.m_logFile = path;
    }

    public void setLogLevel(String logLevel) {
        assert (logLevel != null && logLevel.length() > 0) : "Parameter 'logLevel' of method 'setLogLevel' must not be empty";
        this.m_logLevel = logLevel;
    }

    public void setProgressInfo(String progressInfo) {
        assert (progressInfo != null && progressInfo.length() > 0) : "Parameter 'progressInfo' of method 'setProgressInfo' must not be empty";
        this.m_progressInfo = progressInfo;
    }

    public void setInstallationDirectory(String path) {
        assert (path != null) : "Parameter 'path' of method 'setInstallationDirectory' must not be null";
        this.m_installationDir = path;
    }

    public void setProxyHost(String proxyHost) {
        assert (proxyHost != null) : "Parameter 'proxyHost' of method 'setProxyHost' must not be null";
        this.m_proxyHost = proxyHost;
    }

    public void setAnalyzerExecutionLevel(String analyzerExecutionLevel) {
        this.m_analyzerExecutionLevel = analyzerExecutionLevel;
    }

    public void setProxyPort(String proxyPort) {
        assert (proxyPort != null) : "Parameter 'proxyPort' of method 'setProxyPort' must not be null";
        this.m_proxyPort = proxyPort;
    }

    public void setLicenseServerHost(String licenseServerHost) {
        this.m_licenseServerHost = licenseServerHost;
    }

    public void setLicenseServerPort(String licenseServerPort) {
        this.m_licenseServerPort = licenseServerPort;
    }

    public void setLicenseServerUrl(String licenseServerUrl) {
        this.m_licenseServerUrl = licenseServerUrl;
    }

    public void setProxyUsername(String proxyUsername) {
        assert (proxyUsername != null) : "Parameter 'proxyUsername' of method 'setProxyUser' must not be null";
        this.m_proxyUsername = proxyUsername;
    }

    public void setProxyPassword(String proxyPassword) {
        assert (proxyPassword != null) : "Parameter 'proxyPassword' of method 'setProxyPassword' must not be null";
        this.m_proxyPassword = proxyPassword;
    }

    public void setWaitForLicense(String tries) {
        this.m_waitForLicense = tries;
    }

    public void setUploadHostUrl(String uploadHostUrl) {
        this.m_uploadHostUrl = uploadHostUrl;
    }

    public void setCreateAndUploadSnapshot(String createAndUploadSnapshot) {
        this.m_createAndUploadSnapshot = createAndUploadSnapshot;
    }

    protected boolean isCreateAndUploadSnapshot() {
        return this.m_createAndUploadSnapshot == null ? true : Boolean.parseBoolean(this.m_createAndUploadSnapshot);
    }

    protected final String getUploadHostUrl() {
        return this.m_uploadHostUrl;
    }

    public void setClientKey(String clientKey) {
        this.m_clientKey = clientKey;
    }

    protected final String getClientKey() {
        return this.m_clientKey;
    }

    public void setFailedUploadDirectory(String path) {
        this.m_failedUploadDirectory = path;
    }

    protected final String getFailedUploadDirectory() {
        return this.m_failedUploadDirectory;
    }

    @Override
    public File getDefaultOutputDirectory() {
        return new File(".");
    }

    @Override
    public ISonargraphBuild.Version getVersion() {
        return this.m_versionManager.getVersion();
    }

    private String getAbsolutePath(String path) {
        if (path == null || path.isEmpty()) {
            return "";
        }
        File file = new File(path);
        try {
            return file.getCanonicalPath();
        }
        catch (IOException iOException) {
            return file.getAbsolutePath();
        }
    }

    public final void execute() {
        String version = "";
        try (InputStream input = this.getClass().getClassLoader().getResourceAsStream("version.properties");){
            Properties props = new Properties();
            props.load(input);
            version = props.getProperty("sonargraph.version");
        }
        catch (IOException | NullPointerException e) {
            version = "unable to read version.properties";
        }
        this.info("Startup info [" + this.getClass().getName() + ":" + version + "]");
        this.info("'sonargraph.installationDirectory'='" + this.getAbsolutePath(this.m_installationDir) + "'");
        ServiceResponse transactionResponse = null;
        long startTime = System.currentTimeMillis();
        try {
            StartupRequest startupRequest = this.createStartupRequest();
            List<ISonargraphBuildInteraction> interactions = this.createInteractions(startupRequest);
            SonargraphBuildTransaction transaction = new SonargraphBuildTransaction(this, startupRequest, interactions);
            transactionResponse = transaction.execute();
        }
        catch (Exception e) {
            throw new BuildException("Failed to execute SonargraphBuild! " + e.getMessage(), (Throwable)e);
        }
        if (transactionResponse == null) {
            throw new BuildException("Failed to execute SonargraphBuild!");
        }
        if (transactionResponse.isFailure()) {
            throw new BuildException("Failed to execute SonargraphBuild:\n" + transactionResponse.getStatusMessage());
        }
        this.info("SonargraphBuild: Completed successfully after " + (System.currentTimeMillis() - startTime) + " ms.");
    }

    protected abstract List<ISonargraphBuildInteraction> createInteractions(StartupRequest var1);
}

