/*
 * Decompiled with CFR 0.152.
 */
package com.hello2morrow.sonargraph.build.client;

public final class MemoryPrinter {
    private static final int MB = 0x100000;

    private MemoryPrinter() {
    }

    public static String getInfo() {
        StringBuilder builder = new StringBuilder();
        Runtime runtime = Runtime.getRuntime();
        long free = runtime.freeMemory() / 0x100000L;
        long currentlyAllocated = runtime.totalMemory() / 0x100000L;
        long used = (runtime.totalMemory() - runtime.freeMemory()) / 0x100000L;
        long maxMemory = runtime.maxMemory();
        long max = maxMemory != Long.MAX_VALUE ? maxMemory / 0x100000L : -1L;
        builder.append("Memory Info: ").append(used).append("M[used] ").append(free).append("M[free] ").append(currentlyAllocated).append("M[allocated]");
        if (max > 0L) {
            builder.append(" ").append(max).append("M[max]");
        }
        return builder.toString();
    }

    public static void main(String[] args) {
        System.out.println(MemoryPrinter.getInfo());
    }
}

