/*
 * Decompiled with CFR 0.152.
 */
package com.hello2morrow.sonargraph.languageprovider.python.controller.settings;

import com.hello2morrow.sonargraph.core.foundation.common.base.CoreResourceProviderAdapter;
import com.hello2morrow.sonargraph.core.foundation.common.base.IPathValidator;
import com.hello2morrow.sonargraph.core.foundation.common.base.Language;
import com.hello2morrow.sonargraph.core.model.common.IIssueId;
import com.hello2morrow.sonargraph.core.model.element.Issue;
import com.hello2morrow.sonargraph.core.model.element.NamedElement;
import com.hello2morrow.sonargraph.core.model.event.ConfigurationModifiedEvent;
import com.hello2morrow.sonargraph.core.model.system.Extension;
import com.hello2morrow.sonargraph.core.model.system.Files;
import com.hello2morrow.sonargraph.core.model.system.ISoftwareSystemProvider;
import com.hello2morrow.sonargraph.core.model.system.Installation;
import com.hello2morrow.sonargraph.core.model.system.SoftwareSystem;
import com.hello2morrow.sonargraph.core.model.workspace.Workspace;
import com.hello2morrow.sonargraph.core.persistence.system.SystemPropertiesPersistenceProvider;
import com.hello2morrow.sonargraph.foundation.activity.IWorkerContext;
import com.hello2morrow.sonargraph.foundation.event.Event;
import com.hello2morrow.sonargraph.foundation.event.EventManager;
import com.hello2morrow.sonargraph.foundation.utilities.IOMessageCause;
import com.hello2morrow.sonargraph.foundation.utilities.OperationResult;
import com.hello2morrow.sonargraph.foundation.utilities.OperationResultWithOutcome;
import com.hello2morrow.sonargraph.foundation.utilities.Version;
import com.hello2morrow.sonargraph.languageprovider.python.controller.settings.IPythonInterpreterConsumer;
import com.hello2morrow.sonargraph.languageprovider.python.controller.settings.PythonInterpreterCreator;
import com.hello2morrow.sonargraph.languageprovider.python.controller.settings.PythonInterpreterLocator;
import com.hello2morrow.sonargraph.languageprovider.python.controller.settings.PythonInterpreterValidator;
import com.hello2morrow.sonargraph.languageprovider.python.controller.settings.PythonVirtualEnvironmentValidator;
import com.hello2morrow.sonargraph.languageprovider.python.controllerinterface.IPythonSettingsExtension;
import com.hello2morrow.sonargraph.languageprovider.python.foundation.common.PythonCause;
import com.hello2morrow.sonargraph.languageprovider.python.foundation.common.PythonLanguage;
import com.hello2morrow.sonargraph.languageprovider.python.model.element.PythonIssueId;
import com.hello2morrow.sonargraph.languageprovider.python.model.settings.IPythonVirtualEnvironmentValidator;
import com.hello2morrow.sonargraph.languageprovider.python.model.settings.PythonInstallationSettings;
import com.hello2morrow.sonargraph.languageprovider.python.model.settings.PythonInterpreter;
import com.hello2morrow.sonargraph.languageprovider.python.model.settings.PythonInterpreterNotFoundIssue;
import de.schlichtherle.truezip.file.TFile;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.EnumSet;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class PythonSettingsExtension
extends Extension
implements IPythonSettingsExtension {
    private static final Logger LOGGER = LoggerFactory.getLogger(PythonSettingsExtension.class);
    public static final String PYTHON_INTERPRETER = "PythonInterpreter";
    private static final String PARAM_PYTHON_INTERPRETER_PATH = "pythonInterpreterPath";
    private static final String[] RESOURCES_LIST = new String[]{"python/generator3.py", "python/pycharm_generator_utils/__init__.py", "python/pycharm_generator_utils/clr_tools.py", "python/pycharm_generator_utils/constants.py", "python/pycharm_generator_utils/module_redeclarator.py", "python/pycharm_generator_utils/pyparsing_py3.py", "python/pycharm_generator_utils/pyparsing.py", "python/pycharm_generator_utils/util_methods.py"};
    private final Installation m_installation;
    private final IPythonInterpreterConsumer m_consumer;
    private TFile m_pythonUserHome;
    private Version m_userHomeVersion = Version.create((int)0, (int)0, (int)0, (int)0);
    private boolean m_forceSkeletonGeneration = false;

    public PythonSettingsExtension(Installation installation, IPythonInterpreterConsumer consumer) {
        assert (installation != null) : "Parameter 'installation' of method 'PythonInstallationExtension' must not be null";
        assert (consumer != null) : "Parameter 'consumer' of method 'PythonInstallationExtension' must not be null";
        this.m_installation = installation;
        this.m_consumer = consumer;
    }

    private void writeVersion(TFile versionFile) {
        try {
            Throwable throwable = null;
            Object var3_5 = null;
            try (BufferedWriter writer = new BufferedWriter(new FileWriter((File)versionFile));){
                writer.write(this.m_installation.getVersion().toString() + "\n");
                this.m_userHomeVersion = this.m_installation.getVersion();
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        catch (IOException e) {
            LOGGER.error("Failed to write to: " + versionFile.getAbsolutePath(), (Throwable)e);
            try {
                versionFile.rm();
            }
            catch (IOException e1) {
                LOGGER.error("Failed to delete: " + versionFile.getAbsolutePath(), (Throwable)e1);
            }
        }
    }

    private void readVersion() {
        TFile versionFile = new TFile((File)this.m_pythonUserHome, "version.txt");
        try {
            Throwable throwable = null;
            Object var3_6 = null;
            try (BufferedReader reader = new BufferedReader(new FileReader((File)versionFile));){
                String version = reader.readLine();
                this.m_userHomeVersion = Version.create((String)version);
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        catch (FileNotFoundException e) {
            this.m_forceSkeletonGeneration = true;
            this.writeVersion(versionFile);
        }
        catch (IOException e) {
            LOGGER.error("Failed to read from: " + versionFile.getAbsolutePath(), (Throwable)e);
            this.m_forceSkeletonGeneration = true;
        }
        if (this.m_forceSkeletonGeneration || this.m_userHomeVersion.isBefore(this.m_installation.getVersion())) {
            this.copyResourcesToUserHome();
            this.writeVersion(versionFile);
            this.m_forceSkeletonGeneration = true;
        }
    }

    private PythonInterpreterCreator.SkeletonGeneration getSkeletonGenerationMode() {
        return this.m_forceSkeletonGeneration ? PythonInterpreterCreator.SkeletonGeneration.GENERATE : PythonInterpreterCreator.SkeletonGeneration.USE_EXISTING;
    }

    public void finishInstallationInitialization() {
        TFile userHome = CoreResourceProviderAdapter.getInstance().getSonargraphUserHomeDir();
        this.m_pythonUserHome = new TFile((File)userHome, "Python");
        this.m_pythonUserHome.mkdirs();
        this.readVersion();
        PythonInstallationSettings settings = new PythonInstallationSettings(this.m_installation, (File)this.m_pythonUserHome);
        try {
            settings.load();
        }
        catch (IOException e) {
            LOGGER.error("Error while reading python.properties", (Throwable)e);
        }
        this.m_installation.addChild((NamedElement)settings);
        String interpreterPath = settings.getProperty(PythonInstallationSettings.PythonProperty.PYTHON_INTERPRETER);
        if (interpreterPath == null) {
            interpreterPath = PythonInterpreterLocator.findInSystemWidePath();
            if (interpreterPath != null) {
                settings.setProperty(PythonInstallationSettings.PythonProperty.PYTHON_INTERPRETER, interpreterPath);
                try {
                    settings.save();
                }
                catch (IOException e) {
                    LOGGER.error("Error while writing python.properties", (Throwable)e);
                }
            } else {
                LOGGER.warn("Failed to determine Python interpreter");
                settings.addIssue((Issue)new PythonInterpreterNotFoundIssue((NamedElement)settings, "Python interpreter could not be determined from environment. Please configure it via the preference page"));
            }
        }
        super.finishInstallationInitialization();
    }

    @Override
    public OperationResultWithOutcome<PythonInterpreter> initializePythonInterpreter(IWorkerContext workerContext) {
        assert (workerContext != null) : "Parameter 'workerContext' of method 'initializePythonInterpreter' must not be null";
        OperationResultWithOutcome result = new OperationResultWithOutcome("Initializing python interpreter");
        PythonInstallationSettings installationSettings = (PythonInstallationSettings)((Object)this.m_installation.getUniqueExistingChild(PythonInstallationSettings.class));
        if (installationSettings.hasIssues(new IIssueId[]{PythonIssueId.PYTHON_INTERPRETER_NOT_FOUND})) {
            result.addError((OperationResult.IMessageCause)PythonCause.INVALID_PYTHON_INTERPRETER_PATH, "Python interpreter could not be determined from environment. Please configure it via the preference page", new Object[0]);
            return result;
        }
        String interpreterPath = installationSettings.getProperty(PythonInstallationSettings.PythonProperty.PYTHON_INTERPRETER);
        assert (interpreterPath != null) : "Missing interpreter path!";
        LOGGER.info("Using python interpreter path '" + interpreterPath + "'");
        PythonInterpreterCreator creator = new PythonInterpreterCreator();
        OperationResultWithOutcome<PythonInterpreter> createResult = creator.create(workerContext, (NamedElement)installationSettings, interpreterPath, this.m_pythonUserHome, this.m_pythonUserHome, this.getSkeletonGenerationMode());
        if (createResult.isSuccess()) {
            installationSettings.addChild((NamedElement)createResult.getOutcome());
        }
        return createResult;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void copyResourcesToUserHome() {
        ClassLoader cl = this.getClass().getClassLoader();
        String pythonHomePath = this.m_pythonUserHome.getNormalizedAbsolutePath();
        String[] stringArray = RESOURCES_LIST;
        int n = RESOURCES_LIST.length;
        int n2 = 0;
        while (true) {
            block19: {
                if (n2 >= n) {
                    return;
                }
                String resourceName = stringArray[n2];
                TFile target = new TFile(pythonHomePath, resourceName);
                if (!target.getParentFile().isDirectory()) {
                    target.getParentFile().mkdirs();
                }
                try {
                    Throwable throwable = null;
                    Object var9_11 = null;
                    try {
                        InputStream input = cl.getResourceAsStream(resourceName);
                        try {
                            try (FileOutputStream output = new FileOutputStream((File)target);){
                                int b;
                                while ((b = input.read()) != -1) {
                                    ((OutputStream)output).write(b);
                                }
                            }
                            if (input == null) break block19;
                        }
                        catch (Throwable throwable2) {
                            if (throwable == null) {
                                throwable = throwable2;
                            } else if (throwable != throwable2) {
                                throwable.addSuppressed(throwable2);
                            }
                            if (input == null) throw throwable;
                            input.close();
                            throw throwable;
                        }
                        input.close();
                    }
                    catch (Throwable throwable3) {
                        if (throwable == null) {
                            throwable = throwable3;
                            throw throwable;
                        }
                        if (throwable == throwable3) throw throwable;
                        throwable.addSuppressed(throwable3);
                        throw throwable;
                    }
                }
                catch (IOException e) {
                    LOGGER.error("Cannot copy resource: " + resourceName, (Throwable)e);
                }
            }
            ++n2;
        }
    }

    private void dispatchConfigurationChangedEvent() {
        EventManager.getInstance().dispatch((Object)this, (Event)new ConfigurationModifiedEvent((ISoftwareSystemProvider)this.m_installation.getExtension(ISoftwareSystemProvider.class), (Language)PythonLanguage.INSTANCE, EnumSet.of(ConfigurationModifiedEvent.Change.CONFIGURATION_CHANGED)));
    }

    @Override
    public void applyInstallationParameters(Map<String, String> instSpecificParameters, OperationResult result) {
        String interpreterPath;
        assert (instSpecificParameters != null) : "Parameter 'instSpecificParameters' of method 'applyInstallationParameters' must not be null";
        assert (result != null) : "Parameter 'result' of method 'applyInstallationParameters' must not be null";
        String path = instSpecificParameters.get(PARAM_PYTHON_INTERPRETER_PATH);
        if (path == null || path.trim().length() == 0) {
            return;
        }
        PythonInterpreterCreator creator = new PythonInterpreterCreator();
        PythonInstallationSettings settings = (PythonInstallationSettings)((Object)this.m_installation.getUniqueExistingChild(PythonInstallationSettings.class));
        OperationResultWithOutcome<PythonInterpreter> creationResult = creator.create((NamedElement)settings, interpreterPath = path.trim());
        if (creationResult.isSuccess()) {
            settings.addChild((NamedElement)creationResult.getOutcome());
        } else {
            result.addMessagesFrom(creationResult);
        }
    }

    @Override
    public OperationResult setInterpreterPath(IWorkerContext workerContext, String interpreterPath, boolean forceSkeletonRegeneration) {
        PythonInterpreterCreator creator;
        OperationResultWithOutcome<PythonInterpreter> result;
        assert (workerContext != null) : "Parameter 'workerContext' of method 'setInterpreterPath' must not be null";
        assert (interpreterPath != null && interpreterPath.length() > 0) : "Parameter 'interpreterPath' of method 'setInterpreterPath' must not be empty";
        PythonInstallationSettings settings = (PythonInstallationSettings)((Object)this.m_installation.getUniqueExistingChild(PythonInstallationSettings.class));
        settings.setProperty(PythonInstallationSettings.PythonProperty.PYTHON_INTERPRETER, interpreterPath);
        PythonInterpreter previous = (PythonInterpreter)((Object)settings.getUniqueChild(PythonInterpreter.class));
        if (previous != null) {
            settings.removeChild(previous);
        }
        if ((result = (creator = new PythonInterpreterCreator()).create(workerContext, (NamedElement)settings, interpreterPath, this.m_pythonUserHome, this.m_pythonUserHome, forceSkeletonRegeneration ? PythonInterpreterCreator.SkeletonGeneration.GENERATE : this.getSkeletonGenerationMode())).isSuccess()) {
            settings.addChild((NamedElement)result.getOutcome());
        }
        try {
            settings.save();
        }
        catch (IOException e) {
            result.addError((OperationResult.IMessageCause)IOMessageCause.IO_EXCEPTION, (Throwable)e);
        }
        this.m_consumer.pythonInstallationInterpreterPathChanged(interpreterPath);
        this.dispatchConfigurationChangedEvent();
        return result;
    }

    @Override
    public String getSystemInterpreterPath(SoftwareSystem system) {
        assert (system != null) : "Parameter 'system' of method 'getSystemInterpreterPath' must not be null";
        return system.getSystemProperty(PYTHON_INTERPRETER);
    }

    @Override
    public OperationResult setSystemInterpreterPath(IWorkerContext workerContext, SoftwareSystem softwareSystem, String interpreterPath, boolean forceSkeletonRegeneration) {
        assert (workerContext != null) : "Parameter 'workerContext' of method 'setSystemInterpreterPath' must not be null";
        assert (softwareSystem != null) : "Parameter 'softwareSystem' of method 'setSystemInterpreterPath' must not be null";
        OperationResult result = new OperationResult("Update Python system interpreter");
        Workspace workspace = (Workspace)softwareSystem.getUniqueExistingChild(Workspace.class);
        PythonInterpreter previous = (PythonInterpreter)((Object)workspace.getUniqueChild(PythonInterpreter.class));
        if (previous != null) {
            workspace.removeChild((NamedElement)previous);
        }
        if (interpreterPath != null && interpreterPath.trim().length() > 0) {
            OperationResultWithOutcome<PythonInterpreter> createResult = this.createSystemInterpreter(workerContext, softwareSystem, interpreterPath, forceSkeletonRegeneration);
            if (createResult.isFailure()) {
                result.addMessagesFrom(createResult);
            } else {
                workspace.addChild((NamedElement)createResult.getOutcome());
            }
        }
        softwareSystem.setNeedsReparse(true);
        softwareSystem.setSystemProperty(PYTHON_INTERPRETER, interpreterPath);
        SystemPropertiesPersistenceProvider.storeProperties((SoftwareSystem)softwareSystem, (OperationResult)result);
        this.dispatchConfigurationChangedEvent();
        return result;
    }

    @Override
    public OperationResultWithOutcome<PythonInterpreter> createSystemInterpreter(IWorkerContext workerContext, SoftwareSystem softwareSystem, String interpreterPath, boolean forceSkeletonRegeneration) {
        assert (workerContext != null) : "Parameter 'workerContext' of method 'createSystemInterpreter' must not be null";
        assert (softwareSystem != null) : "Parameter 'softwareSystem' of method 'createSystemInterpreter' must not be null";
        assert (interpreterPath != null) : "Parameter 'interpreterPath' of method 'createSystemInterpreter' must not be null";
        TFile dataDir = ((Files)softwareSystem.getUniqueExistingChild(Files.class)).getHiddenDataDirectory();
        PythonInterpreterCreator creator = new PythonInterpreterCreator();
        return creator.create(workerContext, (NamedElement)softwareSystem.getUniqueExistingChild(Workspace.class), interpreterPath, dataDir, this.m_pythonUserHome, forceSkeletonRegeneration ? PythonInterpreterCreator.SkeletonGeneration.GENERATE : this.getSkeletonGenerationMode());
    }

    @Override
    public IPathValidator getPythonInterpreterPathValidator() {
        return new PythonInterpreterValidator();
    }

    @Override
    public IPythonVirtualEnvironmentValidator getPythonVirtualEnvironmentPathValidator() {
        return new PythonVirtualEnvironmentValidator();
    }
}

