/*
 * Decompiled with CFR 0.152.
 */
package com.hello2morrow.sonargraph.foundation.windows;

import com.hello2morrow.sonargraph.foundation.utilities.Platform;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.prefs.Preferences;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

final class WinRegistryJava8 {
    public static final int HKEY_CURRENT_USER = -2147483647;
    public static final int HKEY_LOCAL_MACHINE = -2147483646;
    public static final int REG_SUCCESS = 0;
    public static final int REG_NOTFOUND = 2;
    public static final int REG_ACCESSDENIED = 5;
    private static final Logger LOGGER = LoggerFactory.getLogger(WinRegistryJava8.class);
    private static final int KEY_READ = 131097;
    private static Preferences userRoot = Preferences.userRoot();
    private static Preferences systemRoot = Preferences.systemRoot();
    private static Class<? extends Preferences> userClass = userRoot.getClass();
    private static Method regOpenKey = null;
    private static Method regCloseKey = null;
    private static Method regQueryValueEx = null;
    private static Method regEnumValue = null;
    private static Method regQueryInfoKey = null;
    private static Method regEnumKeyEx = null;

    static {
        try {
            regOpenKey = userClass.getDeclaredMethod("WindowsRegOpenKey", Integer.TYPE, byte[].class, Integer.TYPE);
            regOpenKey.setAccessible(true);
            regCloseKey = userClass.getDeclaredMethod("WindowsRegCloseKey", Integer.TYPE);
            regCloseKey.setAccessible(true);
            regQueryValueEx = userClass.getDeclaredMethod("WindowsRegQueryValueEx", Integer.TYPE, byte[].class);
            regQueryValueEx.setAccessible(true);
            regEnumValue = userClass.getDeclaredMethod("WindowsRegEnumValue", Integer.TYPE, Integer.TYPE, Integer.TYPE);
            regEnumValue.setAccessible(true);
            regQueryInfoKey = userClass.getDeclaredMethod("WindowsRegQueryInfoKey1", Integer.TYPE);
            regQueryInfoKey.setAccessible(true);
            regEnumKeyEx = userClass.getDeclaredMethod("WindowsRegEnumKeyEx", Integer.TYPE, Integer.TYPE, Integer.TYPE);
            regEnumKeyEx.setAccessible(true);
        }
        catch (Exception e) {
            LOGGER.error(e.getMessage(), (Throwable)e);
        }
    }

    private WinRegistryJava8() {
        assert (!Platform.isOperatingSystemUnixBased()) : "WinRegistry should only be used on Windows";
        assert (Platform.getJavaVersion() == 8) : "WinRegistryJava8 must only be instantiated for Java 8";
    }

    public static String readString(int hkey, String key, String valueName) {
        assert (hkey == -2147483646 || hkey == -2147483647) : "Invalid hkey";
        if (hkey == -2147483646) {
            return WinRegistryJava8.readString(systemRoot, hkey, key, valueName);
        }
        return WinRegistryJava8.readString(userRoot, hkey, key, valueName);
    }

    public static Map<String, String> readStringValues(int hkey, String key) {
        assert (hkey == -2147483646 || hkey == -2147483647) : "Invalid hkey";
        if (hkey == -2147483646) {
            return WinRegistryJava8.readStringValues(systemRoot, hkey, key);
        }
        return WinRegistryJava8.readStringValues(userRoot, hkey, key);
    }

    public static List<String> readStringSubKeys(int hkey, String key) {
        if (hkey == -2147483646) {
            return WinRegistryJava8.readStringSubKeys(systemRoot, hkey, key);
        }
        if (hkey == -2147483647) {
            return WinRegistryJava8.readStringSubKeys(userRoot, hkey, key);
        }
        throw new IllegalArgumentException("hkey=" + hkey);
    }

    private static String readString(Preferences root, int hkey, String key, String value) {
        int[] handles;
        byte[] valb;
        block3: {
            valb = null;
            handles = (int[])regOpenKey.invoke((Object)root, hkey, WinRegistryJava8.toCstr(key), 131097);
            if (handles[1] == 0) break block3;
            return null;
        }
        try {
            valb = (byte[])regQueryValueEx.invoke((Object)root, handles[0], WinRegistryJava8.toCstr(value));
            regCloseKey.invoke((Object)root, handles[0]);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return valb != null ? new String(valb).trim() : null;
    }

    private static Map<String, String> readStringValues(Preferences root, int hkey, String key) {
        int[] handles;
        LinkedHashMap<String, String> results;
        block4: {
            results = new LinkedHashMap<String, String>();
            handles = (int[])regOpenKey.invoke((Object)root, hkey, WinRegistryJava8.toCstr(key), 131097);
            if (handles[1] == 0) break block4;
            return null;
        }
        try {
            int[] info = (int[])regQueryInfoKey.invoke((Object)root, handles[0]);
            int count = info[2];
            int maxlen = info[4];
            int index = 0;
            while (index < count) {
                byte[] name = (byte[])regEnumValue.invoke((Object)root, handles[0], index, maxlen + 1);
                String value = WinRegistryJava8.readString(hkey, key, new String(name));
                results.put(new String(name).trim(), value);
                ++index;
            }
            regCloseKey.invoke((Object)root, handles[0]);
        }
        catch (Exception e) {
            LOGGER.error(e.getMessage(), (Throwable)e);
        }
        return results;
    }

    private static List<String> readStringSubKeys(Preferences root, int hkey, String key) {
        int[] handles;
        ArrayList<String> results;
        block4: {
            results = new ArrayList<String>();
            handles = (int[])regOpenKey.invoke((Object)root, hkey, WinRegistryJava8.toCstr(key), 131097);
            if (handles[1] == 0) break block4;
            return null;
        }
        try {
            int[] info = (int[])regQueryInfoKey.invoke((Object)root, handles[0]);
            int count = info[0];
            int maxlen = info[3];
            int index = 0;
            while (index < count) {
                byte[] name = (byte[])regEnumKeyEx.invoke((Object)root, handles[0], index, maxlen + 1);
                results.add(new String(name).trim());
                ++index;
            }
            regCloseKey.invoke((Object)root, handles[0]);
        }
        catch (Exception e) {
            LOGGER.error(e.getMessage(), (Throwable)e);
        }
        return results;
    }

    private static byte[] toCstr(String str) {
        byte[] result = new byte[str.length() + 1];
        int i = 0;
        while (i < str.length()) {
            result[i] = (byte)str.charAt(i);
            ++i;
        }
        result[str.length()] = 0;
        return result;
    }
}

