/*
 * Decompiled with CFR 0.152.
 */
package com.hello2morrow.sonargraph.foundation.utilities;

import com.hello2morrow.sonargraph.foundation.utilities.ExceptionUtility;
import java.util.GregorianCalendar;
import javax.xml.datatype.DatatypeConfigurationException;
import javax.xml.datatype.DatatypeFactory;
import javax.xml.datatype.XMLGregorianCalendar;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.xml.sax.Attributes;

public class XmlUtility {
    private static final Logger LOGGER = LoggerFactory.getLogger(XmlUtility.class);

    public static XMLGregorianCalendar createDateTimeObject() {
        GregorianCalendar gcal = new GregorianCalendar();
        XMLGregorianCalendar xgcal = null;
        try {
            xgcal = DatatypeFactory.newInstance().newXMLGregorianCalendar(gcal);
        }
        catch (DatatypeConfigurationException ex) {
            assert (false) : "Failed to create new instance of XMLGregorianCalendar!";
            LOGGER.error("Failed to create XMLGregorianCalendar: " + ExceptionUtility.collectAll(ex));
        }
        return xgcal;
    }

    public static XMLGregorianCalendar createDateTimeObject(long timeStamp) {
        GregorianCalendar gcal = new GregorianCalendar();
        gcal.setTimeInMillis(timeStamp);
        XMLGregorianCalendar xgcal = null;
        try {
            xgcal = DatatypeFactory.newInstance().newXMLGregorianCalendar(gcal);
        }
        catch (DatatypeConfigurationException ex) {
            assert (false) : "Failed to create new instance of XMLGregorianCalendar!";
            LOGGER.error("Failed to create XMLGregorianCalendar: " + ExceptionUtility.collectAll(ex));
        }
        return xgcal;
    }

    public static String getAttributeValueIgnoreCase(Attributes attributes, String attributeName) {
        assert (attributes != null) : "Parameter 'attributes' of method 'getAttributeValue' must not be null";
        assert (attributeName != null && attributeName.length() > 0) : "Parameter 'attributeName' of method 'getAttributeValue' must not be empty";
        int i = 0;
        while (i < attributes.getLength()) {
            if (attributes.getQName(i).equalsIgnoreCase(attributeName)) {
                return attributes.getValue(i);
            }
            ++i;
        }
        return null;
    }
}

