/*
 * Decompiled with CFR 0.152.
 */
package com.hello2morrow.sonargraph.foundation.utilities;

import com.hello2morrow.sonargraph.foundation.utilities.IStandardEnumeration;
import com.hello2morrow.sonargraph.foundation.utilities.StringUtility;
import gnu.trove.map.hash.THashMap;
import gnu.trove.set.hash.THashSet;
import java.net.URL;
import java.text.MessageFormat;
import java.util.Collections;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.ResourceBundle;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class ResourceProviderRegistry {
    public static final String MISSING_RESOURCE_BUNDLE_ENTRY = "Missing resource bundle entry for key: ";
    private static final Logger LOGGER = LoggerFactory.getLogger(ResourceProviderRegistry.class);
    private static ResourceProviderRegistry s_instance;
    private final Map<IResourceProviderAdapter, List<? extends IResourceProviderAdapter>> m_resourceProviderAdapter = new THashMap();
    private final Map<String, ResourceBundle> m_bundles = new THashMap();
    private final Locale m_CurrentLocale = new Locale.Builder().setLanguage("en").build();

    private ResourceProviderRegistry() {
    }

    public static ResourceProviderRegistry getInstance() {
        if (s_instance == null) {
            s_instance = new ResourceProviderRegistry();
        }
        return s_instance;
    }

    public void delete() {
        ResourceProviderRegistry.deleteInstance();
    }

    private static void deleteInstance() {
        s_instance = null;
    }

    public List<? extends IResourceProviderAdapter> getChain(IResourceProviderAdapter adapter) {
        assert (adapter != null) : "Parameter 'adapter' of method 'getChain' must not be null";
        List<? extends IResourceProviderAdapter> chain = this.m_resourceProviderAdapter.get(adapter);
        if (chain != null) {
            return Collections.unmodifiableList(chain);
        }
        return Collections.emptyList();
    }

    public void register(List<? extends IResourceProviderAdapter> chain) {
        assert (chain != null) : "'chain' must not be null";
        assert (!chain.isEmpty()) : "At least one adapter must be specified in 'chain'";
        THashSet fqClazzNames = new THashSet();
        for (IResourceProviderAdapter iResourceProviderAdapter : chain) {
            if (!fqClazzNames.add(iResourceProviderAdapter.getClass().getName())) assert (false) : "Duplicate in 'chain': " + iResourceProviderAdapter.getClass().getName();
        }
        IResourceProviderAdapter iResourceProviderAdapter = chain.get(0);
        if (!this.m_resourceProviderAdapter.containsKey(iResourceProviderAdapter)) {
            Object adapterWithSimpleNameAlreadyExists = null;
            for (IResourceProviderAdapter nextAdapter : this.m_resourceProviderAdapter.keySet()) {
                if (!nextAdapter.getClass().getSimpleName().equals(iResourceProviderAdapter.getClass().getSimpleName())) continue;
                adapterWithSimpleNameAlreadyExists = nextAdapter;
                break;
            }
            if (adapterWithSimpleNameAlreadyExists == null) {
                this.m_resourceProviderAdapter.put(iResourceProviderAdapter, chain);
            } else assert (false) : "Adapter already added with identical simple name '" + iResourceProviderAdapter.getClass().getSimpleName() + "': " + iResourceProviderAdapter.getClass().getName() + " / " + adapterWithSimpleNameAlreadyExists.getClass().getName();
        } else assert (false) : "Adapter already added: " + iResourceProviderAdapter.getClass().getName();
    }

    public URL getResourceUrl(IResourceProviderAdapter adapter, IResourceType type, String resourceName) {
        assert (adapter != null) : "Parameter 'adapter' of method 'getResourceUrl' must not be null";
        assert (type != null) : "Parameter 'type' of method 'getResourceUrl' must not be null";
        assert (resourceName != null && resourceName.length() > 0) : "Parameter 'resourceName' of method 'getResourceUrl' must not be empty";
        List<? extends IResourceProviderAdapter> chain = this.m_resourceProviderAdapter.get(adapter);
        assert (chain != null) : "Adapter not registered: " + adapter.getClass().getName();
        for (IResourceProviderAdapter iResourceProviderAdapter : chain) {
            ClassLoader nextClassLoader = iResourceProviderAdapter.getClass().getClassLoader();
            for (String nextResourcePath : iResourceProviderAdapter.getResourcePaths(type, resourceName)) {
                URL url = nextClassLoader.getResource(nextResourcePath);
                if (url == null) continue;
                return url;
            }
        }
        return null;
    }

    private ResourceBundle getResourceBundle(IResourceProviderAdapter adapter) {
        assert (adapter != null) : "'adapter' must not be null";
        String bundleKey = adapter.getClass().getName();
        ResourceBundle bundle = this.m_bundles.get(bundleKey);
        if (bundle == null) {
            for (String resourceBundlePath : adapter.getResourceBundlePaths()) {
                try {
                    bundle = ResourceBundle.getBundle(resourceBundlePath, this.m_CurrentLocale, adapter.getClass().getClassLoader());
                    this.m_bundles.put(bundleKey, bundle);
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            if (bundle == null) {
                LOGGER.error("Unable to locate bundle for: " + adapter.getClass().getName() + " (" + String.valueOf(adapter.getResourceBundlePaths()) + ")");
            }
        }
        return bundle;
    }

    public String getString(IResourceProviderAdapter adapter, String key, Object ... arguments) {
        assert (adapter != null) : "'adapter' must not be null";
        assert (key != null) : "'key' must not be null";
        Object resolvedString = null;
        List<? extends IResourceProviderAdapter> chain = this.m_resourceProviderAdapter.get(adapter);
        assert (chain != null) : "Adapter not registered: " + adapter.getClass().getName();
        for (IResourceProviderAdapter iResourceProviderAdapter : chain) {
            ResourceBundle resourceBundle = this.getResourceBundle(iResourceProviderAdapter);
            if (resourceBundle == null) continue;
            try {
                resolvedString = resourceBundle.getString(key);
            }
            catch (Exception exception) {
                // empty catch block
            }
            if (resolvedString != null && ((String)resolvedString).length() > 0) break;
        }
        if (resolvedString == null || ((String)resolvedString).length() == 0) {
            resolvedString = MISSING_RESOURCE_BUNDLE_ENTRY + key;
            LOGGER.warn("Unable to retrieve string for key: " + key);
        } else if (arguments != null && arguments.length > 0) {
            MessageFormat messageFormat = new MessageFormat("");
            messageFormat.setLocale(this.m_CurrentLocale);
            try {
                messageFormat.applyPattern((String)resolvedString);
                resolvedString = messageFormat.format(arguments);
            }
            catch (Exception e) {
                LOGGER.warn("Unable to format string for key: " + key + " - " + e.getLocalizedMessage());
            }
        }
        return resolvedString;
    }

    public static interface IResourceProviderAdapter {
        public List<String> getResourcePaths(IResourceType var1, String var2);

        public List<String> getResourceBundlePaths();
    }

    public static interface IResourceType
    extends IStandardEnumeration {
        public String getExtension();
    }

    public static final class ResourceType
    extends Enum<ResourceType>
    implements IResourceType {
        public static final /* enum */ ResourceType IMAGE = new ResourceType("Gif", ".gif");
        public static final /* enum */ ResourceType PNG = new ResourceType("PNG", ".png");
        public static final /* enum */ ResourceType PROPERTIES = new ResourceType("Properties", ".properties");
        public static final /* enum */ ResourceType XSD = new ResourceType("XML Shema", ".xsd");
        public static final /* enum */ ResourceType TEMPLATE = new ResourceType("Groovy Template File", ".tpl");
        public static final /* enum */ ResourceType CSS = new ResourceType("Cascading Stylesheet", ".css");
        public static final /* enum */ ResourceType HTML = new ResourceType("HTML", ".html");
        public static final /* enum */ ResourceType XML = new ResourceType("XML", ".xml");
        public static final /* enum */ ResourceType TXT = new ResourceType("TXT", ".txt");
        public static final /* enum */ ResourceType ZIP = new ResourceType("Zip", ".zip");
        private final String m_presentationName;
        private final String m_extension;
        private static final /* synthetic */ ResourceType[] ENUM$VALUES;

        static {
            ENUM$VALUES = new ResourceType[]{IMAGE, PNG, PROPERTIES, XSD, TEMPLATE, CSS, HTML, XML, TXT, ZIP};
        }

        private ResourceType(String presentationName, String extension) {
            assert (presentationName != null && presentationName.length() > 0) : "Parameter 'presentationName' of method 'ResourceType' must not be empty";
            assert (extension != null && extension.length() > 0) : "Parameter 'extension' of method 'ResourceType' must not be empty";
            this.m_presentationName = presentationName;
            this.m_extension = extension;
        }

        @Override
        public String getExtension() {
            return this.m_extension;
        }

        @Override
        public String getStandardName() {
            return StringUtility.convertConstantNameToStandardName(this.name());
        }

        @Override
        public String getPresentationName() {
            return this.m_presentationName;
        }

        public static ResourceType[] values() {
            ResourceType[] resourceTypeArray = ENUM$VALUES;
            int n = resourceTypeArray.length;
            ResourceType[] resourceTypeArray2 = new ResourceType[n];
            System.arraycopy(ENUM$VALUES, 0, resourceTypeArray2, 0, n);
            return resourceTypeArray2;
        }

        public static ResourceType valueOf(String string) {
            return Enum.valueOf(ResourceType.class, string);
        }
    }
}

