/*
 * Decompiled with CFR 0.152.
 */
package com.hello2morrow.sonargraph.foundation.file;

import com.hello2morrow.sonargraph.foundation.file.FileUtility;
import com.hello2morrow.sonargraph.foundation.utilities.StringUtility;
import de.schlichtherle.truezip.file.TFile;
import java.io.IOException;
import java.io.InputStream;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.regex.Pattern;

public final class SectionedData {
    private final Map<String, String> m_data;

    private SectionedData(Map<String, String> data) {
        this.m_data = data;
    }

    public String getRawContent(String section) {
        return this.m_data.get(section);
    }

    public void setRawContent(String section, String content) {
        this.m_data.put(section, content);
    }

    public boolean hasSection(String section) {
        return this.m_data.get(section) != null;
    }

    public boolean removeSection(String section) {
        return this.m_data.remove(section) != null;
    }

    public Collection<String> getSections() {
        return this.m_data.keySet();
    }

    public int size() {
        return this.m_data.size();
    }

    public void writeToFile(TFile file) throws IOException {
        FileUtility.writeFileContent(this.toString(), file);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        for (String k : this.m_data.keySet()) {
            sb.append("[").append(k).append("]\n");
            sb.append(this.m_data.get(k));
            sb.append("\n\n");
        }
        return sb.toString();
    }

    public static SectionedData fromFile(TFile file) throws IOException {
        if (!file.canRead()) {
            return null;
        }
        return new SectionedData(SectionedData.parseContent(FileUtility.getFileContent(file)));
    }

    public static SectionedData fromStream(InputStream input) throws IOException {
        return new SectionedData(SectionedData.parseContent(FileUtility.getFileContent(input)));
    }

    public static SectionedData fromFile(String fileName) throws IOException {
        return SectionedData.fromFile(new TFile(fileName));
    }

    public static SectionedData fromString(String data) {
        return new SectionedData(SectionedData.parseContent(data));
    }

    private static Map<String, String> parseContent(String text) {
        LinkedHashMap<String, String> result = new LinkedHashMap<String, String>();
        String section = null;
        Object content = "";
        for (String it : StringUtility.multiLineStringToList(text, false)) {
            String trimmedLine = it.trim();
            if (Pattern.matches("\\[\\w+( \\w+)*\\]", trimmedLine)) {
                if (section != null) {
                    result.put(section, (String)content);
                }
                section = trimmedLine.substring(1, trimmedLine.length() - 1);
                content = "";
                continue;
            }
            if (it.startsWith("#")) continue;
            content = (String)content + it + "\n";
        }
        if (section != null) {
            result.put(section, (String)content);
        }
        return result;
    }

    public static SectionedData fromMap(Map<String, String> dataMap) {
        return new SectionedData(dataMap);
    }
}

