/*
 * Decompiled with CFR 0.152.
 */
package com.hello2morrow.sonargraph.foundation.commandline;

import com.hello2morrow.sonargraph.foundation.commandline.ICallback;
import com.hello2morrow.sonargraph.foundation.commandline.Option;

class ArgumentOption
extends Option {
    private boolean m_missingArgument;
    private String m_argument;

    public ArgumentOption(String option, String description, boolean mandatory) {
        super(option, description, mandatory);
    }

    public ArgumentOption(String option, String argumentDescription, String description, boolean mandatory) {
        super(option, argumentDescription, description, mandatory);
    }

    protected final void setMissingArgument() {
        this.m_missingArgument = true;
    }

    protected void setArgument(String arg) {
        assert (arg != null) : "arg != null (20)";
        assert (arg.length() > 0) : "arg.length() > 0 (21)";
        this.m_argument = arg;
    }

    @Override
    protected final String getArgument() {
        return this.m_argument;
    }

    @Override
    protected int process(String[] args, int index) {
        assert (args != null) : "args != null (32)";
        assert (args.length > 0) : "args.length > 0 (33)";
        assert (index >= 0) : "index >= 0 (34)";
        assert (index < args.length) : "index < args.length (35)";
        int resultingIndex = -1;
        if (args[index].equals(this.getOptionIdentifier())) {
            if (this.alreadyProcessed()) {
                this.setDuplicateOption();
                resultingIndex = index + 1 >= args.length || args[index + 1].startsWith("-") ? index : index + 1;
            } else {
                if (index + 1 >= args.length || args[index + 1].startsWith("-")) {
                    this.setMissingArgument();
                    resultingIndex = index;
                } else {
                    this.setArgument(args[index + 1]);
                    resultingIndex = index + 1;
                }
                this.setProcessed();
            }
        }
        return resultingIndex;
    }

    @Override
    protected boolean isStateValid(ICallback cb) {
        if (this.m_missingArgument) {
            cb.argumentForArgumentOptionMissing(this.getOptionIdentifier());
        }
        return super.isStateValid(cb) && !this.m_missingArgument;
    }
}

