/*
 * Decompiled with CFR 0.152.
 */
package com.hello2morrow.javapg.runtime.lexer.base;

import com.hello2morrow.javapg.runtime.lexer.base.ILexer;
import com.hello2morrow.javapg.runtime.lexer.base.LexerState;
import com.hello2morrow.javapg.runtime.messaging.Position;
import com.hello2morrow.sonargraph.foundation.file.SmartReader;
import de.schlichtherle.truezip.file.TFileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.UnsupportedEncodingException;

public abstract class AbstractLexer
implements ILexer {
    private static final int INITIAL_BUFFER_SIZE = 8192;
    public static final int EOF_CHAR = -1;
    protected char[] buffer;
    protected int numChars = 0;
    private LexerState savedStates = null;
    private int savedPos = -1;
    private int currentToken = -1;
    protected int tokenPos = 0;
    protected int currentPos = 0;
    protected int markPos = -1;
    protected int line = 0;
    protected int column = 0;
    protected int bufferOffset = 0;
    protected Reader input;
    protected String inputName;
    protected boolean reachedEof = false;
    protected boolean repeat = false;
    private boolean supportingUnicodeLineTerminators = false;
    private boolean skipKeywordSearch = false;
    private boolean hasFatalError = false;

    protected abstract int tokenize() throws IOException;

    protected AbstractLexer() {
    }

    @Override
    public void init() {
    }

    @Override
    public boolean hasFatalError() {
        return this.hasFatalError;
    }

    public void setFatalError() {
        this.hasFatalError = true;
    }

    public boolean isSupportingUnicodeLineTerminators() {
        return this.supportingUnicodeLineTerminators;
    }

    public void setSupportingUnicodeLineTerminators(boolean supportingUnicodeLineTerminators) {
        this.supportingUnicodeLineTerminators = supportingUnicodeLineTerminators;
    }

    public boolean isSkipKeywordSearch() {
        return this.skipKeywordSearch;
    }

    public void setSkipKeywordSearch(boolean skipKeywordSearch) {
        this.skipKeywordSearch = skipKeywordSearch;
    }

    public void pushState() {
        if (this.savedPos == -1) {
            this.savedPos = this.tokenPos;
        }
        this.savedStates = new LexerState(this.savedStates, this.currentToken, this.tokenPos, this.currentPos, this.markPos, this.line, this.column);
    }

    public void popState() {
        assert (this.savedStates != null);
        this.currentToken = this.savedStates.currentToken;
        this.tokenPos = this.savedStates.tokenPos;
        this.currentPos = this.savedStates.currentPos;
        this.markPos = this.savedStates.markPos;
        this.line = this.savedStates.line;
        this.column = this.savedStates.column;
        this.savedStates = this.savedStates.previous;
        this.repeat = false;
        if (this.savedStates == null) {
            this.savedPos = -1;
        }
    }

    private boolean fillBuffer() throws IOException {
        int numRead;
        int pos;
        char lastChar;
        char c = lastChar = this.currentPos > 0 ? this.buffer[this.currentPos - 1] : (char)'\u0000';
        if (this.reachedEof) {
            return false;
        }
        int n = pos = this.savedPos == -1 ? this.tokenPos : this.savedPos;
        if (pos > 0) {
            System.arraycopy(this.buffer, pos, this.buffer, 0, this.numChars - pos);
            this.currentPos -= pos;
            this.numChars -= pos;
            if (this.markPos != -1) {
                this.markPos -= pos;
            }
            this.tokenPos -= pos;
            this.bufferOffset += pos;
            if (this.savedPos != -1) {
                this.savedPos = 0;
                this.savedStates.adjust(pos);
            }
        }
        if (this.numChars == this.buffer.length) {
            char[] newBuf = new char[this.buffer.length * 2];
            System.arraycopy(this.buffer, 0, newBuf, 0, this.numChars);
            this.buffer = newBuf;
        }
        while ((numRead = this.input.read(this.buffer, this.numChars, this.buffer.length - this.numChars)) == 0) {
        }
        if (numRead == -1) {
            this.input.close();
            this.input = null;
            this.reachedEof = true;
            if (lastChar != '\n') {
                this.buffer[this.numChars++] = 10;
                return true;
            }
            return false;
        }
        assert (numRead > 0);
        this.numChars += numRead;
        return true;
    }

    private void updatePosition() {
        block5: while (this.tokenPos < this.currentPos) {
            char c = this.buffer[this.tokenPos++];
            switch (c) {
                case '\n': {
                    ++this.line;
                    this.column = 1;
                    break;
                }
                case '\r': {
                    if (this.tokenPos >= this.currentPos || this.buffer[this.tokenPos] == '\n') continue block5;
                    ++this.line;
                    this.column = 1;
                    break;
                }
                case '\u2028': 
                case '\u2029': {
                    if (this.supportingUnicodeLineTerminators) {
                        ++this.line;
                        this.column = 1;
                        break;
                    }
                }
                default: {
                    ++this.column;
                }
            }
        }
    }

    protected int filterToken(int tok) throws IOException {
        return tok;
    }

    @Override
    public void assignInput(Reader inp, String name) {
        if (this.buffer == null) {
            this.buffer = new char[8192];
        } else {
            this.numChars = 0;
            this.tokenPos = 0;
            this.currentPos = 0;
            this.currentToken = -1;
            this.markPos = -1;
            this.reachedEof = false;
            this.savedStates = null;
            this.bufferOffset = 0;
        }
        this.line = 1;
        this.column = 1;
        this.input = inp;
        this.inputName = name;
    }

    @Override
    public void assignInput(String fileName) throws FileNotFoundException {
        TFileInputStream inputFile = new TFileInputStream(fileName);
        SmartReader inp = new SmartReader((InputStream)inputFile);
        this.assignInput(inp, fileName);
    }

    @Override
    public void assignInput(String fileName, String charSet) throws FileNotFoundException, UnsupportedEncodingException {
        TFileInputStream inputFile = new TFileInputStream(fileName);
        InputStreamReader inp = new InputStreamReader((InputStream)inputFile, charSet);
        this.assignInput(inp, fileName);
    }

    @Override
    public void assignInput(InputStream inputStream, String name) {
        SmartReader inp = new SmartReader(inputStream);
        this.assignInput(inp, name);
    }

    private static int hexValue(int c) {
        if (c >= 48 && c <= 57) {
            return c - 48;
        }
        if (c >= 97 && c <= 102) {
            return c + 10 - 97;
        }
        return c + 10 - 65;
    }

    private static boolean isHexDigit(int c) {
        if (c >= 48 && c <= 57) {
            return true;
        }
        if (c >= 97 && c <= 102) {
            return true;
        }
        return c >= 65 && c <= 70;
    }

    public int nextChar() throws IOException {
        int currentChar;
        if (this.currentPos < this.numChars || !this.reachedEof && this.fillBuffer()) {
            if ((currentChar = this.buffer[this.currentPos++]) == 92) {
                int c4;
                int c3;
                int c2;
                int c1;
                boolean foundUnicodeCodePoint = false;
                int next = this.nextChar();
                int pos = this.currentPos - 1;
                if (next == 117 && AbstractLexer.isHexDigit(c1 = this.nextChar()) && AbstractLexer.isHexDigit(c2 = this.nextChar()) && AbstractLexer.isHexDigit(c3 = this.nextChar()) && AbstractLexer.isHexDigit(c4 = this.nextChar())) {
                    int c = AbstractLexer.hexValue(c4) + 16 * AbstractLexer.hexValue(c3) + 256 * AbstractLexer.hexValue(c2) + 4096 * AbstractLexer.hexValue(c1);
                    boolean bl = foundUnicodeCodePoint = c != 8232 && c != 8233 && c != 34 && c != 39 && c != 10;
                    if (foundUnicodeCodePoint) {
                        currentChar = c;
                    }
                }
                if (!foundUnicodeCodePoint) {
                    this.currentPos = pos;
                }
            }
        } else {
            currentChar = -1;
        }
        return currentChar;
    }

    public int peekChar() throws IOException {
        int result = this.nextChar();
        if (result != -1) {
            --this.currentPos;
        }
        return result;
    }

    public void pushBack(int c) {
        if (c != -1) {
            assert (c >= 0);
            assert (this.currentPos > 0);
            this.buffer[--this.currentPos] = (char)c;
        }
    }

    public void mark() {
        this.markPos = this.currentPos;
    }

    public void reset() {
        assert (this.markPos != -1);
        this.currentPos = this.markPos;
    }

    public void reset(int delta) {
        assert (this.markPos != -1);
        this.markPos += delta;
        this.currentPos = this.markPos;
    }

    public void repeatLastToken() {
        this.repeat = true;
    }

    @Override
    public int nextToken() throws IOException {
        if (this.repeat) {
            this.repeat = false;
            return this.currentToken & 0xFFF;
        }
        do {
            this.updatePosition();
            this.currentToken = this.tokenize();
            this.currentToken = this.filterToken(this.currentToken);
        } while (this.currentToken < 0);
        return this.currentToken & 0xFFF;
    }

    @Override
    public int getCurrentToken() {
        return this.currentToken & 0xFFF;
    }

    @Override
    public int getCurrentTokenCode() {
        return this.currentToken;
    }

    @Override
    public boolean isWeakToken() {
        return this.currentToken >> 12 != 0;
    }

    @Override
    public boolean isWeakToken(int tok) {
        return tok >> 12 != 0;
    }

    @Override
    public int getAlternateToken() {
        return this.currentToken >> 12;
    }

    @Override
    public Position getPosition() {
        return new Position(this.inputName, this.line, this.column, this.bufferOffset + this.tokenPos, this.currentPos - this.tokenPos);
    }

    public int getColumn() {
        return this.column;
    }

    @Override
    public int getLine() {
        return this.line;
    }

    @Override
    public int getOffset() {
        return this.bufferOffset + this.tokenPos;
    }

    public String getInputName() {
        return this.inputName;
    }

    @Override
    public String getLexeme() {
        if (this.currentToken == 0) {
            return "eof";
        }
        return new String(this.buffer, this.tokenPos, this.currentPos - this.tokenPos);
    }

    @Override
    public String getPrintableLexeme() {
        String result = this.getLexeme();
        int len = result.length();
        if (len == 0) {
            result = this.decode(this.currentToken & 0xFFF);
        } else {
            int i = 0;
            while (i < len) {
                if (result.charAt(i) < ' ') {
                    result = this.decode(this.currentToken & 0xFFF);
                    break;
                }
                ++i;
            }
        }
        return result;
    }

    @Override
    public int gotoPosition(Object mark) {
        throw new UnsupportedOperationException();
    }

    @Override
    public Object markPosition() {
        throw new UnsupportedOperationException();
    }

    @Override
    public void releasePosition(Object mark) {
        throw new UnsupportedOperationException();
    }
}

