/*
 * Decompiled with CFR 0.152.
 */
package com.hello2morrow.sonargraph.client.eclipse.application;

import com.hello2morrow.sonargraph.client.eclipse.application.BundleController;
import com.hello2morrow.sonargraph.client.eclipse.application.LanguageProviderExtension;
import com.hello2morrow.sonargraph.core.application.ILicenseHandlerProvider;
import com.hello2morrow.sonargraph.core.application.SonargraphApplication;
import com.hello2morrow.sonargraph.core.command.common.SonargraphLicense;
import com.hello2morrow.sonargraph.core.command.common.SonargraphLicenseHandler;
import com.hello2morrow.sonargraph.core.command.system.CoreCommandProvider;
import com.hello2morrow.sonargraph.core.foundation.common.base.Language;
import com.hello2morrow.sonargraph.core.model.common.AnalyzerExecutionLevel;
import com.hello2morrow.sonargraph.core.model.common.SonargraphFeature;
import com.hello2morrow.sonargraph.core.model.common.SonargraphProduct;
import com.hello2morrow.sonargraph.core.model.script.ScriptOutputStreamProvider;
import com.hello2morrow.sonargraph.core.model.system.ILanguageProvider;
import com.hello2morrow.sonargraph.core.model.system.ISoftwareSystemProvider;
import com.hello2morrow.sonargraph.foundation.utilities.OperationResult;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import org.osgi.framework.BundleContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class EclipseApplication {
    private static final Logger LOGGER = LoggerFactory.getLogger(EclipseApplication.class);
    private final long m_start;
    private final SonargraphApplication m_application;
    private final BundleHandling m_bundleHandling;

    public EclipseApplication(BundleHandling bundleHandling, SonargraphProduct product) {
        assert (bundleHandling != null) : "Parameter 'bundleHandling' of method 'EclipseApplication' must not be null";
        assert (product != null) : "Parameter 'product' of method 'EclipseApplication' must not be null";
        this.m_start = System.currentTimeMillis();
        this.m_application = new SonargraphApplication(product);
        this.m_bundleHandling = bundleHandling;
    }

    protected SonargraphProduct getProduct() {
        return this.m_application.getProduct();
    }

    protected void languageProviderExtensionFound(LanguageProviderExtension languageProviderExtension) {
        assert (languageProviderExtension != null) : "Parameter 'languageProviderExtension' of method 'languageProviderExtensionFound' must not be null";
    }

    protected Set<String> getSpecifiedLanguages() {
        return this.m_application.determineSpecifiedLanguagesFromEnvironment();
    }

    public void startupComplete() {
        LOGGER.info("Startup complete '" + this.getProduct().getStandardName() + "' [" + (System.currentTimeMillis() - this.m_start) + " ms]");
    }

    public void shutdownStarted(ISoftwareSystemProvider provider) {
        this.m_application.shutdownStarted(provider);
    }

    public void shutdown() {
        this.m_application.shutdown();
    }

    public final ISoftwareSystemProvider initialize(BundleContext bundleContext, ScriptOutputStreamProvider outputStreamProvider, Set<String> languages, AnalyzerExecutionLevel level, ILicenseHandlerProvider licenseHandlerProvider, SonargraphLicenseHandler.ILicenseLostEventHandler licenseLostHandler) {
        assert (outputStreamProvider != null) : "Parameter 'outputStreamProvider' of method 'initialize' must not be null";
        assert (languages != null) : "Parameter 'languages' of method 'initialize' must not be null";
        assert (level != null) : "Parameter 'level' of method 'initialize' must not be null";
        LOGGER.debug("Initializing SoftwareSystemProvider");
        BundleController bundleController = new BundleController(this.m_application);
        List<LanguageProviderExtension> availableLanguageProviderExtensions = bundleController.getAvailableExtensions();
        Set<Language> availableLanguages = bundleController.getAvailableLanguages();
        this.m_application.initializeLicenseHandler(licenseHandlerProvider, availableLanguages, licenseLostHandler);
        SonargraphLicenseHandler licenseHandler = this.m_application.getLicenseHandler();
        ArrayList<Object> commandProviders = new ArrayList<Object>();
        commandProviders.add(new CoreCommandProvider());
        List<LanguageProviderExtension> licensedLpExtensions = this.m_bundleHandling == BundleHandling.DYNAMIC ? bundleController.uninstallBundlesOfUnlicensedLanguages(availableLanguageProviderExtensions, licenseHandler, bundleContext, languages) : bundleController.getAvailableExtensions();
        if (!licenseHandler.isFeatureAvailable(SonargraphFeature.PLUGINS)) {
            bundleController.uninstallPluginBundles(bundleContext);
        }
        ArrayList<ILanguageProvider> languageProviders = new ArrayList<ILanguageProvider>();
        for (LanguageProviderExtension next : licensedLpExtensions) {
            commandProviders.addAll(next.getCommandProviders());
            languageProviders.add(next.getLanguageProvider());
            this.languageProviderExtensionFound(next);
        }
        this.m_application.finishInitialization(commandProviders);
        LOGGER.info("Product: " + licenseHandler.getProduct().getPresentationName() + " " + String.valueOf(licenseHandler.getProductVersion()));
        if (licenseHandler.hasValidLicense()) {
            LOGGER.info("License type: " + licenseHandler.getLicenseType());
            StringBuilder builder = new StringBuilder("Licensed features: ");
            for (SonargraphFeature nextFeature : licenseHandler.getAvailableFeatures()) {
                builder.append(nextFeature);
                builder.append(", ");
            }
            if (builder.toString().endsWith(", ")) {
                builder.delete(builder.length() - 2, builder.length());
            }
            LOGGER.info(builder.toString());
            LOGGER.info("License is valid");
            LOGGER.debug("Creating SoftwareSystemProvider");
            ISoftwareSystemProvider createSoftwareSystemProvider = this.m_application.createSoftwareSystemProvider(languageProviders, outputStreamProvider, level);
            LOGGER.debug("Creating SoftwareSystemProvider - done");
            return createSoftwareSystemProvider;
        }
        if (!licenseHandler.hasLicense()) {
            LOGGER.info("License not valid (no license created)");
        } else {
            SonargraphLicense license = licenseHandler.getLicense();
            List all = license.getAllValidationResults();
            if (all.isEmpty()) {
                LOGGER.info("License not valid (no validation results)");
            }
            StringBuilder builder = new StringBuilder("License not valid:");
            for (OperationResult next : all) {
                builder.append("\n");
                builder.append(next);
            }
            LOGGER.info(builder.toString());
        }
        return null;
    }

    public boolean isInitialized() {
        return this.m_application.isInitialized();
    }

    public static enum BundleHandling {
        DYNAMIC,
        STATIC;

    }
}

