/*
 * Decompiled with CFR 0.152.
 */
package com.hello2morrow.sonargraph.languageprovider.typescript.controller.system;

import com.hello2morrow.sonargraph.api.IPluginCoreAccess;
import com.hello2morrow.sonargraph.core.controller.generic.GenericLanguageProvider;
import com.hello2morrow.sonargraph.core.controller.system.IAddedOrChangedSourceFileProcessor;
import com.hello2morrow.sonargraph.core.controller.system.IKeywordProvider;
import com.hello2morrow.sonargraph.core.controller.system.LanguageProviderRefactoringAdapter;
import com.hello2morrow.sonargraph.core.controller.system.LanguageProviderRefactoringDescriptorProvider;
import com.hello2morrow.sonargraph.core.controller.system.analysis.base.AnalyzerAdapter;
import com.hello2morrow.sonargraph.core.controller.system.analysis.base.IAnalyzerController;
import com.hello2morrow.sonargraph.core.controller.system.base.IFinishModelProcessor;
import com.hello2morrow.sonargraph.core.controller.system.base.RelativeCyclicityMetricIds;
import com.hello2morrow.sonargraph.core.controller.system.parser.ISourceLineProcessor;
import com.hello2morrow.sonargraph.core.controller.system.script.CoreAccess;
import com.hello2morrow.sonargraph.core.controller.system.script.internal.ScriptApi;
import com.hello2morrow.sonargraph.core.foundation.common.base.CoreResourceProviderAdapter;
import com.hello2morrow.sonargraph.core.foundation.common.base.Language;
import com.hello2morrow.sonargraph.core.foundation.common.base.RelevantSourceLinesScanner;
import com.hello2morrow.sonargraph.core.model.analysis.IConfigurableAnalyzerId;
import com.hello2morrow.sonargraph.core.model.analysis.IMetricId;
import com.hello2morrow.sonargraph.core.model.architecture.IAssignableAttributeRetriever;
import com.hello2morrow.sonargraph.core.model.common.IMetricLevel;
import com.hello2morrow.sonargraph.core.model.element.GenericStructureItem;
import com.hello2morrow.sonargraph.core.model.element.IProviderId;
import com.hello2morrow.sonargraph.core.model.element.IStructureItem;
import com.hello2morrow.sonargraph.core.model.element.NamedElement;
import com.hello2morrow.sonargraph.core.model.event.Modification;
import com.hello2morrow.sonargraph.core.model.generic.programming.GenericField;
import com.hello2morrow.sonargraph.core.model.generic.programming.GenericFunction;
import com.hello2morrow.sonargraph.core.model.generic.programming.GenericMethod;
import com.hello2morrow.sonargraph.core.model.generic.programming.GenericPackage;
import com.hello2morrow.sonargraph.core.model.generic.programming.GenericRootDirectory;
import com.hello2morrow.sonargraph.core.model.generic.programming.GenericScript;
import com.hello2morrow.sonargraph.core.model.metrics.CoreMetricLevel;
import com.hello2morrow.sonargraph.core.model.path.ISourceFileRegionVisitor;
import com.hello2morrow.sonargraph.core.model.script.IMetricIdProvider;
import com.hello2morrow.sonargraph.core.model.system.Extension;
import com.hello2morrow.sonargraph.core.model.system.IAdditionalDynamicInfoProvider;
import com.hello2morrow.sonargraph.core.model.system.IMetricAccessor;
import com.hello2morrow.sonargraph.core.model.system.ISoftwareSystemProvider;
import com.hello2morrow.sonargraph.core.model.system.Installation;
import com.hello2morrow.sonargraph.core.model.system.ModuleDelta;
import com.hello2morrow.sonargraph.core.model.system.PrepareRefreshResult;
import com.hello2morrow.sonargraph.core.model.system.SoftwareSystem;
import com.hello2morrow.sonargraph.core.model.system.settings.SystemSettings;
import com.hello2morrow.sonargraph.core.model.workspace.External;
import com.hello2morrow.sonargraph.core.model.workspace.IFilePathListener;
import com.hello2morrow.sonargraph.core.model.workspace.Module;
import com.hello2morrow.sonargraph.core.model.workspace.Workspace;
import com.hello2morrow.sonargraph.core.persistence.base.IAdditionalFileInfoProvider;
import com.hello2morrow.sonargraph.foundation.activity.IWorkerContext;
import com.hello2morrow.sonargraph.foundation.file.IFileType;
import com.hello2morrow.sonargraph.foundation.utilities.CategoryProvider;
import com.hello2morrow.sonargraph.foundation.utilities.OperationResult;
import com.hello2morrow.sonargraph.languageprovider.typescript.controller.settings.TypescriptSettingsExtension;
import com.hello2morrow.sonargraph.languageprovider.typescript.controller.system.TypeScriptRefactoringAdapter;
import com.hello2morrow.sonargraph.languageprovider.typescript.controller.system.TypescriptDynamicSystemInfoProvider;
import com.hello2morrow.sonargraph.languageprovider.typescript.controller.system.TypescriptMessageCause;
import com.hello2morrow.sonargraph.languageprovider.typescript.controller.system.TypescriptRefactoringDescriptorProvider;
import com.hello2morrow.sonargraph.languageprovider.typescript.controller.system.TypescriptWorkspaceExtension;
import com.hello2morrow.sonargraph.languageprovider.typescript.controller.system.analysis.TypeScriptDirectoryCyclesInSystemAnalyzerAdapter;
import com.hello2morrow.sonargraph.languageprovider.typescript.controller.system.analysis.TypeScriptDirectoryCyclesInSystemMetricsAnalyzerAdapter;
import com.hello2morrow.sonargraph.languageprovider.typescript.controller.system.analysis.TypescriptDirectoryCyclesInModulesAnalyzerAdapter;
import com.hello2morrow.sonargraph.languageprovider.typescript.controller.system.analysis.TypescriptDirectoryCyclesInModulesMetricAnalyzerAdapter;
import com.hello2morrow.sonargraph.languageprovider.typescript.controller.system.architecture.TypescriptExtendsClassRetriever;
import com.hello2morrow.sonargraph.languageprovider.typescript.controller.system.architecture.TypescriptImplementsInterfaceRetriever;
import com.hello2morrow.sonargraph.languageprovider.typescript.controller.system.architecture.TypescriptTypeofRetriever;
import com.hello2morrow.sonargraph.languageprovider.typescript.controller.system.parser.ModelBuilder;
import com.hello2morrow.sonargraph.languageprovider.typescript.controller.system.parser.TypescriptSourceLineProcessor;
import com.hello2morrow.sonargraph.languageprovider.typescript.controller.system.plugin.PluginTypescriptAccess;
import com.hello2morrow.sonargraph.languageprovider.typescript.controller.system.script.TypescriptAccess;
import com.hello2morrow.sonargraph.languageprovider.typescript.foundation.common.TypescriptLanguage;
import com.hello2morrow.sonargraph.languageprovider.typescript.model.element.TypescriptProviderId;
import com.hello2morrow.sonargraph.languageprovider.typescript.model.element.TypescriptStructureItem;
import com.hello2morrow.sonargraph.languageprovider.typescript.model.path.TypescriptFileType;
import com.hello2morrow.sonargraph.languageprovider.typescript.model.path.TypescriptSourceFile;
import com.hello2morrow.sonargraph.languageprovider.typescript.model.programming.TypescriptClass;
import com.hello2morrow.sonargraph.languageprovider.typescript.model.programming.TypescriptEnum;
import com.hello2morrow.sonargraph.languageprovider.typescript.model.programming.TypescriptFunctionOrMethod;
import com.hello2morrow.sonargraph.languageprovider.typescript.model.programming.TypescriptFunctionOrMethodWithBody;
import com.hello2morrow.sonargraph.languageprovider.typescript.model.programming.TypescriptInterface;
import com.hello2morrow.sonargraph.languageprovider.typescript.model.programming.TypescriptNamespace;
import com.hello2morrow.sonargraph.languageprovider.typescript.model.programming.TypescriptProperty;
import com.hello2morrow.sonargraph.languageprovider.typescript.model.programming.TypescriptTypeAlias;
import com.hello2morrow.sonargraph.languageprovider.typescript.model.programming.TypescriptVariable;
import com.hello2morrow.sonargraph.languageprovider.typescript.model.settings.TypescriptSystemSettings;
import com.hello2morrow.sonargraph.languageprovider.typescript.model.system.TypescriptAnalyzerId;
import com.hello2morrow.sonargraph.languageprovider.typescript.model.system.TypescriptIssueId;
import com.hello2morrow.sonargraph.languageprovider.typescript.model.system.TypescriptMetricId;
import com.hello2morrow.sonargraph.languageprovider.typescript.model.system.TypescriptMetricLevel;
import com.hello2morrow.sonargraph.languageprovider.typescript.model.workspace.TypescriptExternal;
import com.hello2morrow.sonargraph.languageprovider.typescript.model.workspace.TypescriptModule;
import com.hello2morrow.sonargraph.languageprovider.typescript.model.workspace.TypescriptModuleType;
import com.hello2morrow.sonargraph.languageprovider.typescript.persistence.system.TypescriptPersistenceProvider;
import com.hello2morrow.sonargraph.plugin.typescript.IPluginTypescriptAccess;
import de.schlichtherle.truezip.file.TFile;
import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.EnumSet;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;

public final class TypescriptLanguageProvider
extends GenericLanguageProvider
implements IKeywordProvider {
    private static final String[] IMPORT_START_TOKENS = new String[]{"import"};
    private static final Set<String> KEYWORDS;
    private TFile m_userHome;
    private TFile m_typescriptHome;
    private String m_nodePath;

    static {
        String[] keywords = new String[]{"abstract", "as", "async", "await", "any", "boolean", "break", "case", "catch", "class", "const", "continue", "constructor", "debugger", "declare", "default", "do", "else", "enum", "export", "extends", "false", "finally", "for", "function", "get", "if", "import", "implements", "in", "interface", "is", "let", "module", "namespace", "new", "null", "number", "of", "private", "protected", "public", "readonly", "require", "return", "string", "set", "this", "throw", "true", "try", "typeof", "using", "undefined", "void", "while", "var", "yield"};
        KEYWORDS = new HashSet<String>(keywords.length);
        String[] stringArray = keywords;
        int n = keywords.length;
        int n2 = 0;
        while (n2 < n) {
            String nextKeyword = stringArray[n2];
            KEYWORDS.add(nextKeyword);
            ++n2;
        }
    }

    public TypescriptLanguageProvider() {
        super((Language)TypescriptLanguage.INSTANCE, TypescriptModule.class, (LanguageProviderRefactoringAdapter)new TypeScriptRefactoringAdapter(KEYWORDS));
    }

    public void initialize(Installation installation, IFinishModelProcessor finishModelProcessor) {
        super.initialize(installation, finishModelProcessor);
        if (this.m_userHome == null) {
            this.m_userHome = CoreResourceProviderAdapter.getInstance().getSonargraphUserHomeDir();
        }
        this.m_typescriptHome = new TFile((File)this.m_userHome, "typescript");
        if (!this.m_typescriptHome.isDirectory()) {
            this.m_typescriptHome.mkdirs();
        }
        installation.addExtension((Extension)new TypescriptSettingsExtension(this.m_typescriptHome));
    }

    public void setUserHome(TFile dir) {
        assert (dir != null) : "Parameter 'dir' of method 'setUserHome' must not be null";
        this.m_userHome = dir;
    }

    public IAdditionalDynamicInfoProvider getDynamicSystemInfoProvider() {
        return new TypescriptDynamicSystemInfoProvider();
    }

    protected ISourceLineProcessor createSourceLineProcessor() {
        return new TypescriptSourceLineProcessor();
    }

    public final List<IAssignableAttributeRetriever> createAssignableAttributeRetrievers() {
        return List.of(new TypescriptExtendsClassRetriever(), new TypescriptImplementsInterfaceRetriever(), new TypescriptTypeofRetriever());
    }

    public Set<String> getKeywords(IFileType fileType) {
        assert (fileType != null) : "Parameter 'fileType' of method 'getKeywords' must not be null";
        return Collections.unmodifiableSet(KEYWORDS);
    }

    public void initialize(SoftwareSystem softwareSystem, IFinishModelProcessor finishModelProcessor) {
        super.initialize(softwareSystem, finishModelProcessor);
        softwareSystem.addExtension((Extension)new TypescriptWorkspaceExtension(softwareSystem));
    }

    public void aboutToCreateFirstModule(SoftwareSystem softwareSystem) {
        super.aboutToCreateFirstModule(softwareSystem);
        Workspace workspace = (Workspace)softwareSystem.getUniqueExistingChild(Workspace.class);
        assert (!workspace.hasChildren(false, new Class[]{this.getExternalClass()})) : "Already created external node";
        workspace.addChild((NamedElement)new TypescriptExternal((NamedElement)workspace));
    }

    public IMetricLevel getNamespaceMetricLevel() {
        return TypescriptMetricLevel.TYPESCRIPT_NAMESPACE;
    }

    public IMetricId getNamespacesMetricId() {
        return TypescriptMetricId.TYPESCRIPT_NAMESPACES;
    }

    public Set<RelativeCyclicityMetricIds> getRelativeCyclicityMetricIds() {
        return Set.of(new RelativeCyclicityMetricIds((IMetricId)TypescriptMetricId.TYPESCRIPT_DIRECTORIES_FULLY_ANALYZED, (IMetricId)TypescriptMetricId.TYPESCRIPT_RELATIVE_CYCLICITY_DIRECTORIES, (IMetricId)TypescriptMetricId.TYPESCRIPT_AVERAGE_RELATIVE_CYCLICITY_DIRECTORIES));
    }

    public IMetricId getDirectoriesMetricId() {
        return TypescriptMetricId.TYPESCRIPT_DIRECTORIES;
    }

    public IMetricId getFullyAnalyzedDirectoriesMetricId() {
        return TypescriptMetricId.TYPESCRIPT_DIRECTORIES_FULLY_ANALYZED;
    }

    public IMetricLevel getDirectoryMetricLevel() {
        return TypescriptMetricLevel.TYPESCRIPT_DIRECTORY;
    }

    public IMetricId getFullyAnalyzedNamespacesMetricId() {
        return TypescriptMetricId.TYPESCRIPT_NAMESPACES_FULLY_ANALYZED;
    }

    public Double computeLanguageSpecificMaintainabilityLevel(SoftwareSystem system, Module module) {
        assert (system != null) : "Parameter 'system' of method 'computeLanguageSpecificMaintainabilityLevel' must not be null";
        assert (module != null) : "Parameter 'module' of method 'computeLanguageSpecificMaintainabilityLevel' must not be null";
        IMetricAccessor ma = (IMetricAccessor)((ISoftwareSystemProvider)system.getExtension(ISoftwareSystemProvider.class)).getInstallation().getExtension(IMetricAccessor.class);
        Number relativeDirectoryCyclicity = ma.getMetricValue(system, (NamedElement)module, (IMetricLevel)CoreMetricLevel.MODULE, (IMetricId)TypescriptMetricId.TYPESCRIPT_RELATIVE_CYCLICITY_DIRECTORIES, false);
        if (relativeDirectoryCyclicity == null) {
            return null;
        }
        Number numberOfDirectories = ma.getMetricValue(system, (NamedElement)module, (IMetricLevel)CoreMetricLevel.MODULE, (IMetricId)TypescriptMetricId.TYPESCRIPT_NAMESPACES_FULLY_ANALYZED, false);
        if (numberOfDirectories == null) {
            return null;
        }
        double ml = 100.0 - relativeDirectoryCyclicity.doubleValue();
        double noDirs = numberOfDirectories.doubleValue();
        if (noDirs < 20.0) {
            ml = 100.0 * (20.0 - noDirs) / 20.0 + noDirs / 20.0 * ml;
        }
        return ml;
    }

    public void addPluginAccess(Installation installation, SoftwareSystem softwareSystem, Map<Class<? extends IPluginCoreAccess>, IPluginCoreAccess> access) {
        assert (installation != null) : "Parameter 'installation' of method 'addPluginAccess' must not be null";
        assert (softwareSystem != null) : "Parameter 'softwareSystem' of method 'addPluginAccess' must not be null";
        assert (access != null) : "Parameter 'access' of method 'addPluginAccess' must not be null";
        access.put(IPluginTypescriptAccess.class, (IPluginCoreAccess)new PluginTypescriptAccess(installation, softwareSystem));
    }

    public void accept(final ISourceFileRegionVisitor visitor, String content, IFileType fileType) {
        assert (visitor != null) : "Parameter 'visitor' of method 'accept' must not be null";
        assert (content != null) : "Parameter 'content' of method 'accept' must not be null";
        TypescriptSourceLineProcessor sourceLineProcessor = new TypescriptSourceLineProcessor();
        sourceLineProcessor.accept(content, new ISourceLineProcessor.SourceLineVisitor(){

            public void visitCharLiteral(int offset, String c) {
                if (!$assertionsDisabled && c == null) {
                    throw new AssertionError((Object)"Parameter 'c' of method 'visitCharLiteral' must not be null");
                }
                visitor.visitLiteral(offset, c.length());
            }

            public void visitStringLiteral(int offset, String s) {
                if (!$assertionsDisabled && s == null) {
                    throw new AssertionError((Object)"Parameter 's' of method 'visitStringLiteral' must not be null");
                }
                visitor.visitLiteral(offset, s.length());
            }

            public void visitSingleLineComment(int offset, String comment) {
                if (!$assertionsDisabled && comment == null) {
                    throw new AssertionError((Object)"Parameter 'comment' of method 'visitSingleLineComment' must not be null");
                }
                visitor.visitComment(offset, comment.length());
            }

            public void visitMultiLineComment(int offset, String comment) {
                if (!$assertionsDisabled && comment == null) {
                    throw new AssertionError((Object)"Parameter 'comment' of method 'visitMultiLineComment' must not be null");
                }
                visitor.visitComment(offset, comment.length());
            }

            public void visitWord(int offset, String word) {
                if (!$assertionsDisabled && word == null) {
                    throw new AssertionError((Object)"Parameter 'comment' of method 'word' must not be null");
                }
                if (KEYWORDS.contains(word)) {
                    visitor.visitKeyword(offset, word.length());
                }
            }
        });
    }

    public CategoryProvider getPhysicalCategoryProvider() {
        CategoryProvider cp = new CategoryProvider();
        cp.setCategory(TypescriptModule.class, 1);
        cp.setCategory(GenericPackage.class, 10);
        cp.setCategory(TypescriptTypeAlias.class, 75);
        cp.setCategory(TypescriptNamespace.class, 10);
        cp.setCategory(TypescriptSourceFile.class, 100);
        cp.setCategory(GenericField.class, 80);
        cp.setCategory(TypescriptProperty.class, 85);
        cp.setCategory(TypescriptVariable.class, 60);
        cp.setCategory(GenericMethod.class, 90);
        cp.setCategory(TypescriptFunctionOrMethod.class, 90);
        cp.setCategory(TypescriptFunctionOrMethodWithBody.class, 90);
        cp.setCategory(GenericScript.class, 90);
        cp.setCategory(GenericFunction.class, 65);
        cp.setCategory(TypescriptInterface.class, 65);
        cp.setCategory(TypescriptClass.class, 70);
        cp.setCategory(TypescriptEnum.class, 0);
        cp.setCategory(GenericRootDirectory.class, 10);
        cp.setCategory(TypescriptExternal.class, 1000);
        return cp;
    }

    public Set<? extends IConfigurableAnalyzerId> getAnalyzerIds() {
        return EnumSet.allOf(TypescriptAnalyzerId.class);
    }

    public List<? extends AnalyzerAdapter> getAnalyzerAdapters(IAnalyzerController controller, Set<IConfigurableAnalyzerId> licensedAnalyzerIds) {
        assert (controller != null) : "Parameter 'controller' of method 'getAnalyzerAdapters' must not be null";
        assert (licensedAnalyzerIds != null) : "Parameter 'licensedAnalyzerIds' of method 'getAnalyzerAdapters' must not be null";
        ArrayList<Object> result = new ArrayList<Object>();
        if (licensedAnalyzerIds.contains(TypescriptDirectoryCyclesInModulesAnalyzerAdapter.ID)) {
            result.add((Object)new TypescriptDirectoryCyclesInModulesAnalyzerAdapter(controller));
        }
        if (licensedAnalyzerIds.contains(TypescriptDirectoryCyclesInModulesMetricAnalyzerAdapter.ID)) {
            result.add((Object)new TypescriptDirectoryCyclesInModulesMetricAnalyzerAdapter(controller));
        }
        if (licensedAnalyzerIds.contains(TypeScriptDirectoryCyclesInSystemAnalyzerAdapter.ID)) {
            result.add((Object)new TypeScriptDirectoryCyclesInSystemAnalyzerAdapter(controller));
        }
        if (licensedAnalyzerIds.contains(TypeScriptDirectoryCyclesInSystemMetricsAnalyzerAdapter.ID)) {
            result.add((Object)new TypeScriptDirectoryCyclesInSystemMetricsAnalyzerAdapter(controller));
        }
        return result;
    }

    protected CoreAccess getSystemAccess(Installation installation, SoftwareSystem system, IMetricIdProvider metricIdProvider, ScriptApi api) {
        return new TypescriptAccess(installation, system, metricIdProvider, api);
    }

    public Set<TypescriptIssueId> getIssueIds() {
        return EnumSet.allOf(TypescriptIssueId.class);
    }

    public boolean prepareRefresh(IWorkerContext workerContext, SoftwareSystem softwareSystem, PrepareRefreshResult result) {
        assert (workerContext != null) : "Parameter 'workerContext' of method 'prepareRefresh' must not be null";
        assert (softwareSystem != null) : "Parameter 'softwareSystem' of method 'isRefreshPossible' must not be null";
        assert (result != null) : "Parameter 'result' of method 'isRefreshPossible' must not be null";
        this.m_nodePath = null;
        TypescriptSettingsExtension settingsExt = (TypescriptSettingsExtension)((ISoftwareSystemProvider)softwareSystem.getExtension(ISoftwareSystemProvider.class)).getInstallation().getExtension(TypescriptSettingsExtension.class);
        TFile nodeExecutable = settingsExt.getNodeFile();
        if (nodeExecutable == null) {
            result.addError((OperationResult.IMessageCause)TypescriptMessageCause.CANNOT_FIND_NODEJS, "Cannot locate the NodeJS executable", new Object[0]);
        } else {
            this.m_nodePath = nodeExecutable.getNormalizedAbsolutePath();
            List typescriptModules = ((Workspace)softwareSystem.getUniqueExistingChild(Workspace.class)).getChildren(TypescriptModule.class);
            result.setParserRefreshPossible(this.getLanguage(), typescriptModules.size() > 0);
        }
        return false;
    }

    public void aboutToRefreshModules(IWorkerContext workerContext, SoftwareSystem softwareSystem, OperationResult result, Set<ISoftwareSystemProvider.IRefreshOption> refreshOptions, List<ModuleDelta> moduleDeltas, IFilePathListener listener) {
        assert (false) : "Unexpected call";
    }

    public boolean refreshSystem(IWorkerContext workerContext, SoftwareSystem softwareSystem, OperationResult result) {
        assert (workerContext != null) : "Parameter 'workerContext' of method 'refreshSystem' must not be null";
        assert (softwareSystem != null) : "Parameter 'softwareSystem' of method 'refreshSystem' must not be null";
        assert (result != null) : "Parameter 'result' of method 'refreshSystem' must not be null";
        ModelBuilder mb = new ModelBuilder((IAddedOrChangedSourceFileProcessor)this, softwareSystem);
        result.addMessagesFrom(mb.buildModel(workerContext, this.m_nodePath));
        return result.isSuccess();
    }

    public LanguageProviderRefactoringDescriptorProvider getRefactoringDescriptorProvider() {
        return new TypescriptRefactoringDescriptorProvider();
    }

    protected RelevantSourceLinesScanner.ScannerInfo getScannerInfo() {
        return new RelevantSourceLinesScanner.ScannerInfo(IMPORT_START_TOKENS);
    }

    protected Class<? extends External> getExternalClass() {
        return TypescriptExternal.class;
    }

    public IAdditionalFileInfoProvider getPersistenceProvider(Installation installation) {
        return new TypescriptPersistenceProvider(installation);
    }

    public IProviderId getProviderId() {
        return TypescriptProviderId.INSTANCE;
    }

    protected Module.IModuleType getModuleType(String moduleTypeStandardName) {
        assert (moduleTypeStandardName != null && moduleTypeStandardName.length() > 0) : "Parameter 'moduleTypeStandardName' of method 'getModuleType' must not be empty";
        if (TypescriptModuleType.TYPESCRIPT_MODULE.getStandardName().equals(moduleTypeStandardName)) {
            return TypescriptModuleType.TYPESCRIPT_MODULE;
        }
        return null;
    }

    protected Module createModule(SoftwareSystem system, Module.IModuleType type, String id, String name, String description) {
        Workspace workspace = (Workspace)system.getUniqueExistingChild(Workspace.class);
        TypescriptModule result = new TypescriptModule((NamedElement)workspace, name, id);
        workspace.addChild((NamedElement)result);
        result.setDescription(description);
        return result;
    }

    protected List<IStructureItem> getPhysicalStructureItems() {
        return Arrays.asList(new IStructureItem[]{GenericStructureItem.MODULE, GenericStructureItem.ROOT_DIRECTORY, GenericStructureItem.DIRECTORY_FRAGMENT, GenericStructureItem.SOURCE_FILE, TypescriptStructureItem.NAMESPACE, GenericStructureItem.PROGRAMMING_ELEMENT});
    }

    public String getBundleId() {
        return "com.hello2morrow.sonargraph.language.provider.typescript";
    }

    public Collection<String> getSourceExtensions() {
        ArrayList<String> extensions = new ArrayList<String>();
        String[] stringArray = TypescriptFileType.SOURCE_FILE.getExtensions();
        int n = stringArray.length;
        int n2 = 0;
        while (n2 < n) {
            String ext = stringArray[n2];
            extensions.add(ext);
            ++n2;
        }
        return extensions;
    }

    protected EnumSet<Modification> moveSoftwareSystemElements(Workspace sourceWorkspace, Workspace targetWorkspace) {
        EnumSet modifications = super.moveSoftwareSystemElements(sourceWorkspace, targetWorkspace);
        SystemSettings sourceSystemSettings = (SystemSettings)sourceWorkspace.getUniqueChild(TypescriptSystemSettings.class);
        if (sourceSystemSettings != null) {
            assert (sourceSystemSettings != null) : "'sourceSystemSettings' must not be null";
            SystemSettings targetSystemSettings = (SystemSettings)targetWorkspace.getUniqueChild(TypescriptSystemSettings.class);
            if (targetSystemSettings != null) {
                targetSystemSettings.remove();
            }
            sourceSystemSettings.changeParent((NamedElement)targetWorkspace, true);
        }
        return modifications;
    }

    public boolean controlsParserModelRefresh() {
        return true;
    }

    public boolean checkWorkspaceDependenciesFromSnapshot() {
        return false;
    }

    public boolean moduleOrderIsRelevant() {
        return false;
    }

    public boolean supportsDeltaRefresh() {
        return false;
    }
}

